/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jackson.core.sym;

import java.util.Arrays;
import org.elasticsearch.common.jackson.core.util.InternCache;

public final class CharsToNameCanonicalizer {
    public static final int HASH_MULT = 33;
    protected static final int DEFAULT_TABLE_SIZE = 64;
    protected static final int MAX_TABLE_SIZE = 65536;
    static final int MAX_ENTRIES_FOR_REUSE = 12000;
    static final int MAX_COLL_CHAIN_LENGTH = 255;
    static final int MAX_COLL_CHAIN_FOR_REUSE = 63;
    static final CharsToNameCanonicalizer sBootstrapSymbolTable = new CharsToNameCanonicalizer();
    protected CharsToNameCanonicalizer _parent;
    private final int _hashSeed;
    protected final boolean _intern;
    protected final boolean _canonicalize;
    protected String[] _symbols;
    protected Bucket[] _buckets;
    protected int _size;
    protected int _sizeThreshold;
    protected int _indexMask;
    protected int _longestCollisionList;
    protected boolean _dirty;

    public static CharsToNameCanonicalizer createRoot() {
        long now = System.currentTimeMillis();
        int seed2 = (int)now + (int)(now >>> 32) | 1;
        return CharsToNameCanonicalizer.createRoot(seed2);
    }

    protected static CharsToNameCanonicalizer createRoot(int hashSeed) {
        return sBootstrapSymbolTable.makeOrphan(hashSeed);
    }

    private CharsToNameCanonicalizer() {
        this._canonicalize = true;
        this._intern = true;
        this._dirty = true;
        this._hashSeed = 0;
        this._longestCollisionList = 0;
        this.initTables(64);
    }

    private void initTables(int initialSize) {
        this._symbols = new String[initialSize];
        this._buckets = new Bucket[initialSize >> 1];
        this._indexMask = initialSize - 1;
        this._size = 0;
        this._longestCollisionList = 0;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(initialSize);
    }

    private static int _thresholdSize(int hashAreaSize) {
        return hashAreaSize - (hashAreaSize >> 2);
    }

    private CharsToNameCanonicalizer(CharsToNameCanonicalizer parent, boolean canonicalize, boolean intern2, String[] symbols2, Bucket[] buckets, int size2, int hashSeed, int longestColl) {
        this._parent = parent;
        this._canonicalize = canonicalize;
        this._intern = intern2;
        this._symbols = symbols2;
        this._buckets = buckets;
        this._size = size2;
        this._hashSeed = hashSeed;
        int arrayLen = symbols2.length;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(arrayLen);
        this._indexMask = arrayLen - 1;
        this._longestCollisionList = longestColl;
        this._dirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharsToNameCanonicalizer makeChild(boolean canonicalize, boolean intern2) {
        int longestCollisionList;
        int hashSeed;
        int size2;
        Bucket[] buckets;
        String[] symbols2;
        CharsToNameCanonicalizer charsToNameCanonicalizer = this;
        synchronized (charsToNameCanonicalizer) {
            symbols2 = this._symbols;
            buckets = this._buckets;
            size2 = this._size;
            hashSeed = this._hashSeed;
            longestCollisionList = this._longestCollisionList;
        }
        return new CharsToNameCanonicalizer(this, canonicalize, intern2, symbols2, buckets, size2, hashSeed, longestCollisionList);
    }

    private CharsToNameCanonicalizer makeOrphan(int seed2) {
        return new CharsToNameCanonicalizer(null, true, true, this._symbols, this._buckets, this._size, seed2, this._longestCollisionList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeChild(CharsToNameCanonicalizer child) {
        if (child.size() > 12000 || child._longestCollisionList > 63) {
            CharsToNameCanonicalizer charsToNameCanonicalizer = this;
            synchronized (charsToNameCanonicalizer) {
                this.initTables(64);
                this._dirty = false;
            }
        }
        if (child.size() <= this.size()) {
            return;
        }
        CharsToNameCanonicalizer charsToNameCanonicalizer = this;
        synchronized (charsToNameCanonicalizer) {
            this._symbols = child._symbols;
            this._buckets = child._buckets;
            this._size = child._size;
            this._sizeThreshold = child._sizeThreshold;
            this._indexMask = child._indexMask;
            this._longestCollisionList = child._longestCollisionList;
            this._dirty = false;
        }
    }

    public void release() {
        if (!this.maybeDirty()) {
            return;
        }
        if (this._parent != null) {
            this._parent.mergeChild(this);
            this._dirty = false;
        }
    }

    public int size() {
        return this._size;
    }

    public int bucketCount() {
        return this._symbols.length;
    }

    public boolean maybeDirty() {
        return this._dirty;
    }

    public int hashSeed() {
        return this._hashSeed;
    }

    public int collisionCount() {
        int count2 = 0;
        for (Bucket bucket : this._buckets) {
            if (bucket == null) continue;
            count2 += bucket.length();
        }
        return count2;
    }

    public int maxCollisionLength() {
        return this._longestCollisionList;
    }

    public String findSymbol(char[] buffer, int start2, int len, int h) {
        if (len < 1) {
            return "";
        }
        if (!this._canonicalize) {
            return new String(buffer, start2, len);
        }
        int index2 = this._hashToIndex(h);
        String sym = this._symbols[index2];
        if (sym != null) {
            Bucket b;
            if (sym.length() == len) {
                int i2 = 0;
                while (sym.charAt(i2) == buffer[start2 + i2] && ++i2 < len) {
                }
                if (i2 == len) {
                    return sym;
                }
            }
            if ((b = this._buckets[index2 >> 1]) != null && (sym = b.find(buffer, start2, len)) != null) {
                return sym;
            }
        }
        if (!this._dirty) {
            this.copyArrays();
            this._dirty = true;
        } else if (this._size >= this._sizeThreshold) {
            this.rehash();
            index2 = this._hashToIndex(this.calcHash(buffer, start2, len));
        }
        String newSymbol = new String(buffer, start2, len);
        if (this._intern) {
            newSymbol = InternCache.instance.intern(newSymbol);
        }
        ++this._size;
        if (this._symbols[index2] == null) {
            this._symbols[index2] = newSymbol;
        } else {
            Bucket newB;
            int bix = index2 >> 1;
            this._buckets[bix] = newB = new Bucket(newSymbol, this._buckets[bix]);
            this._longestCollisionList = Math.max(newB.length(), this._longestCollisionList);
            if (this._longestCollisionList > 255) {
                this.reportTooManyCollisions(255);
            }
        }
        return newSymbol;
    }

    public int _hashToIndex(int rawHash) {
        rawHash += rawHash >>> 15;
        return rawHash & this._indexMask;
    }

    public int calcHash(char[] buffer, int start2, int len) {
        int hash2 = this._hashSeed;
        for (int i2 = 0; i2 < len; ++i2) {
            hash2 = hash2 * 33 + buffer[i2];
        }
        return hash2 == 0 ? 1 : hash2;
    }

    public int calcHash(String key2) {
        int len = key2.length();
        int hash2 = this._hashSeed;
        for (int i2 = 0; i2 < len; ++i2) {
            hash2 = hash2 * 33 + key2.charAt(i2);
        }
        return hash2 == 0 ? 1 : hash2;
    }

    private void copyArrays() {
        String[] oldSyms = this._symbols;
        int size2 = oldSyms.length;
        this._symbols = new String[size2];
        System.arraycopy(oldSyms, 0, this._symbols, 0, size2);
        Bucket[] oldBuckets = this._buckets;
        size2 = oldBuckets.length;
        this._buckets = new Bucket[size2];
        System.arraycopy(oldBuckets, 0, this._buckets, 0, size2);
    }

    private void rehash() {
        int i2;
        int size2 = this._symbols.length;
        int newSize = size2 + size2;
        if (newSize > 65536) {
            this._size = 0;
            Arrays.fill(this._symbols, null);
            Arrays.fill(this._buckets, null);
            this._dirty = true;
            return;
        }
        String[] oldSyms = this._symbols;
        Bucket[] oldBuckets = this._buckets;
        this._symbols = new String[newSize];
        this._buckets = new Bucket[newSize >> 1];
        this._indexMask = newSize - 1;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(newSize);
        int count2 = 0;
        int maxColl = 0;
        for (i2 = 0; i2 < size2; ++i2) {
            Bucket newB;
            String symbol = oldSyms[i2];
            if (symbol == null) continue;
            ++count2;
            int index2 = this._hashToIndex(this.calcHash(symbol));
            if (this._symbols[index2] == null) {
                this._symbols[index2] = symbol;
                continue;
            }
            int bix = index2 >> 1;
            this._buckets[bix] = newB = new Bucket(symbol, this._buckets[bix]);
            maxColl = Math.max(maxColl, newB.length());
        }
        size2 >>= 1;
        for (i2 = 0; i2 < size2; ++i2) {
            for (Bucket b = oldBuckets[i2]; b != null; b = b.getNext()) {
                Bucket newB;
                ++count2;
                String symbol = b.getSymbol();
                int index3 = this._hashToIndex(this.calcHash(symbol));
                if (this._symbols[index3] == null) {
                    this._symbols[index3] = symbol;
                    continue;
                }
                int bix = index3 >> 1;
                this._buckets[bix] = newB = new Bucket(symbol, this._buckets[bix]);
                maxColl = Math.max(maxColl, newB.length());
            }
        }
        this._longestCollisionList = maxColl;
        if (count2 != this._size) {
            throw new Error("Internal error on SymbolTable.rehash(): had " + this._size + " entries; now have " + count2 + ".");
        }
    }

    protected void reportTooManyCollisions(int maxLen) {
        throw new IllegalStateException("Longest collision chain in symbol table (of size " + this._size + ") now exceeds maximum, " + maxLen + " -- suspect a DoS attack based on hash collisions");
    }

    static final class Bucket {
        private final String _symbol;
        private final Bucket _next;
        private final int _length;

        public Bucket(String symbol, Bucket next) {
            this._symbol = symbol;
            this._next = next;
            this._length = next == null ? 1 : next._length + 1;
        }

        public String getSymbol() {
            return this._symbol;
        }

        public Bucket getNext() {
            return this._next;
        }

        public int length() {
            return this._length;
        }

        public String find(char[] buf, int start2, int len) {
            String sym = this._symbol;
            Bucket b = this._next;
            while (true) {
                if (sym.length() == len) {
                    int i2 = 0;
                    while (sym.charAt(i2) == buf[start2 + i2] && ++i2 < len) {
                    }
                    if (i2 == len) {
                        return sym;
                    }
                }
                if (b == null) break;
                sym = b.getSymbol();
                b = b.getNext();
            }
            return null;
        }
    }
}

