/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.error;

import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.error.Mark;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.error.YAMLException;

public class MarkedYAMLException
extends YAMLException {
    private static final long serialVersionUID = -9119388488683035101L;
    private String context;
    private Mark contextMark;
    private String problem;
    private Mark problemMark;
    private String note;

    protected MarkedYAMLException(String context, Mark contextMark, String problem, Mark problemMark, String note) {
        this(context, contextMark, problem, problemMark, note, null);
    }

    protected MarkedYAMLException(String context, Mark contextMark, String problem, Mark problemMark, String note, Throwable cause2) {
        super(context + "; " + problem, cause2);
        this.context = context;
        this.contextMark = contextMark;
        this.problem = problem;
        this.problemMark = problemMark;
        this.note = note;
    }

    protected MarkedYAMLException(String context, Mark contextMark, String problem, Mark problemMark) {
        this(context, contextMark, problem, problemMark, null, null);
    }

    protected MarkedYAMLException(String context, Mark contextMark, String problem, Mark problemMark, Throwable cause2) {
        this(context, contextMark, problem, problemMark, null, cause2);
    }

    public String toString() {
        StringBuilder lines2 = new StringBuilder();
        if (this.context != null) {
            lines2.append(this.context);
            lines2.append("\n");
        }
        if (this.contextMark != null && (this.problem == null || this.problemMark == null || this.contextMark.getName().equals(this.problemMark.getName()) || this.contextMark.getLine() != this.problemMark.getLine() || this.contextMark.getColumn() != this.problemMark.getColumn())) {
            lines2.append(this.contextMark.toString());
            lines2.append("\n");
        }
        if (this.problem != null) {
            lines2.append(this.problem);
            lines2.append("\n");
        }
        if (this.problemMark != null) {
            lines2.append(this.problemMark.toString());
            lines2.append("\n");
        }
        if (this.note != null) {
            lines2.append(this.note);
            lines2.append("\n");
        }
        return lines2.toString();
    }

    public String getContext() {
        return this.context;
    }

    public Mark getContextMark() {
        return this.contextMark;
    }

    public String getProblem() {
        return this.problem;
    }

    public Mark getProblemMark() {
        return this.problemMark;
    }
}

