/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jna;

import com.sun.jna.Native;
import org.elasticsearch.common.jna.CLibrary;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;

public class Natives {
    private static ESLogger logger = Loggers.getLogger(Natives.class);

    public static void tryMlockall() {
        int errno2 = Integer.MIN_VALUE;
        try {
            int result2 = CLibrary.mlockall(1);
            if (result2 != 0) {
                errno2 = Native.getLastError();
            }
        }
        catch (UnsatisfiedLinkError e) {
            return;
        }
        if (errno2 != Integer.MIN_VALUE) {
            if (errno2 == 12 && System.getProperty("os.name").toLowerCase().contains("linux")) {
                logger.warn("Unable to lock JVM memory (ENOMEM). This can result in part of the JVM being swapped out. Increase RLIMIT_MEMLOCK or run elasticsearch as root.", new Object[0]);
            } else if (!System.getProperty("os.name").toLowerCase().contains("mac")) {
                logger.warn("Unknown mlockall error " + errno2, new Object[0]);
            }
        }
    }
}

