/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.joda;

import org.elasticsearch.common.joda.time.DateTimeField;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.unit.TimeValue;

public abstract class TimeZoneRounding {
    public abstract long calc(long var1);

    public static Builder builder(DateTimeField field2) {
        return new Builder(field2);
    }

    public static Builder builder(TimeValue interval) {
        return new Builder(interval);
    }

    static class PrePostTimeZoneRounding
    extends TimeZoneRounding {
        private final TimeZoneRounding timeZoneRounding;
        private final long preOffset;
        private final long postOffset;

        PrePostTimeZoneRounding(TimeZoneRounding timeZoneRounding, long preOffset, long postOffset) {
            this.timeZoneRounding = timeZoneRounding;
            this.preOffset = preOffset;
            this.postOffset = postOffset;
        }

        @Override
        public long calc(long utcMillis) {
            return this.postOffset + this.timeZoneRounding.calc(utcMillis + this.preOffset);
        }
    }

    static class FactorTimeZoneRounding
    extends TimeZoneRounding {
        private final TimeZoneRounding timeZoneRounding;
        private final float factor;

        FactorTimeZoneRounding(TimeZoneRounding timeZoneRounding, float factor) {
            this.timeZoneRounding = timeZoneRounding;
            this.factor = factor;
        }

        @Override
        public long calc(long utcMillis) {
            return this.timeZoneRounding.calc((long)(this.factor * (float)utcMillis));
        }
    }

    static class DayIntervalTimeZoneRounding
    extends TimeZoneRounding {
        private final long interval;
        private final DateTimeZone preTz;
        private final DateTimeZone postTz;

        DayIntervalTimeZoneRounding(long interval, DateTimeZone preTz, DateTimeZone postTz) {
            this.interval = interval;
            this.preTz = preTz;
            this.postTz = postTz;
        }

        @Override
        public long calc(long utcMillis) {
            long time = utcMillis + (long)this.preTz.getOffset(utcMillis);
            time = time / this.interval * this.interval;
            time += (long)this.postTz.getOffset(time);
            return time;
        }
    }

    static class TimeIntervalTimeZoneRounding
    extends TimeZoneRounding {
        private final long interval;
        private final DateTimeZone preTz;
        private final DateTimeZone postTz;

        TimeIntervalTimeZoneRounding(long interval, DateTimeZone preTz, DateTimeZone postTz) {
            this.interval = interval;
            this.preTz = preTz;
            this.postTz = postTz;
        }

        @Override
        public long calc(long utcMillis) {
            long time = utcMillis + (long)this.preTz.getOffset(utcMillis);
            time = time / this.interval * this.interval;
            time -= (long)this.preTz.getOffset(time);
            time += (long)this.postTz.getOffset(time);
            return time;
        }
    }

    static class UTCIntervalTimeZoneRounding
    extends TimeZoneRounding {
        private final long interval;

        UTCIntervalTimeZoneRounding(long interval) {
            this.interval = interval;
        }

        @Override
        public long calc(long utcMillis) {
            return utcMillis / this.interval * this.interval;
        }
    }

    static class DayTimeZoneRoundingFloor
    extends TimeZoneRounding {
        private final DateTimeField field;
        private final DateTimeZone preTz;
        private final DateTimeZone postTz;

        DayTimeZoneRoundingFloor(DateTimeField field2, DateTimeZone preTz, DateTimeZone postTz) {
            this.field = field2;
            this.preTz = preTz;
            this.postTz = postTz;
        }

        @Override
        public long calc(long utcMillis) {
            long time = utcMillis + (long)this.preTz.getOffset(utcMillis);
            time = this.field.roundFloor(time);
            time += (long)this.postTz.getOffset(time);
            return time;
        }
    }

    static class UTCTimeZoneRoundingFloor
    extends TimeZoneRounding {
        private final DateTimeField field;

        UTCTimeZoneRoundingFloor(DateTimeField field2) {
            this.field = field2;
        }

        @Override
        public long calc(long utcMillis) {
            return this.field.roundFloor(utcMillis);
        }
    }

    static class TimeTimeZoneRoundingFloor
    extends TimeZoneRounding {
        private final DateTimeField field;
        private final DateTimeZone preTz;
        private final DateTimeZone postTz;

        TimeTimeZoneRoundingFloor(DateTimeField field2, DateTimeZone preTz, DateTimeZone postTz) {
            this.field = field2;
            this.preTz = preTz;
            this.postTz = postTz;
        }

        @Override
        public long calc(long utcMillis) {
            long time = utcMillis + (long)this.preTz.getOffset(utcMillis);
            time = this.field.roundFloor(time);
            time -= (long)this.preTz.getOffset(time);
            time += (long)this.postTz.getOffset(time);
            return time;
        }
    }

    public static class Builder {
        private DateTimeField field;
        private long interval = -1L;
        private DateTimeZone preTz = DateTimeZone.UTC;
        private DateTimeZone postTz = DateTimeZone.UTC;
        private float factor = 1.0f;
        private long preOffset;
        private long postOffset;
        private boolean preZoneAdjustLargeInterval = false;

        public Builder(DateTimeField field2) {
            this.field = field2;
            this.interval = -1L;
        }

        public Builder(TimeValue interval) {
            this.field = null;
            this.interval = interval.millis();
        }

        public Builder preZone(DateTimeZone preTz) {
            this.preTz = preTz;
            return this;
        }

        public Builder preZoneAdjustLargeInterval(boolean preZoneAdjustLargeInterval) {
            this.preZoneAdjustLargeInterval = preZoneAdjustLargeInterval;
            return this;
        }

        public Builder postZone(DateTimeZone postTz) {
            this.postTz = postTz;
            return this;
        }

        public Builder preOffset(long preOffset) {
            this.preOffset = preOffset;
            return this;
        }

        public Builder postOffset(long postOffset) {
            this.postOffset = postOffset;
            return this;
        }

        public Builder factor(float factor) {
            this.factor = factor;
            return this;
        }

        public TimeZoneRounding build() {
            TimeZoneRounding timeZoneRounding = this.field != null ? (this.preTz.equals(DateTimeZone.UTC) && this.postTz.equals(DateTimeZone.UTC) ? new UTCTimeZoneRoundingFloor(this.field) : (this.preZoneAdjustLargeInterval || this.field.getDurationField().getUnitMillis() < 43200000L ? new TimeTimeZoneRoundingFloor(this.field, this.preTz, this.postTz) : new DayTimeZoneRoundingFloor(this.field, this.preTz, this.postTz))) : (this.preTz.equals(DateTimeZone.UTC) && this.postTz.equals(DateTimeZone.UTC) ? new UTCIntervalTimeZoneRounding(this.interval) : (this.preZoneAdjustLargeInterval || this.interval < 43200000L ? new TimeIntervalTimeZoneRounding(this.interval, this.preTz, this.postTz) : new DayIntervalTimeZoneRounding(this.interval, this.preTz, this.postTz)));
            if (this.preOffset != 0L || this.postOffset != 0L) {
                timeZoneRounding = new PrePostTimeZoneRounding(timeZoneRounding, this.preOffset, this.postOffset);
            }
            if (this.factor != 1.0f) {
                timeZoneRounding = new FactorTimeZoneRounding(timeZoneRounding, this.factor);
            }
            return timeZoneRounding;
        }
    }
}

