/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.joda.time.base;

import java.io.Serializable;
import org.elasticsearch.common.joda.time.Chronology;
import org.elasticsearch.common.joda.time.DateTimeUtils;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.joda.time.ReadableDateTime;
import org.elasticsearch.common.joda.time.base.AbstractDateTime;
import org.elasticsearch.common.joda.time.chrono.ISOChronology;
import org.elasticsearch.common.joda.time.convert.ConverterManager;
import org.elasticsearch.common.joda.time.convert.InstantConverter;

public abstract class BaseDateTime
extends AbstractDateTime
implements ReadableDateTime,
Serializable {
    private static final long serialVersionUID = -6728882245981L;
    private long iMillis;
    private Chronology iChronology;

    public BaseDateTime() {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance());
    }

    public BaseDateTime(DateTimeZone zone2) {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance(zone2));
    }

    public BaseDateTime(Chronology chronology) {
        this(DateTimeUtils.currentTimeMillis(), chronology);
    }

    public BaseDateTime(long instant) {
        this(instant, (Chronology)ISOChronology.getInstance());
    }

    public BaseDateTime(long instant, DateTimeZone zone2) {
        this(instant, (Chronology)ISOChronology.getInstance(zone2));
    }

    public BaseDateTime(long instant, Chronology chronology) {
        this.iChronology = this.checkChronology(chronology);
        this.iMillis = this.checkInstant(instant, this.iChronology);
    }

    public BaseDateTime(Object instant, DateTimeZone zone2) {
        Chronology chrono;
        InstantConverter converter = ConverterManager.getInstance().getInstantConverter(instant);
        this.iChronology = chrono = this.checkChronology(converter.getChronology(instant, zone2));
        this.iMillis = this.checkInstant(converter.getInstantMillis(instant, chrono), chrono);
    }

    public BaseDateTime(Object instant, Chronology chronology) {
        InstantConverter converter = ConverterManager.getInstance().getInstantConverter(instant);
        this.iChronology = this.checkChronology(converter.getChronology(instant, chronology));
        this.iMillis = this.checkInstant(converter.getInstantMillis(instant, chronology), this.iChronology);
    }

    public BaseDateTime(int year2, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        this(year2, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond, ISOChronology.getInstance());
    }

    public BaseDateTime(int year2, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond, DateTimeZone zone2) {
        this(year2, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond, ISOChronology.getInstance(zone2));
    }

    public BaseDateTime(int year2, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond, Chronology chronology) {
        this.iChronology = this.checkChronology(chronology);
        long instant = this.iChronology.getDateTimeMillis(year2, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
        this.iMillis = this.checkInstant(instant, this.iChronology);
    }

    protected Chronology checkChronology(Chronology chronology) {
        return DateTimeUtils.getChronology(chronology);
    }

    protected long checkInstant(long instant, Chronology chronology) {
        return instant;
    }

    @Override
    public long getMillis() {
        return this.iMillis;
    }

    @Override
    public Chronology getChronology() {
        return this.iChronology;
    }

    protected void setMillis(long instant) {
        this.iMillis = this.checkInstant(instant, this.iChronology);
    }

    protected void setChronology(Chronology chronology) {
        this.iChronology = this.checkChronology(chronology);
    }
}

