/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.jdk.JdkESLoggerFactory;
import org.elasticsearch.common.logging.log4j.Log4jESLoggerFactory;
import org.elasticsearch.common.logging.slf4j.Slf4jESLoggerFactory;

public abstract class ESLoggerFactory {
    private static volatile ESLoggerFactory defaultFactory = new JdkESLoggerFactory();

    public static void setDefaultFactory(ESLoggerFactory defaultFactory) {
        if (defaultFactory == null) {
            throw new NullPointerException("defaultFactory");
        }
        ESLoggerFactory.defaultFactory = defaultFactory;
    }

    public static ESLogger getLogger(String prefix, String name2) {
        return defaultFactory.newInstance(prefix == null ? null : prefix.intern(), name2.intern());
    }

    public static ESLogger getLogger(String name2) {
        return defaultFactory.newInstance(name2.intern());
    }

    public ESLogger newInstance(String name2) {
        return this.newInstance(null, name2);
    }

    protected abstract ESLogger newInstance(String var1, String var2);

    static {
        try {
            Class<?> loggerClazz = Class.forName("org.apache.log4j.Logger");
            loggerClazz.getMethod("setLevel", Class.forName("org.apache.log4j.Level"));
            defaultFactory = new Log4jESLoggerFactory();
        }
        catch (Throwable e) {
            try {
                Class.forName("org.slf4j.Logger");
                defaultFactory = new Slf4jESLoggerFactory();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

