/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import org.elasticsearch.common.Classes;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.river.RiverName;

public class Loggers {
    private static final String commonPrefix = System.getProperty("es.logger.prefix", "org.elasticsearch.");
    public static final String SPACE = " ";
    private static boolean consoleLoggingEnabled = true;

    public static void disableConsoleLogging() {
        consoleLoggingEnabled = false;
    }

    public static void enableConsoleLogging() {
        consoleLoggingEnabled = true;
    }

    public static boolean consoleLoggingEnabled() {
        return consoleLoggingEnabled;
    }

    public static ESLogger getLogger(Class clazz, Settings settings, ShardId shardId, String ... prefixes) {
        return Loggers.getLogger(clazz, settings, shardId.index(), Lists.asList(Integer.toString(shardId.id()), prefixes).toArray(new String[0]));
    }

    public static ESLogger getLogger(Class clazz, Settings settings, Index index2, String ... prefixes) {
        return Loggers.getLogger(clazz, settings, Lists.asList(SPACE, index2.name(), prefixes).toArray(new String[0]));
    }

    public static ESLogger getLogger(Class clazz, Settings settings, RiverName riverName, String ... prefixes) {
        ArrayList<String> l = Lists.newArrayList();
        l.add(SPACE);
        l.add(riverName.type());
        l.add(riverName.name());
        l.addAll(Lists.newArrayList(prefixes));
        return Loggers.getLogger(clazz, settings, l.toArray(new String[l.size()]));
    }

    public static ESLogger getLogger(Class clazz, Settings settings, String ... prefixes) {
        return Loggers.getLogger(Loggers.buildClassLoggerName(clazz), settings, prefixes);
    }

    public static ESLogger getLogger(String loggerName, Settings settings, String ... prefixes) {
        String name2;
        ArrayList<String> prefixesList = Lists.newArrayList();
        if (settings.getAsBoolean("logger.logHostAddress", false).booleanValue()) {
            try {
                prefixesList.add(InetAddress.getLocalHost().getHostAddress());
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
        }
        if (settings.getAsBoolean("logger.logHostName", false).booleanValue()) {
            try {
                prefixesList.add(InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
        }
        if ((name2 = settings.get("name")) != null) {
            prefixesList.add(name2);
        }
        if (prefixes != null && prefixes.length > 0) {
            prefixesList.addAll(Arrays.asList(prefixes));
        }
        return Loggers.getLogger(Loggers.getLoggerName(loggerName), prefixesList.toArray(new String[prefixesList.size()]));
    }

    public static ESLogger getLogger(ESLogger parentLogger, String s2) {
        return ESLoggerFactory.getLogger(parentLogger.getPrefix(), Loggers.getLoggerName(parentLogger.getName() + s2));
    }

    public static ESLogger getLogger(String s2) {
        return ESLoggerFactory.getLogger(s2);
    }

    public static ESLogger getLogger(Class clazz) {
        return ESLoggerFactory.getLogger(Loggers.getLoggerName(Loggers.buildClassLoggerName(clazz)));
    }

    public static ESLogger getLogger(Class clazz, String ... prefixes) {
        return Loggers.getLogger(Loggers.buildClassLoggerName(clazz), prefixes);
    }

    public static ESLogger getLogger(String name2, String ... prefixes) {
        String prefix = null;
        if (prefixes != null && prefixes.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String prefixX : prefixes) {
                if (prefixX == null) continue;
                if (prefixX.equals(SPACE)) {
                    sb.append(SPACE);
                    continue;
                }
                sb.append("[").append(prefixX).append("]");
            }
            if (sb.length() > 0) {
                sb.append(SPACE);
                prefix = sb.toString();
            }
        }
        return ESLoggerFactory.getLogger(prefix, Loggers.getLoggerName(name2));
    }

    private static String buildClassLoggerName(Class clazz) {
        String name2 = clazz.getName();
        if (name2.startsWith("org.elasticsearch.")) {
            name2 = Classes.getPackageName(clazz);
        }
        return name2;
    }

    private static String getLoggerName(String name2) {
        if (name2.startsWith("org.elasticsearch.")) {
            name2 = name2.substring("org.elasticsearch.".length());
        }
        return commonPrefix + name2;
    }
}

