/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;

public class FunctionScoreQuery
extends Query {
    Query subQuery;
    final ScoreFunction function;

    public FunctionScoreQuery(Query subQuery, ScoreFunction function) {
        this.subQuery = subQuery;
        this.function = function;
    }

    public Query getSubQuery() {
        return this.subQuery;
    }

    public ScoreFunction getFunction() {
        return this.function;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query newQ = this.subQuery.rewrite(reader);
        if (newQ == this.subQuery) {
            return this;
        }
        FunctionScoreQuery bq = (FunctionScoreQuery)this.clone();
        bq.subQuery = newQ;
        return bq;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        this.subQuery.extractTerms(terms);
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        return new CustomBoostFactorWeight(searcher);
    }

    @Override
    public String toString(String field2) {
        StringBuilder sb = new StringBuilder();
        sb.append("custom score (").append(this.subQuery.toString(field2)).append(",function=").append(this.function).append(')');
        sb.append(ToStringUtils.boost(this.getBoost()));
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        FunctionScoreQuery other = (FunctionScoreQuery)o;
        return this.getBoost() == other.getBoost() && this.subQuery.equals(other.subQuery) && this.function.equals(other.function);
    }

    @Override
    public int hashCode() {
        return this.subQuery.hashCode() + 31 * this.function.hashCode() ^ Float.floatToIntBits(this.getBoost());
    }

    static class CustomBoostFactorScorer
    extends Scorer {
        private final float subQueryWeight;
        private final Scorer scorer;
        private final ScoreFunction function;

        private CustomBoostFactorScorer(Similarity similarity, CustomBoostFactorWeight w, Scorer scorer, ScoreFunction function) throws IOException {
            super(similarity);
            this.subQueryWeight = w.getValue();
            this.scorer = scorer;
            this.function = function;
        }

        @Override
        public int docID() {
            return this.scorer.docID();
        }

        @Override
        public int advance(int target) throws IOException {
            return this.scorer.advance(target);
        }

        @Override
        public int nextDoc() throws IOException {
            return this.scorer.nextDoc();
        }

        @Override
        public float score() throws IOException {
            return this.subQueryWeight * this.function.score(this.scorer.docID(), this.scorer.score());
        }
    }

    class CustomBoostFactorWeight
    extends Weight {
        Searcher searcher;
        Weight subQueryWeight;

        public CustomBoostFactorWeight(Searcher searcher) throws IOException {
            this.searcher = searcher;
            this.subQueryWeight = FunctionScoreQuery.this.subQuery.weight(searcher);
        }

        @Override
        public Query getQuery() {
            return FunctionScoreQuery.this;
        }

        @Override
        public float getValue() {
            return FunctionScoreQuery.this.getBoost();
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            float sum2 = this.subQueryWeight.sumOfSquaredWeights();
            return sum2 *= FunctionScoreQuery.this.getBoost() * FunctionScoreQuery.this.getBoost();
        }

        @Override
        public void normalize(float norm) {
            this.subQueryWeight.normalize(norm *= FunctionScoreQuery.this.getBoost());
        }

        @Override
        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            Scorer subQueryScorer = this.subQueryWeight.scorer(reader, scoreDocsInOrder, false);
            if (subQueryScorer == null) {
                return null;
            }
            FunctionScoreQuery.this.function.setNextReader(reader);
            return new CustomBoostFactorScorer(FunctionScoreQuery.this.getSimilarity(this.searcher), this, subQueryScorer, FunctionScoreQuery.this.function);
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            Explanation subQueryExpl = this.subQueryWeight.explain(reader, doc);
            if (!subQueryExpl.isMatch()) {
                return subQueryExpl;
            }
            FunctionScoreQuery.this.function.setNextReader(reader);
            Explanation functionExplanation = FunctionScoreQuery.this.function.explainScore(doc, subQueryExpl);
            float sc = this.getValue() * functionExplanation.getValue();
            ComplexExplanation res = new ComplexExplanation(true, sc, "custom score, product of:");
            res.addDetail(functionExplanation);
            res.addDetail(new Explanation(this.getValue(), "queryBoost"));
            return res;
        }
    }
}

