/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.vectorhighlight;

import org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import org.elasticsearch.common.trove.set.hash.TCharHashSet;

public class SimpleBoundaryScanner2
implements BoundaryScanner {
    public static final int DEFAULT_MAX_SCAN = 20;
    public static final char[] DEFAULT_BOUNDARY_CHARS = new char[]{'.', ',', '!', '?', ' ', '\t', '\n'};
    public static final SimpleBoundaryScanner2 DEFAULT = new SimpleBoundaryScanner2();
    public int maxScan;
    public TCharHashSet boundaryChars;

    public SimpleBoundaryScanner2() {
        this(20, DEFAULT_BOUNDARY_CHARS);
    }

    public SimpleBoundaryScanner2(int maxScan, char[] boundaryChars) {
        this.maxScan = maxScan;
        this.boundaryChars = new TCharHashSet(boundaryChars);
    }

    @Override
    public int findStartOffset(StringBuilder buffer, int start2) {
        int offset2;
        if (start2 > buffer.length() || start2 < 1) {
            return start2;
        }
        int count2 = this.maxScan;
        for (offset2 = start2; offset2 > 0 && count2 > 0; --offset2, --count2) {
            if (!this.boundaryChars.contains(buffer.charAt(offset2 - 1))) continue;
            return offset2;
        }
        if (offset2 == 0) {
            return 0;
        }
        return start2;
    }

    @Override
    public int findEndOffset(StringBuilder buffer, int start2) {
        if (start2 > buffer.length() || start2 < 0) {
            return start2;
        }
        int count2 = this.maxScan;
        for (int offset2 = start2; offset2 < buffer.length() && count2 > 0; ++offset2, --count2) {
            if (!this.boundaryChars.contains(buffer.charAt(offset2))) continue;
            return offset2;
        }
        return start2;
    }
}

