/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.spatial.prefix;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.elasticsearch.common.lucene.spatial.prefix.tree.Node;

public final class NodeTokenStream
extends TokenStream {
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private List<Node> nodes;
    private Iterator<Node> iterator;
    private CharSequence nextTokenStringNeedingLeaf = null;

    @Override
    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        if (this.nextTokenStringNeedingLeaf != null) {
            this.termAtt.append(this.nextTokenStringNeedingLeaf);
            this.termAtt.append('+');
            this.nextTokenStringNeedingLeaf = null;
            return true;
        }
        if (this.iterator.hasNext()) {
            Node cell = this.iterator.next();
            String token = cell.getTokenString();
            this.termAtt.append((CharSequence)token);
            if (cell.isLeaf()) {
                this.nextTokenStringNeedingLeaf = token;
            }
            return true;
        }
        return false;
    }

    @Override
    public void reset() throws IOException {
        this.iterator = this.nodes.iterator();
        this.nextTokenStringNeedingLeaf = null;
    }

    public void setNodes(List<Node> nodes) {
        this.nodes = nodes;
    }
}

