/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.spatial.prefix.tree;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.common.lucene.spatial.prefix.tree.Node;
import org.elasticsearch.common.lucene.spatial.prefix.tree.SpatialPrefixTree;

public class QuadPrefixTree
extends SpatialPrefixTree {
    public static final int MAX_LEVELS_POSSIBLE = 50;
    public static final int DEFAULT_MAX_LEVELS = 12;
    private final double xmin;
    private final double xmax;
    private final double ymin;
    private final double ymax;
    private final double xmid;
    private final double ymid;
    private final double gridW;
    public final double gridH;
    final double[] levelW;
    final double[] levelH;
    final int[] levelS;
    final int[] levelN;

    public QuadPrefixTree(SpatialContext ctx, Rectangle bounds, int maxLevels) {
        super(ctx, maxLevels);
        this.xmin = bounds.getMinX();
        this.xmax = bounds.getMaxX();
        this.ymin = bounds.getMinY();
        this.ymax = bounds.getMaxY();
        this.levelW = new double[maxLevels];
        this.levelH = new double[maxLevels];
        this.levelS = new int[maxLevels];
        this.levelN = new int[maxLevels];
        this.gridW = this.xmax - this.xmin;
        this.gridH = this.ymax - this.ymin;
        this.xmid = this.xmin + this.gridW / 2.0;
        this.ymid = this.ymin + this.gridH / 2.0;
        this.levelW[0] = this.gridW / 2.0;
        this.levelH[0] = this.gridH / 2.0;
        this.levelS[0] = 2;
        this.levelN[0] = 4;
        for (int i2 = 1; i2 < this.levelW.length; ++i2) {
            this.levelW[i2] = this.levelW[i2 - 1] / 2.0;
            this.levelH[i2] = this.levelH[i2 - 1] / 2.0;
            this.levelS[i2] = this.levelS[i2 - 1] * 2;
            this.levelN[i2] = this.levelN[i2 - 1] * 4;
        }
    }

    public QuadPrefixTree(SpatialContext ctx) {
        this(ctx, 12);
    }

    public QuadPrefixTree(SpatialContext ctx, int maxLevels) {
        this(ctx, ctx.getWorldBounds(), maxLevels);
    }

    public void printInfo(PrintStream out) {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ROOT);
        nf.setMaximumFractionDigits(5);
        nf.setMinimumFractionDigits(5);
        nf.setMinimumIntegerDigits(3);
        for (int i2 = 0; i2 < this.maxLevels; ++i2) {
            out.println(i2 + "]\t" + nf.format(this.levelW[i2]) + "\t" + nf.format(this.levelH[i2]) + "\t" + this.levelS[i2] + "\t" + this.levelS[i2] * this.levelS[i2]);
        }
    }

    @Override
    public int getLevelForDistance(double dist) {
        if (dist == 0.0) {
            return this.maxLevels;
        }
        for (int i2 = 0; i2 < this.maxLevels - 1; ++i2) {
            if (!(dist > this.levelW[i2]) || !(dist > this.levelH[i2])) continue;
            return i2 + 1;
        }
        return this.maxLevels;
    }

    @Override
    public Node getNode(Point p2, int level2) {
        ArrayList<Node> cells = new ArrayList<Node>(1);
        this.build(this.xmid, this.ymid, 0, cells, new StringBuilder(), this.ctx.makePoint(p2.getX(), p2.getY()), level2);
        return (Node)cells.get(0);
    }

    @Override
    public Node getNode(String token) {
        return new QuadCell(token);
    }

    @Override
    public Node getNode(byte[] bytes2, int offset2, int len) {
        return new QuadCell(bytes2, offset2, len);
    }

    @Override
    public List<Node> getNodes(Shape shape, int detailLevel, boolean inclParents) {
        if (shape instanceof Point) {
            return super.getNodesAltPoint((Point)shape, detailLevel, inclParents);
        }
        return super.getNodes(shape, detailLevel, inclParents);
    }

    private void build(double x, double y, int level2, List<Node> matches, StringBuilder str, Shape shape, int maxLevel) {
        assert (str.length() == level2);
        double w = this.levelW[level2] / 2.0;
        double h = this.levelH[level2] / 2.0;
        this.checkBattenberg('A', x - w, y + h, level2, matches, str, shape, maxLevel);
        this.checkBattenberg('B', x + w, y + h, level2, matches, str, shape, maxLevel);
        this.checkBattenberg('C', x - w, y - h, level2, matches, str, shape, maxLevel);
        this.checkBattenberg('D', x + w, y - h, level2, matches, str, shape, maxLevel);
    }

    private void checkBattenberg(char c, double cx, double cy, int level2, List<Node> matches, StringBuilder str, Shape shape, int maxLevel) {
        assert (str.length() == level2);
        double w = this.levelW[level2] / 2.0;
        double h = this.levelH[level2] / 2.0;
        int strlen = str.length();
        Rectangle rectangle = this.ctx.makeRectangle(cx - w, cx + w, cy - h, cy + h);
        SpatialRelation v = shape.relate(rectangle);
        if (SpatialRelation.CONTAINS == v) {
            str.append(c);
            matches.add(new QuadCell(str.toString(), v.transpose()));
        } else if (SpatialRelation.DISJOINT != v) {
            str.append(c);
            int nextLevel = level2 + 1;
            if (nextLevel >= maxLevel) {
                matches.add(new QuadCell(str.toString(), v.transpose()));
            } else {
                this.build(cx, cy, nextLevel, matches, str, shape, maxLevel);
            }
        }
        str.setLength(strlen);
    }

    class QuadCell
    extends Node {
        private Shape shape;

        public QuadCell(String token) {
            super(QuadPrefixTree.this, token);
        }

        public QuadCell(String token, SpatialRelation shapeRel) {
            super(QuadPrefixTree.this, token);
            this.shapeRel = shapeRel;
        }

        QuadCell(byte[] bytes2, int off, int len) {
            super(QuadPrefixTree.this, bytes2, off, len);
        }

        @Override
        public void reset(byte[] bytes2, int off, int len) {
            super.reset(bytes2, off, len);
            this.shape = null;
        }

        @Override
        public Collection<Node> getSubCells() {
            ArrayList<Node> cells = new ArrayList<Node>(4);
            cells.add(new QuadCell(this.getTokenString() + "A"));
            cells.add(new QuadCell(this.getTokenString() + "B"));
            cells.add(new QuadCell(this.getTokenString() + "C"));
            cells.add(new QuadCell(this.getTokenString() + "D"));
            return cells;
        }

        @Override
        public int getSubCellsSize() {
            return 4;
        }

        @Override
        public Node getSubCell(Point p2) {
            return QuadPrefixTree.this.getNode(p2, this.getLevel() + 1);
        }

        @Override
        public Shape getShape() {
            if (this.shape == null) {
                this.shape = this.makeShape();
            }
            return this.shape;
        }

        private Rectangle makeShape() {
            double height;
            double width;
            String token = this.getTokenString();
            double xmin = QuadPrefixTree.this.xmin;
            double ymin = QuadPrefixTree.this.ymin;
            for (int i2 = 0; i2 < token.length(); ++i2) {
                char c = token.charAt(i2);
                if ('A' == c || 'a' == c) {
                    ymin += QuadPrefixTree.this.levelH[i2];
                    continue;
                }
                if ('B' == c || 'b' == c) {
                    xmin += QuadPrefixTree.this.levelW[i2];
                    ymin += QuadPrefixTree.this.levelH[i2];
                    continue;
                }
                if ('C' == c || 'c' == c) continue;
                if ('D' == c || 'd' == c) {
                    xmin += QuadPrefixTree.this.levelW[i2];
                    continue;
                }
                throw new RuntimeException("unexpected char: " + c);
            }
            int len = token.length();
            if (len > 0) {
                width = QuadPrefixTree.this.levelW[len - 1];
                height = QuadPrefixTree.this.levelH[len - 1];
            } else {
                width = QuadPrefixTree.this.gridW;
                height = QuadPrefixTree.this.gridH;
            }
            return QuadPrefixTree.this.ctx.makeRectangle(xmin, xmin + width, ymin, ymin + height);
        }
    }
}

