/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.store;

import java.io.IOException;
import java.util.zip.Checksum;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.OpenBufferedIndexOutput;

public class BufferedChecksumIndexOutput
extends OpenBufferedIndexOutput {
    private final IndexOutput out;
    private final Checksum digest;

    public BufferedChecksumIndexOutput(IndexOutput out, Checksum digest2) {
        super(16448);
        this.out = out;
        this.digest = digest2;
    }

    public Checksum digest() {
        return this.digest;
    }

    public IndexOutput underlying() {
        return this.out;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.out.close();
    }

    @Override
    protected void flushBuffer(byte[] b, int offset2, int len) throws IOException {
        this.out.writeBytes(b, offset2, len);
        this.digest.update(b, offset2, len);
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        this.out.flush();
    }

    @Override
    public void seek(long pos2) throws IOException {
        super.seek(pos2);
        this.out.seek(pos2);
    }

    @Override
    public long length() throws IOException {
        return this.out.length();
    }

    @Override
    public void setLength(long length2) throws IOException {
        this.out.setLength(length2);
    }

    public String toString() {
        return this.out.toString();
    }
}

