/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.metrics;

import org.elasticsearch.common.metrics.Metric;
import org.elasticsearch.common.util.concurrent.jsr166e.LongAdder;

public class MeanMetric
implements Metric {
    private final LongAdder counter = new LongAdder();
    private final LongAdder sum = new LongAdder();

    public void inc(long n) {
        this.counter.increment();
        this.sum.add(n);
    }

    public void dec(long n) {
        this.counter.decrement();
        this.sum.add(-n);
    }

    public long count() {
        return this.counter.sum();
    }

    public long sum() {
        return this.sum.sum();
    }

    public double mean() {
        long count2 = this.count();
        if (count2 > 0L) {
            return (double)this.sum.sum() / (double)count2;
        }
        return 0.0;
    }

    public void clear() {
        this.counter.reset();
        this.sum.reset();
    }
}

