/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.asm;

import org.elasticsearch.common.mvel2.asm.AnnotationVisitor;
import org.elasticsearch.common.mvel2.asm.ByteVector;
import org.elasticsearch.common.mvel2.asm.ClassWriter;
import org.elasticsearch.common.mvel2.asm.Item;
import org.elasticsearch.common.mvel2.asm.Type;

final class AnnotationWriter
implements AnnotationVisitor {
    private final ClassWriter cw;
    private int size;
    private final boolean named;
    private final ByteVector bv;
    private final ByteVector parent;
    private final int offset;
    AnnotationWriter next;
    AnnotationWriter prev;

    AnnotationWriter(ClassWriter cw, boolean named, ByteVector bv, ByteVector parent, int offset2) {
        this.cw = cw;
        this.named = named;
        this.bv = bv;
        this.parent = parent;
        this.offset = offset2;
    }

    public void visit(String name2, Object value2) {
        ++this.size;
        if (this.named) {
            this.bv.putShort(this.cw.newUTF8(name2));
        }
        if (value2 instanceof String) {
            this.bv.put12(115, this.cw.newUTF8((String)value2));
        } else if (value2 instanceof Byte) {
            this.bv.put12(66, this.cw.newInteger((int)((Byte)value2).byteValue()).index);
        } else if (value2 instanceof Boolean) {
            int v = (Boolean)value2 != false ? 1 : 0;
            this.bv.put12(90, this.cw.newInteger((int)v).index);
        } else if (value2 instanceof Character) {
            this.bv.put12(67, this.cw.newInteger((int)((Character)value2).charValue()).index);
        } else if (value2 instanceof Short) {
            this.bv.put12(83, this.cw.newInteger((int)((Short)value2).shortValue()).index);
        } else if (value2 instanceof Type) {
            this.bv.put12(99, this.cw.newUTF8(((Type)value2).getDescriptor()));
        } else if (value2 instanceof byte[]) {
            byte[] v = (byte[])value2;
            this.bv.put12(91, v.length);
            for (int i2 = 0; i2 < v.length; ++i2) {
                this.bv.put12(66, this.cw.newInteger((int)v[i2]).index);
            }
        } else if (value2 instanceof boolean[]) {
            boolean[] v = (boolean[])value2;
            this.bv.put12(91, v.length);
            for (int i3 = 0; i3 < v.length; ++i3) {
                this.bv.put12(90, this.cw.newInteger((int)(v[i3] ? 1 : 0)).index);
            }
        } else if (value2 instanceof short[]) {
            short[] v = (short[])value2;
            this.bv.put12(91, v.length);
            for (int i4 = 0; i4 < v.length; ++i4) {
                this.bv.put12(83, this.cw.newInteger((int)v[i4]).index);
            }
        } else if (value2 instanceof char[]) {
            char[] v = (char[])value2;
            this.bv.put12(91, v.length);
            for (int i5 = 0; i5 < v.length; ++i5) {
                this.bv.put12(67, this.cw.newInteger((int)v[i5]).index);
            }
        } else if (value2 instanceof int[]) {
            int[] v = (int[])value2;
            this.bv.put12(91, v.length);
            for (int i6 = 0; i6 < v.length; ++i6) {
                this.bv.put12(73, this.cw.newInteger((int)v[i6]).index);
            }
        } else if (value2 instanceof long[]) {
            long[] v = (long[])value2;
            this.bv.put12(91, v.length);
            for (int i7 = 0; i7 < v.length; ++i7) {
                this.bv.put12(74, this.cw.newLong((long)v[i7]).index);
            }
        } else if (value2 instanceof float[]) {
            float[] v = (float[])value2;
            this.bv.put12(91, v.length);
            for (int i8 = 0; i8 < v.length; ++i8) {
                this.bv.put12(70, this.cw.newFloat((float)v[i8]).index);
            }
        } else if (value2 instanceof double[]) {
            double[] v = (double[])value2;
            this.bv.put12(91, v.length);
            for (int i9 = 0; i9 < v.length; ++i9) {
                this.bv.put12(68, this.cw.newDouble((double)v[i9]).index);
            }
        } else {
            Item i10 = this.cw.newConstItem(value2);
            this.bv.put12(".s.IFJDCS".charAt(i10.type), i10.index);
        }
    }

    public void visitEnum(String name2, String desc, String value2) {
        ++this.size;
        if (this.named) {
            this.bv.putShort(this.cw.newUTF8(name2));
        }
        this.bv.put12(101, this.cw.newUTF8(desc)).putShort(this.cw.newUTF8(value2));
    }

    public AnnotationVisitor visitAnnotation(String name2, String desc) {
        ++this.size;
        if (this.named) {
            this.bv.putShort(this.cw.newUTF8(name2));
        }
        this.bv.put12(64, this.cw.newUTF8(desc)).putShort(0);
        return new AnnotationWriter(this.cw, true, this.bv, this.bv, this.bv.length - 2);
    }

    public AnnotationVisitor visitArray(String name2) {
        ++this.size;
        if (this.named) {
            this.bv.putShort(this.cw.newUTF8(name2));
        }
        this.bv.put12(91, 0);
        return new AnnotationWriter(this.cw, false, this.bv, this.bv, this.bv.length - 2);
    }

    public void visitEnd() {
        if (this.parent != null) {
            byte[] data2 = this.parent.data;
            data2[this.offset] = (byte)(this.size >>> 8);
            data2[this.offset + 1] = (byte)this.size;
        }
    }

    int getSize() {
        int size2 = 0;
        AnnotationWriter aw = this;
        while (aw != null) {
            size2 += aw.bv.length;
            aw = aw.next;
        }
        return size2;
    }

    void put(ByteVector out) {
        int n = 0;
        int size2 = 2;
        AnnotationWriter aw = this;
        AnnotationWriter last2 = null;
        while (aw != null) {
            ++n;
            size2 += aw.bv.length;
            aw.visitEnd();
            aw.prev = last2;
            last2 = aw;
            aw = aw.next;
        }
        out.putInt(size2);
        out.putShort(n);
        aw = last2;
        while (aw != null) {
            out.putByteArray(aw.bv.data, 0, aw.bv.length);
            aw = aw.prev;
        }
    }

    static void put(AnnotationWriter[] panns, int off, ByteVector out) {
        int i2;
        int size2 = 1 + 2 * (panns.length - off);
        for (i2 = off; i2 < panns.length; ++i2) {
            size2 += panns[i2] == null ? 0 : panns[i2].getSize();
        }
        out.putInt(size2).putByte(panns.length - off);
        for (i2 = off; i2 < panns.length; ++i2) {
            AnnotationWriter aw = panns[i2];
            AnnotationWriter last2 = null;
            int n = 0;
            while (aw != null) {
                ++n;
                aw.visitEnd();
                aw.prev = last2;
                last2 = aw;
                aw = aw.next;
            }
            out.putShort(n);
            aw = last2;
            while (aw != null) {
                out.putByteArray(aw.bv.data, 0, aw.bv.length);
                aw = aw.prev;
            }
        }
    }
}

