/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.asm;

import java.io.IOException;
import java.io.InputStream;
import org.elasticsearch.common.mvel2.asm.AnnotationVisitor;
import org.elasticsearch.common.mvel2.asm.Attribute;
import org.elasticsearch.common.mvel2.asm.ClassVisitor;
import org.elasticsearch.common.mvel2.asm.ClassWriter;
import org.elasticsearch.common.mvel2.asm.Item;
import org.elasticsearch.common.mvel2.asm.Label;
import org.elasticsearch.common.mvel2.asm.MethodVisitor;
import org.elasticsearch.common.mvel2.asm.MethodWriter;
import org.elasticsearch.common.mvel2.asm.Opcodes;
import org.elasticsearch.common.mvel2.asm.Type;

public class ClassReader {
    static final boolean SIGNATURES = true;
    static final boolean ANNOTATIONS = true;
    static final boolean FRAMES = true;
    static final boolean WRITER = true;
    static final boolean RESIZE = true;
    public static final int SKIP_CODE = 1;
    public static final int SKIP_DEBUG = 2;
    public static final int SKIP_FRAMES = 4;
    public static final int EXPAND_FRAMES = 8;
    public final byte[] b;
    private final int[] items;
    private final String[] strings;
    private final int maxStringLength;
    public final int header;

    public ClassReader(byte[] b) {
        this(b, 0, b.length);
    }

    public ClassReader(byte[] b, int off, int len) {
        this.b = b;
        this.items = new int[this.readUnsignedShort(off + 8)];
        int n = this.items.length;
        this.strings = new String[n];
        int max2 = 0;
        int index2 = off + 10;
        for (int i2 = 1; i2 < n; ++i2) {
            int size2;
            this.items[i2] = index2 + 1;
            switch (b[index2]) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    size2 = 5;
                    break;
                }
                case 5: 
                case 6: {
                    size2 = 9;
                    ++i2;
                    break;
                }
                case 1: {
                    size2 = 3 + this.readUnsignedShort(index2 + 1);
                    if (size2 <= max2) break;
                    max2 = size2;
                    break;
                }
                default: {
                    size2 = 3;
                }
            }
            index2 += size2;
        }
        this.maxStringLength = max2;
        this.header = index2;
    }

    public int getAccess() {
        return this.readUnsignedShort(this.header);
    }

    public String getClassName() {
        return this.readClass(this.header + 2, new char[this.maxStringLength]);
    }

    public String getSuperName() {
        int n = this.items[this.readUnsignedShort(this.header + 4)];
        return n == 0 ? null : this.readUTF8(n, new char[this.maxStringLength]);
    }

    public String[] getInterfaces() {
        int index2 = this.header + 6;
        int n = this.readUnsignedShort(index2);
        String[] interfaces2 = new String[n];
        if (n > 0) {
            char[] buf = new char[this.maxStringLength];
            for (int i2 = 0; i2 < n; ++i2) {
                interfaces2[i2] = this.readClass(index2 += 2, buf);
            }
        }
        return interfaces2;
    }

    void copyPool(ClassWriter classWriter) {
        char[] buf = new char[this.maxStringLength];
        int ll = this.items.length;
        Item[] items2 = new Item[ll];
        for (int i2 = 1; i2 < ll; ++i2) {
            int index2 = this.items[i2];
            byte tag2 = this.b[index2 - 1];
            Item item = new Item(i2);
            switch (tag2) {
                case 9: 
                case 10: 
                case 11: {
                    int nameType = this.items[this.readUnsignedShort(index2 + 2)];
                    item.set(tag2, this.readClass(index2, buf), this.readUTF8(nameType, buf), this.readUTF8(nameType + 2, buf));
                    break;
                }
                case 3: {
                    item.set(this.readInt(index2));
                    break;
                }
                case 4: {
                    item.set(Float.intBitsToFloat(this.readInt(index2)));
                    break;
                }
                case 12: {
                    item.set(tag2, this.readUTF8(index2, buf), this.readUTF8(index2 + 2, buf), null);
                    break;
                }
                case 5: {
                    item.set(this.readLong(index2));
                    ++i2;
                    break;
                }
                case 6: {
                    item.set(Double.longBitsToDouble(this.readLong(index2)));
                    ++i2;
                    break;
                }
                case 1: {
                    String s2 = this.strings[i2];
                    if (s2 == null) {
                        index2 = this.items[i2];
                        s2 = this.strings[i2] = this.readUTF(index2 + 2, this.readUnsignedShort(index2), buf);
                    }
                    item.set(tag2, s2, null, null);
                    break;
                }
                default: {
                    item.set(tag2, this.readUTF8(index2, buf), null, null);
                }
            }
            int index22 = item.hashCode % items2.length;
            item.next = items2[index22];
            items2[index22] = item;
        }
        int off = this.items[1] - 1;
        classWriter.pool.putByteArray(this.b, off, this.header - off);
        classWriter.items = items2;
        classWriter.threshold = (int)(0.75 * (double)ll);
        classWriter.index = ll;
    }

    public ClassReader(InputStream is) throws IOException {
        this(ClassReader.readClass(is));
    }

    public ClassReader(String name2) throws IOException {
        this(ClassLoader.getSystemResourceAsStream(name2.replace('.', '/') + ".class"));
    }

    private static byte[] readClass(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("Class not found");
        }
        byte[] b = new byte[is.available()];
        int len = 0;
        while (true) {
            int n;
            if ((n = is.read(b, len, b.length - len)) == -1) {
                if (len < b.length) {
                    byte[] c = new byte[len];
                    System.arraycopy(b, 0, c, 0, len);
                    b = c;
                }
                return b;
            }
            if ((len += n) != b.length) continue;
            int last2 = is.read();
            if (last2 < 0) {
                return b;
            }
            byte[] c = new byte[b.length + 1000];
            System.arraycopy(b, 0, c, 0, len);
            c[len++] = (byte)last2;
            b = c;
        }
    }

    public void accept(ClassVisitor classVisitor, int flags) {
        this.accept(classVisitor, new Attribute[0], flags);
    }

    /*
     * Unable to fully structure code
     */
    public void accept(ClassVisitor classVisitor, Attribute[] attrs, int flags) {
        b = this.b;
        c = new char[this.maxStringLength];
        anns = 0;
        ianns = 0;
        cattrs = null;
        u = this.header;
        access = this.readUnsignedShort(u);
        name = this.readClass(u + 2, c);
        v = this.items[this.readUnsignedShort(u + 4)];
        superClassName = v == 0 ? null : this.readUTF8(v, c);
        implementedItfs = new String[this.readUnsignedShort(u + 6)];
        w = 0;
        u += 8;
        for (i = 0; i < implementedItfs.length; ++i) {
            implementedItfs[i] = this.readClass(u, c);
            u += 2;
        }
        skipCode = (flags & 1) != 0;
        skipDebug = (flags & 2) != 0;
        unzip = (flags & 8) != 0;
        v = u;
        i = this.readUnsignedShort(v);
        v += 2;
        while (i > 0) {
            j = this.readUnsignedShort(v + 6);
            v += 8;
            while (j > 0) {
                v += 6 + this.readInt(v + 2);
                --j;
            }
            --i;
        }
        i = this.readUnsignedShort(v);
        v += 2;
        while (i > 0) {
            j = this.readUnsignedShort(v + 6);
            v += 8;
            while (j > 0) {
                v += 6 + this.readInt(v + 2);
                --j;
            }
            --i;
        }
        signature = null;
        sourceFile = null;
        sourceDebug = null;
        enclosingOwner = null;
        enclosingName = null;
        enclosingDesc = null;
        i = this.readUnsignedShort(v);
        v += 2;
        while (i > 0) {
            attrName = this.readUTF8(v, c);
            if ("SourceFile".equals(attrName)) {
                sourceFile = this.readUTF8(v + 6, c);
            } else if ("InnerClasses".equals(attrName)) {
                w = v + 6;
            } else if ("EnclosingMethod".equals(attrName)) {
                enclosingOwner = this.readClass(v + 6, c);
                item = this.readUnsignedShort(v + 8);
                if (item != 0) {
                    enclosingName = this.readUTF8(this.items[item], c);
                    enclosingDesc = this.readUTF8(this.items[item] + 2, c);
                }
            } else if ("Signature".equals(attrName)) {
                signature = this.readUTF8(v + 6, c);
            } else if ("RuntimeVisibleAnnotations".equals(attrName)) {
                anns = v + 6;
            } else if ("Deprecated".equals(attrName)) {
                access |= 131072;
            } else if ("Synthetic".equals(attrName)) {
                access |= 266240;
            } else if ("SourceDebugExtension".equals(attrName)) {
                len = this.readInt(v + 2);
                sourceDebug = this.readUTF(v + 6, len, new char[len]);
            } else if ("RuntimeInvisibleAnnotations".equals(attrName)) {
                ianns = v + 6;
            } else {
                attr = this.readAttribute(attrs, attrName, v + 6, this.readInt(v + 2), c, -1, null);
                if (attr != null) {
                    attr.next = cattrs;
                    cattrs = attr;
                }
            }
            v += 6 + this.readInt(v + 2);
            --i;
        }
        classVisitor.visit(this.readInt(4), access, name, signature, superClassName, implementedItfs);
        if (!(skipDebug || sourceFile == null && sourceDebug == null)) {
            classVisitor.visitSource(sourceFile, sourceDebug);
        }
        if (enclosingOwner != null) {
            classVisitor.visitOuterClass(enclosingOwner, enclosingName, enclosingDesc);
        }
        for (i = 1; i >= 0; --i) {
            v0 = v = i == 0 ? ianns : anns;
            if (v == 0) continue;
            j = this.readUnsignedShort(v);
            v += 2;
            while (j > 0) {
                v = this.readAnnotationValues(v + 2, c, true, classVisitor.visitAnnotation(this.readUTF8(v, c), i != 0));
                --j;
            }
        }
        while (cattrs != null) {
            attr = cattrs.next;
            cattrs.next = null;
            classVisitor.visitAttribute(cattrs);
            cattrs = attr;
        }
        if (w != 0) {
            i = this.readUnsignedShort(w);
            w += 2;
            while (i > 0) {
                classVisitor.visitInnerClass(this.readUnsignedShort(w) == 0 ? null : this.readClass(w, c), this.readUnsignedShort(w + 2) == 0 ? null : this.readClass(w + 2, c), this.readUnsignedShort(w + 4) == 0 ? null : this.readUTF8(w + 4, c), this.readUnsignedShort(w + 6));
                w += 8;
                --i;
            }
        }
        i = this.readUnsignedShort(u);
        u += 2;
        while (i > 0) {
            access = this.readUnsignedShort(u);
            name = this.readUTF8(u + 2, c);
            desc = this.readUTF8(u + 4, c);
            fieldValueItem = 0;
            signature = null;
            anns = 0;
            ianns = 0;
            cattrs = null;
            j = this.readUnsignedShort(u + 6);
            u += 8;
            while (j > 0) {
                attrName = this.readUTF8(u, c);
                if ("ConstantValue".equals(attrName)) {
                    fieldValueItem = this.readUnsignedShort(u + 6);
                } else if ("Signature".equals(attrName)) {
                    signature = this.readUTF8(u + 6, c);
                } else if ("Deprecated".equals(attrName)) {
                    access |= 131072;
                } else if ("Synthetic".equals(attrName)) {
                    access |= 266240;
                } else if ("RuntimeVisibleAnnotations".equals(attrName)) {
                    anns = u + 6;
                } else if ("RuntimeInvisibleAnnotations".equals(attrName)) {
                    ianns = u + 6;
                } else {
                    attr = this.readAttribute(attrs, attrName, u + 6, this.readInt(u + 2), c, -1, null);
                    if (attr != null) {
                        attr.next = cattrs;
                        cattrs = attr;
                    }
                }
                u += 6 + this.readInt(u + 2);
                --j;
            }
            fv = classVisitor.visitField(access, name, desc, signature, fieldValueItem == 0 ? null : this.readConst(fieldValueItem, c));
            if (fv != null) {
                for (j = 1; j >= 0; --j) {
                    v1 = v = j == 0 ? ianns : anns;
                    if (v == 0) continue;
                    k = this.readUnsignedShort(v);
                    v += 2;
                    while (k > 0) {
                        v = this.readAnnotationValues(v + 2, c, true, fv.visitAnnotation(this.readUTF8(v, c), j != 0));
                        --k;
                    }
                }
                while (cattrs != null) {
                    attr = cattrs.next;
                    cattrs.next = null;
                    fv.visitAttribute(cattrs);
                    cattrs = attr;
                }
                fv.visitEnd();
            }
            --i;
        }
        i = this.readUnsignedShort(u);
        u += 2;
        while (i > 0) {
            u0 = u + 6;
            access = this.readUnsignedShort(u);
            name = this.readUTF8(u + 2, c);
            desc = this.readUTF8(u + 4, c);
            signature = null;
            anns = 0;
            ianns = 0;
            dann = 0;
            mpanns = 0;
            impanns = 0;
            cattrs = null;
            v = 0;
            w = 0;
            j = this.readUnsignedShort(u + 6);
            u += 8;
            while (j > 0) {
                attrName = this.readUTF8(u, c);
                attrSize = this.readInt(u + 2);
                u += 6;
                if ("Code".equals(attrName)) {
                    if (!skipCode) {
                        v = u;
                    }
                } else if ("Exceptions".equals(attrName)) {
                    w = u;
                } else if ("Signature".equals(attrName)) {
                    signature = this.readUTF8(u, c);
                } else if ("Deprecated".equals(attrName)) {
                    access |= 131072;
                } else if ("RuntimeVisibleAnnotations".equals(attrName)) {
                    anns = u;
                } else if ("AnnotationDefault".equals(attrName)) {
                    dann = u;
                } else if ("Synthetic".equals(attrName)) {
                    access |= 266240;
                } else if ("RuntimeInvisibleAnnotations".equals(attrName)) {
                    ianns = u;
                } else if ("RuntimeVisibleParameterAnnotations".equals(attrName)) {
                    mpanns = u;
                } else if ("RuntimeInvisibleParameterAnnotations".equals(attrName)) {
                    impanns = u;
                } else {
                    attr = this.readAttribute(attrs, attrName, u, attrSize, c, -1, null);
                    if (attr != null) {
                        attr.next = cattrs;
                        cattrs = attr;
                    }
                }
                u += attrSize;
                --j;
            }
            if (w == 0) {
                exceptions = null;
            } else {
                exceptions = new String[this.readUnsignedShort(w)];
                w += 2;
                for (j = 0; j < exceptions.length; ++j) {
                    exceptions[j] = this.readClass(w, c);
                    w += 2;
                }
            }
            mv = classVisitor.visitMethod(access, name, desc, signature, exceptions);
            if (mv == null) ** GOTO lbl297
            if (!(mv instanceof MethodWriter)) ** GOTO lbl-1000
            mw = (MethodWriter)mv;
            if (mw.cw.cr != this || signature != mw.signature) ** GOTO lbl-1000
            sameExceptions = false;
            if (exceptions == null) {
                sameExceptions = mw.exceptionCount == 0;
            } else if (exceptions.length == mw.exceptionCount) {
                sameExceptions = true;
                for (j = exceptions.length - 1; j >= 0; --j) {
                    if (mw.exceptions[j] == this.readUnsignedShort(w -= 2)) continue;
                    sameExceptions = false;
                    break;
                }
            }
            if (sameExceptions) {
                mw.classReaderOffset = u0;
                mw.classReaderLength = u - u0;
            } else lbl-1000:
            // 3 sources

            {
                if (dann != 0) {
                    dv = mv.visitAnnotationDefault();
                    this.readAnnotationValue(dann, c, null, dv);
                    if (dv != null) {
                        dv.visitEnd();
                    }
                }
                for (j = 1; j >= 0; --j) {
                    v2 = w = j == 0 ? ianns : anns;
                    if (w == 0) continue;
                    k = this.readUnsignedShort(w);
                    w += 2;
                    while (k > 0) {
                        w = this.readAnnotationValues(w + 2, c, true, mv.visitAnnotation(this.readUTF8(w, c), j != 0));
                        --k;
                    }
                }
                if (mpanns != 0) {
                    this.readParameterAnnotations(mpanns, desc, c, true, mv);
                }
                if (impanns != 0) {
                    this.readParameterAnnotations(impanns, desc, c, false, mv);
                }
                while (cattrs != null) {
                    attr = cattrs.next;
                    cattrs.next = null;
                    mv.visitAttribute(cattrs);
                    cattrs = attr;
                }
lbl297:
                // 2 sources

                if (mv != null && v != 0) {
                    maxStack = this.readUnsignedShort(v);
                    maxLocals = this.readUnsignedShort(v + 2);
                    codeLength = this.readInt(v + 4);
                    codeStart = v += 8;
                    codeEnd = v + codeLength;
                    mv.visitCode();
                    labels = new Label[codeLength + 2];
                    this.readLabel(codeLength + 1, labels);
                    block58: while (v < codeEnd) {
                        w = v - codeStart;
                        opcode = b[v] & 255;
                        switch (ClassWriter.TYPE[opcode]) {
                            case 0: 
                            case 4: {
                                ++v;
                                continue block58;
                            }
                            case 8: {
                                this.readLabel(w + this.readShort(v + 1), labels);
                                v += 3;
                                continue block58;
                            }
                            case 9: {
                                this.readLabel(w + this.readInt(v + 1), labels);
                                v += 5;
                                continue block58;
                            }
                            case 16: {
                                opcode = b[v + 1] & 255;
                                if (opcode == 132) {
                                    v += 6;
                                    continue block58;
                                }
                                v += 4;
                                continue block58;
                            }
                            case 13: {
                                v = v + 4 - (w & 3);
                                this.readLabel(w + this.readInt(v), labels);
                                j = this.readInt(v + 8) - this.readInt(v + 4) + 1;
                                v += 12;
                                while (j > 0) {
                                    this.readLabel(w + this.readInt(v), labels);
                                    v += 4;
                                    --j;
                                }
                                continue block58;
                            }
                            case 14: {
                                v = v + 4 - (w & 3);
                                this.readLabel(w + this.readInt(v), labels);
                                j = this.readInt(v + 4);
                                v += 8;
                                while (j > 0) {
                                    this.readLabel(w + this.readInt(v + 4), labels);
                                    v += 8;
                                    --j;
                                }
                                continue block58;
                            }
                            case 1: 
                            case 3: 
                            case 10: {
                                v += 2;
                                continue block58;
                            }
                            case 2: 
                            case 5: 
                            case 6: 
                            case 11: 
                            case 12: {
                                v += 3;
                                continue block58;
                            }
                            case 7: {
                                v += 5;
                                continue block58;
                            }
                        }
                        v += 4;
                    }
                    j = this.readUnsignedShort(v);
                    v += 2;
                    while (j > 0) {
                        start = this.readLabel(this.readUnsignedShort(v), labels);
                        end = this.readLabel(this.readUnsignedShort(v + 2), labels);
                        handler = this.readLabel(this.readUnsignedShort(v + 4), labels);
                        type = this.readUnsignedShort(v + 6);
                        if (type == 0) {
                            mv.visitTryCatchBlock(start, end, handler, null);
                        } else {
                            mv.visitTryCatchBlock(start, end, handler, this.readUTF8(this.items[type], c));
                        }
                        v += 8;
                        --j;
                    }
                    varTable = 0;
                    varTypeTable = 0;
                    stackMap = 0;
                    stackMapSize = 0;
                    frameCount = 0;
                    frameMode = 0;
                    frameOffset = 0;
                    frameLocalCount = 0;
                    frameLocalDiff = 0;
                    frameStackCount = 0;
                    frameLocal = null;
                    frameStack = null;
                    zip = true;
                    cattrs = null;
                    j = this.readUnsignedShort(v);
                    v += 2;
                    while (j > 0) {
                        attrName = this.readUTF8(v, c);
                        if ("LocalVariableTable".equals(attrName)) {
                            if (!skipDebug) {
                                varTable = v + 6;
                                w = v + 8;
                                for (k = this.readUnsignedShort(v + 6); k > 0; --k) {
                                    label = this.readUnsignedShort(w);
                                    if (labels[label] == null) {
                                        this.readLabel((int)label, (Label[])labels).status |= 1;
                                    }
                                    if (labels[label += this.readUnsignedShort(w + 2)] == null) {
                                        this.readLabel((int)label, (Label[])labels).status |= 1;
                                    }
                                    w += 10;
                                }
                            }
                        } else if ("LocalVariableTypeTable".equals(attrName)) {
                            varTypeTable = v + 6;
                        } else if ("LineNumberTable".equals(attrName)) {
                            if (!skipDebug) {
                                w = v + 8;
                                for (k = this.readUnsignedShort(v + 6); k > 0; --k) {
                                    label = this.readUnsignedShort(w);
                                    if (labels[label] == null) {
                                        this.readLabel((int)label, (Label[])labels).status |= 1;
                                    }
                                    labels[label].line = this.readUnsignedShort(w + 2);
                                    w += 4;
                                }
                            }
                        } else if ("StackMapTable".equals(attrName)) {
                            if ((flags & 4) == 0) {
                                stackMap = v + 8;
                                stackMapSize = this.readInt(v + 2);
                                frameCount = this.readUnsignedShort(v + 6);
                            }
                        } else if ("StackMap".equals(attrName)) {
                            if ((flags & 4) == 0) {
                                stackMap = v + 8;
                                stackMapSize = this.readInt(v + 2);
                                frameCount = this.readUnsignedShort(v + 6);
                                zip = false;
                            }
                        } else {
                            for (k = 0; k < attrs.length; ++k) {
                                if (!attrs[k].type.equals(attrName) || (attr = attrs[k].read(this, v + 6, this.readInt(v + 2), c, codeStart - 8, labels)) == null) continue;
                                attr.next = cattrs;
                                cattrs = attr;
                            }
                        }
                        v += 6 + this.readInt(v + 2);
                        --j;
                    }
                    if (stackMap != 0) {
                        frameLocal = new Object[maxLocals];
                        frameStack = new Object[maxStack];
                        if (unzip) {
                            local = 0;
                            if ((access & 8) == 0) {
                                frameLocal[local++] = "<init>".equals(name) != false ? Opcodes.UNINITIALIZED_THIS : this.readClass(this.header + 2, c);
                            }
                            j = 1;
                            block66: while (true) {
                                k = j;
                                switch (desc.charAt(j++)) {
                                    case 'B': 
                                    case 'C': 
                                    case 'I': 
                                    case 'S': 
                                    case 'Z': {
                                        frameLocal[local++] = Opcodes.INTEGER;
                                        continue block66;
                                    }
                                    case 'F': {
                                        frameLocal[local++] = Opcodes.FLOAT;
                                        continue block66;
                                    }
                                    case 'J': {
                                        frameLocal[local++] = Opcodes.LONG;
                                        continue block66;
                                    }
                                    case 'D': {
                                        frameLocal[local++] = Opcodes.DOUBLE;
                                        continue block66;
                                    }
                                    case '[': {
                                        while (desc.charAt(j) == '[') {
                                            ++j;
                                        }
                                        if (desc.charAt(j) == 'L') {
                                            ++j;
                                            while (desc.charAt(j) != ';') {
                                                ++j;
                                            }
                                        }
                                        frameLocal[local++] = desc.substring(k, ++j);
                                        continue block66;
                                    }
                                    case 'L': {
                                        while (desc.charAt(j) != ';') {
                                            ++j;
                                        }
                                        frameLocal[local++] = desc.substring(k + 1, j++);
                                        continue block66;
                                    }
                                }
                                break;
                            }
                            frameLocalCount = local;
                        }
                        frameOffset = -1;
                        for (j = stackMap; j < stackMap + stackMapSize - 2; ++j) {
                            if (b[j] != 8 || (k = this.readUnsignedShort(j + 1)) < 0 || k >= codeLength || (b[codeStart + k] & 255) != 187) continue;
                            this.readLabel(k, labels);
                        }
                    }
                    v = codeStart;
                    block71: while (v < codeEnd) {
                        w = v - codeStart;
                        l = labels[w];
                        if (l != null) {
                            mv.visitLabel(l);
                            if (!skipDebug && l.line > 0) {
                                mv.visitLineNumber(l.line, l);
                            }
                        }
                        while (frameLocal != null && (frameOffset == w || frameOffset == -1)) {
                            if (!zip || unzip) {
                                mv.visitFrame(-1, frameLocalCount, frameLocal, frameStackCount, frameStack);
                            } else if (frameOffset != -1) {
                                mv.visitFrame(frameMode, frameLocalDiff, frameLocal, frameStackCount, frameStack);
                            }
                            if (frameCount > 0) {
                                if (zip) {
                                    tag = b[stackMap++] & 255;
                                } else {
                                    tag = 255;
                                    frameOffset = -1;
                                }
                                frameLocalDiff = 0;
                                if (tag < 64) {
                                    delta = tag;
                                    frameMode = 3;
                                    frameStackCount = 0;
                                } else if (tag < 128) {
                                    delta = tag - 64;
                                    stackMap = this.readFrameType(frameStack, 0, stackMap, c, labels);
                                    frameMode = 4;
                                    frameStackCount = 1;
                                } else {
                                    delta = this.readUnsignedShort(stackMap);
                                    stackMap += 2;
                                    if (tag == 247) {
                                        stackMap = this.readFrameType(frameStack, 0, stackMap, c, labels);
                                        frameMode = 4;
                                        frameStackCount = 1;
                                    } else if (tag >= 248 && tag < 251) {
                                        frameMode = 2;
                                        frameLocalDiff = 251 - tag;
                                        frameLocalCount -= frameLocalDiff;
                                        frameStackCount = 0;
                                    } else if (tag == 251) {
                                        frameMode = 3;
                                        frameStackCount = 0;
                                    } else if (tag < 255) {
                                        j = unzip != false ? frameLocalCount : 0;
                                        for (k = tag - 251; k > 0; --k) {
                                            stackMap = this.readFrameType(frameLocal, j++, stackMap, c, labels);
                                        }
                                        frameMode = 1;
                                        frameLocalDiff = tag - 251;
                                        frameLocalCount += frameLocalDiff;
                                        frameStackCount = 0;
                                    } else {
                                        frameMode = 0;
                                        frameLocalDiff = frameLocalCount = this.readUnsignedShort(stackMap);
                                        stackMap += 2;
                                        j = 0;
                                        for (n = frameLocalCount; n > 0; --n) {
                                            stackMap = this.readFrameType(frameLocal, j++, stackMap, c, labels);
                                        }
                                        n = frameStackCount = this.readUnsignedShort(stackMap);
                                        stackMap += 2;
                                        j = 0;
                                        while (n > 0) {
                                            stackMap = this.readFrameType(frameStack, j++, stackMap, c, labels);
                                            --n;
                                        }
                                    }
                                }
                                this.readLabel(frameOffset += delta + 1, labels);
                                --frameCount;
                                continue;
                            }
                            frameLocal = null;
                        }
                        opcode = b[v] & 255;
                        switch (ClassWriter.TYPE[opcode]) {
                            case 0: {
                                mv.visitInsn(opcode);
                                ++v;
                                continue block71;
                            }
                            case 4: {
                                if (opcode > 54) {
                                    mv.visitVarInsn(54 + ((opcode -= 59) >> 2), opcode & 3);
                                } else {
                                    mv.visitVarInsn(21 + ((opcode -= 26) >> 2), opcode & 3);
                                }
                                ++v;
                                continue block71;
                            }
                            case 8: {
                                mv.visitJumpInsn(opcode, labels[w + this.readShort(v + 1)]);
                                v += 3;
                                continue block71;
                            }
                            case 9: {
                                mv.visitJumpInsn(opcode - 33, labels[w + this.readInt(v + 1)]);
                                v += 5;
                                continue block71;
                            }
                            case 16: {
                                opcode = b[v + 1] & 255;
                                if (opcode == 132) {
                                    mv.visitIincInsn(this.readUnsignedShort(v + 2), this.readShort(v + 4));
                                    v += 6;
                                    continue block71;
                                }
                                mv.visitVarInsn(opcode, this.readUnsignedShort(v + 2));
                                v += 4;
                                continue block71;
                            }
                            case 13: {
                                v = v + 4 - (w & 3);
                                label = w + this.readInt(v);
                                min = this.readInt(v + 4);
                                max = this.readInt(v + 8);
                                v += 12;
                                table = new Label[max - min + 1];
                                for (j = 0; j < table.length; ++j) {
                                    table[j] = labels[w + this.readInt(v)];
                                    v += 4;
                                }
                                mv.visitTableSwitchInsn(min, max, labels[label], table);
                                continue block71;
                            }
                            case 14: {
                                v = v + 4 - (w & 3);
                                label = w + this.readInt(v);
                                j = this.readInt(v + 4);
                                v += 8;
                                keys = new int[j];
                                values = new Label[j];
                                for (j = 0; j < keys.length; ++j) {
                                    keys[j] = this.readInt(v);
                                    values[j] = labels[w + this.readInt(v + 4)];
                                    v += 8;
                                }
                                mv.visitLookupSwitchInsn(labels[label], keys, values);
                                continue block71;
                            }
                            case 3: {
                                mv.visitVarInsn(opcode, b[v + 1] & 255);
                                v += 2;
                                continue block71;
                            }
                            case 1: {
                                mv.visitIntInsn(opcode, b[v + 1]);
                                v += 2;
                                continue block71;
                            }
                            case 2: {
                                mv.visitIntInsn(opcode, this.readShort(v + 1));
                                v += 3;
                                continue block71;
                            }
                            case 10: {
                                mv.visitLdcInsn(this.readConst(b[v + 1] & 255, c));
                                v += 2;
                                continue block71;
                            }
                            case 11: {
                                mv.visitLdcInsn(this.readConst(this.readUnsignedShort(v + 1), c));
                                v += 3;
                                continue block71;
                            }
                            case 6: 
                            case 7: {
                                cpIndex = this.items[this.readUnsignedShort(v + 1)];
                                if (opcode == 186) {
                                    iowner = "java/lang/dyn/Dynamic";
                                } else {
                                    iowner = this.readClass(cpIndex, c);
                                    cpIndex = this.items[this.readUnsignedShort(cpIndex + 2)];
                                }
                                iname = this.readUTF8(cpIndex, c);
                                idesc = this.readUTF8(cpIndex + 2, c);
                                if (opcode < 182) {
                                    mv.visitFieldInsn(opcode, iowner, iname, idesc);
                                } else {
                                    mv.visitMethodInsn(opcode, iowner, iname, idesc);
                                }
                                if (opcode == 185 || opcode == 186) {
                                    v += 5;
                                    continue block71;
                                }
                                v += 3;
                                continue block71;
                            }
                            case 5: {
                                mv.visitTypeInsn(opcode, this.readClass(v + 1, c));
                                v += 3;
                                continue block71;
                            }
                            case 12: {
                                mv.visitIincInsn(b[v + 1] & 255, b[v + 2]);
                                v += 3;
                                continue block71;
                            }
                        }
                        mv.visitMultiANewArrayInsn(this.readClass(v + 1, c), b[v + 3] & 255);
                        v += 4;
                    }
                    l = labels[codeEnd - codeStart];
                    if (l != null) {
                        mv.visitLabel(l);
                    }
                    if (!skipDebug && varTable != 0) {
                        typeTable = null;
                        if (varTypeTable != 0) {
                            k = this.readUnsignedShort(varTypeTable) * 3;
                            w = varTypeTable + 2;
                            typeTable = new int[k];
                            while (k > 0) {
                                typeTable[--k] = w + 6;
                                typeTable[--k] = this.readUnsignedShort(w + 8);
                                typeTable[--k] = this.readUnsignedShort(w);
                                w += 10;
                            }
                        }
                        w = varTable + 2;
                        for (k = this.readUnsignedShort(varTable); k > 0; --k) {
                            start = this.readUnsignedShort(w);
                            length = this.readUnsignedShort(w + 2);
                            index = this.readUnsignedShort(w + 8);
                            vsignature = null;
                            if (typeTable != null) {
                                for (a = 0; a < typeTable.length; a += 3) {
                                    if (typeTable[a] != start || typeTable[a + 1] != index) continue;
                                    vsignature = this.readUTF8(typeTable[a + 2], c);
                                    break;
                                }
                            }
                            mv.visitLocalVariable(this.readUTF8(w + 4, c), this.readUTF8(w + 6, c), vsignature, labels[start], labels[start + length], index);
                            w += 10;
                        }
                    }
                    while (cattrs != null) {
                        attr = cattrs.next;
                        cattrs.next = null;
                        mv.visitAttribute(cattrs);
                        cattrs = attr;
                    }
                    mv.visitMaxs(maxStack, maxLocals);
                }
                if (mv != null) {
                    mv.visitEnd();
                }
            }
            --i;
        }
        classVisitor.visitEnd();
    }

    private void readParameterAnnotations(int v, String desc, char[] buf, boolean visible, MethodVisitor mv) {
        AnnotationVisitor av;
        int i2;
        int n = this.b[v++] & 0xFF;
        int synthetics = Type.getArgumentTypes(desc).length - n;
        for (i2 = 0; i2 < synthetics; ++i2) {
            av = mv.visitParameterAnnotation(i2, "Ljava/lang/Synthetic;", false);
            if (av == null) continue;
            av.visitEnd();
        }
        while (i2 < n + synthetics) {
            int j = this.readUnsignedShort(v);
            v += 2;
            while (j > 0) {
                av = mv.visitParameterAnnotation(i2, this.readUTF8(v, buf), visible);
                v = this.readAnnotationValues(v + 2, buf, true, av);
                --j;
            }
            ++i2;
        }
    }

    private int readAnnotationValues(int v, char[] buf, boolean named, AnnotationVisitor av) {
        int i2 = this.readUnsignedShort(v);
        v += 2;
        if (named) {
            while (i2 > 0) {
                v = this.readAnnotationValue(v + 2, buf, this.readUTF8(v, buf), av);
                --i2;
            }
        } else {
            while (i2 > 0) {
                v = this.readAnnotationValue(v, buf, null, av);
                --i2;
            }
        }
        if (av != null) {
            av.visitEnd();
        }
        return v;
    }

    private int readAnnotationValue(int v, char[] buf, String name2, AnnotationVisitor av) {
        if (av == null) {
            switch (this.b[v] & 0xFF) {
                case 101: {
                    return v + 5;
                }
                case 64: {
                    return this.readAnnotationValues(v + 3, buf, true, null);
                }
                case 91: {
                    return this.readAnnotationValues(v + 1, buf, false, null);
                }
            }
            return v + 3;
        }
        block5 : switch (this.b[v++] & 0xFF) {
            case 68: 
            case 70: 
            case 73: 
            case 74: {
                av.visit(name2, this.readConst(this.readUnsignedShort(v), buf));
                v += 2;
                break;
            }
            case 66: {
                av.visit(name2, new Byte((byte)this.readInt(this.items[this.readUnsignedShort(v)])));
                v += 2;
                break;
            }
            case 90: {
                av.visit(name2, this.readInt(this.items[this.readUnsignedShort(v)]) == 0 ? Boolean.FALSE : Boolean.TRUE);
                v += 2;
                break;
            }
            case 83: {
                av.visit(name2, new Short((short)this.readInt(this.items[this.readUnsignedShort(v)])));
                v += 2;
                break;
            }
            case 67: {
                av.visit(name2, new Character((char)this.readInt(this.items[this.readUnsignedShort(v)])));
                v += 2;
                break;
            }
            case 115: {
                av.visit(name2, this.readUTF8(v, buf));
                v += 2;
                break;
            }
            case 101: {
                av.visitEnum(name2, this.readUTF8(v, buf), this.readUTF8(v + 2, buf));
                v += 4;
                break;
            }
            case 99: {
                av.visit(name2, Type.getType(this.readUTF8(v, buf)));
                v += 2;
                break;
            }
            case 64: {
                v = this.readAnnotationValues(v + 2, buf, true, av.visitAnnotation(name2, this.readUTF8(v, buf)));
                break;
            }
            case 91: {
                int size2 = this.readUnsignedShort(v);
                v += 2;
                if (size2 == 0) {
                    return this.readAnnotationValues(v - 2, buf, false, av.visitArray(name2));
                }
                switch (this.b[v++] & 0xFF) {
                    case 66: {
                        byte[] bv = new byte[size2];
                        for (int i2 = 0; i2 < size2; ++i2) {
                            bv[i2] = (byte)this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name2, bv);
                        --v;
                        break block5;
                    }
                    case 90: {
                        boolean[] zv = new boolean[size2];
                        for (int i2 = 0; i2 < size2; ++i2) {
                            zv[i2] = this.readInt(this.items[this.readUnsignedShort(v)]) != 0;
                            v += 3;
                        }
                        av.visit(name2, zv);
                        --v;
                        break block5;
                    }
                    case 83: {
                        short[] sv = new short[size2];
                        for (int i2 = 0; i2 < size2; ++i2) {
                            sv[i2] = (short)this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name2, sv);
                        --v;
                        break block5;
                    }
                    case 67: {
                        char[] cv = new char[size2];
                        for (int i2 = 0; i2 < size2; ++i2) {
                            cv[i2] = (char)this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name2, cv);
                        --v;
                        break block5;
                    }
                    case 73: {
                        int[] iv = new int[size2];
                        for (int i2 = 0; i2 < size2; ++i2) {
                            iv[i2] = this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name2, iv);
                        --v;
                        break block5;
                    }
                    case 74: {
                        long[] lv = new long[size2];
                        for (int i2 = 0; i2 < size2; ++i2) {
                            lv[i2] = this.readLong(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name2, lv);
                        --v;
                        break block5;
                    }
                    case 70: {
                        float[] fv = new float[size2];
                        for (int i2 = 0; i2 < size2; ++i2) {
                            fv[i2] = Float.intBitsToFloat(this.readInt(this.items[this.readUnsignedShort(v)]));
                            v += 3;
                        }
                        av.visit(name2, fv);
                        --v;
                        break block5;
                    }
                    case 68: {
                        double[] dv = new double[size2];
                        for (int i2 = 0; i2 < size2; ++i2) {
                            dv[i2] = Double.longBitsToDouble(this.readLong(this.items[this.readUnsignedShort(v)]));
                            v += 3;
                        }
                        av.visit(name2, dv);
                        --v;
                        break block5;
                    }
                }
                v = this.readAnnotationValues(v - 3, buf, false, av.visitArray(name2));
            }
        }
        return v;
    }

    private int readFrameType(Object[] frame, int index2, int v, char[] buf, Label[] labels) {
        int type2 = this.b[v++] & 0xFF;
        switch (type2) {
            case 0: {
                frame[index2] = Opcodes.TOP;
                break;
            }
            case 1: {
                frame[index2] = Opcodes.INTEGER;
                break;
            }
            case 2: {
                frame[index2] = Opcodes.FLOAT;
                break;
            }
            case 3: {
                frame[index2] = Opcodes.DOUBLE;
                break;
            }
            case 4: {
                frame[index2] = Opcodes.LONG;
                break;
            }
            case 5: {
                frame[index2] = Opcodes.NULL;
                break;
            }
            case 6: {
                frame[index2] = Opcodes.UNINITIALIZED_THIS;
                break;
            }
            case 7: {
                frame[index2] = this.readClass(v, buf);
                v += 2;
                break;
            }
            default: {
                frame[index2] = this.readLabel(this.readUnsignedShort(v), labels);
                v += 2;
            }
        }
        return v;
    }

    protected Label readLabel(int offset2, Label[] labels) {
        if (labels[offset2] == null) {
            labels[offset2] = new Label();
        }
        return labels[offset2];
    }

    private Attribute readAttribute(Attribute[] attrs, String type2, int off, int len, char[] buf, int codeOff, Label[] labels) {
        for (int i2 = 0; i2 < attrs.length; ++i2) {
            if (!attrs[i2].type.equals(type2)) continue;
            return attrs[i2].read(this, off, len, buf, codeOff, labels);
        }
        return new Attribute(type2).read(this, off, len, null, -1, null);
    }

    public int getItem(int item) {
        return this.items[item];
    }

    public int readByte(int index2) {
        return this.b[index2] & 0xFF;
    }

    public int readUnsignedShort(int index2) {
        byte[] b = this.b;
        return (b[index2] & 0xFF) << 8 | b[index2 + 1] & 0xFF;
    }

    public short readShort(int index2) {
        byte[] b = this.b;
        return (short)((b[index2] & 0xFF) << 8 | b[index2 + 1] & 0xFF);
    }

    public int readInt(int index2) {
        byte[] b = this.b;
        return (b[index2] & 0xFF) << 24 | (b[index2 + 1] & 0xFF) << 16 | (b[index2 + 2] & 0xFF) << 8 | b[index2 + 3] & 0xFF;
    }

    public long readLong(int index2) {
        long l1 = this.readInt(index2);
        long l0 = (long)this.readInt(index2 + 4) & 0xFFFFFFFFL;
        return l1 << 32 | l0;
    }

    public String readUTF8(int index2, char[] buf) {
        int item = this.readUnsignedShort(index2);
        String s2 = this.strings[item];
        if (s2 != null) {
            return s2;
        }
        index2 = this.items[item];
        this.strings[item] = this.readUTF(index2 + 2, this.readUnsignedShort(index2), buf);
        return this.strings[item];
    }

    private String readUTF(int index2, int utfLen, char[] buf) {
        int endIndex = index2 + utfLen;
        byte[] b = this.b;
        int strLen = 0;
        int st = 0;
        int cc = 0;
        while (index2 < endIndex) {
            int c = b[index2++];
            switch (st) {
                case 0: {
                    if ((c &= 0xFF) < 128) {
                        buf[strLen++] = (char)c;
                        break;
                    }
                    if (c < 224 && c > 191) {
                        cc = (char)(c & 0x1F);
                        st = 1;
                        break;
                    }
                    cc = (char)(c & 0xF);
                    st = 2;
                    break;
                }
                case 1: {
                    buf[strLen++] = (char)(cc << 6 | c & 0x3F);
                    st = 0;
                    break;
                }
                case 2: {
                    cc = (char)(cc << 6 | c & 0x3F);
                    st = 1;
                }
            }
        }
        return new String(buf, 0, strLen);
    }

    public String readClass(int index2, char[] buf) {
        return this.readUTF8(this.items[this.readUnsignedShort(index2)], buf);
    }

    public Object readConst(int item, char[] buf) {
        int index2 = this.items[item];
        switch (this.b[index2 - 1]) {
            case 3: {
                return new Integer(this.readInt(index2));
            }
            case 4: {
                return new Float(Float.intBitsToFloat(this.readInt(index2)));
            }
            case 5: {
                return new Long(this.readLong(index2));
            }
            case 6: {
                return new Double(Double.longBitsToDouble(this.readLong(index2)));
            }
            case 7: {
                return Type.getObjectType(this.readUTF8(index2, buf));
            }
        }
        return this.readUTF8(index2, buf);
    }
}

