/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.ast;

import org.elasticsearch.common.mvel2.CompileException;
import org.elasticsearch.common.mvel2.MVEL;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.PropertyAccessor;
import org.elasticsearch.common.mvel2.ast.ASTNode;
import org.elasticsearch.common.mvel2.ast.Assignment;
import org.elasticsearch.common.mvel2.compiler.CompiledAccExpression;
import org.elasticsearch.common.mvel2.compiler.ExecutableStatement;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.util.ArrayTools;
import org.elasticsearch.common.mvel2.util.ParseTools;

public class AssignmentNode
extends ASTNode
implements Assignment {
    private String varName;
    private transient CompiledAccExpression accExpr;
    private char[] indexTarget;
    private String index;
    private ExecutableStatement statement;
    private boolean col = false;

    public AssignmentNode(char[] expr, int start2, int offset2, int fields2, ParserContext pCtx) {
        super(pCtx);
        this.expr = expr;
        this.start = start2;
        this.offset = offset2;
        int assignStart = ParseTools.find(expr, start2, offset2, '=');
        if (assignStart != -1) {
            this.varName = ParseTools.createStringTrimmed(expr, start2, assignStart - start2);
            this.start = ParseTools.skipWhitespace(expr, assignStart + 1);
            if (this.start >= start2 + offset2) {
                throw new CompileException("unexpected end of statement", expr, assignStart + 1);
            }
            this.offset = offset2 - (this.start - start2);
            if ((fields2 & 0x10) != 0) {
                this.statement = (ExecutableStatement)ParseTools.subCompileExpression(expr, this.start, this.offset, pCtx);
                this.egressType = this.statement.getKnownEgressType();
            }
            this.indexTarget = this.varName.toCharArray();
            this.endOfName = ArrayTools.findFirst('[', 0, this.varName.length(), this.indexTarget);
            this.col = this.endOfName > 0;
            if (this.col) {
                if (((this.fields |= 0x100) & 0x10) != 0) {
                    this.accExpr = (CompiledAccExpression)MVEL.compileSetExpression(this.indexTarget, pCtx);
                }
                this.varName = new String(expr, start2, this.endOfName);
                this.index = new String(this.indexTarget, this.endOfName, this.indexTarget.length - this.endOfName);
            }
            try {
                ParseTools.checkNameSafety(this.varName);
            }
            catch (RuntimeException e) {
                throw new CompileException(e.getMessage(), expr, start2);
            }
        }
        try {
            this.varName = new String(expr, start2, offset2);
            ParseTools.checkNameSafety(this.varName);
        }
        catch (RuntimeException e) {
            throw new CompileException(e.getMessage(), expr, start2);
        }
        if ((fields2 & 0x10) != 0) {
            pCtx.addVariable(this.varName, this.egressType);
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.accExpr == null && this.indexTarget != null) {
            this.accExpr = (CompiledAccExpression)MVEL.compileSetExpression(this.indexTarget);
        }
        if (this.col) {
            return this.accExpr.setValue(ctx, thisValue, factory, this.statement.getValue(ctx, thisValue, factory));
        }
        if (this.statement != null) {
            if (factory == null) {
                throw new CompileException("cannot assign variables; no variable resolver factory available", this.expr, this.start);
            }
            return factory.createVariable(this.varName, this.statement.getValue(ctx, thisValue, factory)).getValue();
        }
        if (factory == null) {
            throw new CompileException("cannot assign variables; no variable resolver factory available", this.expr, this.start);
        }
        factory.createVariable(this.varName, null);
        return null;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ParseTools.checkNameSafety(this.varName);
        if (!this.col) {
            return factory.createVariable(this.varName, MVEL.eval(this.expr, this.start, this.offset, ctx, factory)).getValue();
        }
        ctx = MVEL.eval(this.expr, this.start, this.offset, ctx, factory);
        PropertyAccessor.set(factory.getVariableResolver(this.varName).getValue(), factory, this.index, ctx, this.pCtx);
        return ctx;
    }

    public String getAssignmentVar() {
        return this.varName;
    }

    public char[] getExpression() {
        return ParseTools.subset(this.expr, this.start, this.offset);
    }

    public boolean isNewDeclaration() {
        return false;
    }

    public void setValueStatement(ExecutableStatement stmt) {
        this.statement = stmt;
    }

    public String toString() {
        return this.varName + " = " + new String(this.expr, this.start, this.offset);
    }
}

