/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.ast;

import org.elasticsearch.common.mvel2.CompileException;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.ast.ASTNode;
import org.elasticsearch.common.mvel2.ast.Assignment;
import org.elasticsearch.common.mvel2.compiler.ExecutableStatement;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.util.ParseTools;

public class DeclTypedVarNode
extends ASTNode
implements Assignment {
    private String name;

    public DeclTypedVarNode(String name2, char[] expr, int start2, int offset2, Class type2, int fields2, ParserContext pCtx) {
        super(pCtx);
        this.egressType = type2;
        this.name = name2;
        ParseTools.checkNameSafety(this.name);
        this.expr = expr;
        this.start = start2;
        this.offset = offset2;
        if ((fields2 & 0x10) != 0) {
            pCtx.addVariable(name2, this.egressType, true);
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (factory.isResolveable(this.name)) {
            throw new CompileException("variable defined within scope: " + this.name, this.expr, this.start);
        }
        factory.createVariable(this.name, null, this.egressType);
        return null;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (factory.isResolveable(this.name)) {
            throw new CompileException("variable defined within scope: " + this.name, this.expr, this.start);
        }
        factory.createVariable(this.name, null, this.egressType);
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getAssignmentVar() {
        return this.name;
    }

    public char[] getExpression() {
        return new char[0];
    }

    public boolean isAssignment() {
        return true;
    }

    public boolean isNewDeclaration() {
        return true;
    }

    public void setValueStatement(ExecutableStatement stmt) {
        throw new RuntimeException("illegal operation");
    }

    public String toString() {
        return "var:" + this.name;
    }
}

