/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.ast;

import org.elasticsearch.common.mvel2.CompileException;
import org.elasticsearch.common.mvel2.MVEL;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.ast.ASTNode;
import org.elasticsearch.common.mvel2.ast.Assignment;
import org.elasticsearch.common.mvel2.compiler.CompiledAccExpression;
import org.elasticsearch.common.mvel2.compiler.ExecutableStatement;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.util.ArrayTools;
import org.elasticsearch.common.mvel2.util.ParseTools;

public class IndexedAssignmentNode
extends ASTNode
implements Assignment {
    private String name;
    private int register;
    private transient CompiledAccExpression accExpr;
    private char[] indexTarget;
    private char[] index;
    private char[] stmt;
    private ExecutableStatement statement;
    private boolean col = false;

    public IndexedAssignmentNode(char[] expr, int start2, int offset2, int fields2, int operation, String name2, int register, ParserContext pCtx) {
        super(pCtx);
        this.expr = expr;
        this.start = start2;
        this.offset = offset2;
        this.register = register;
        if (operation != -1) {
            this.name = name2;
            ParseTools.checkNameSafety(this.name);
            this.stmt = ParseTools.createShortFormOperativeAssignment(name2, expr, start2, offset2, operation);
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.stmt, pCtx);
            this.egressType = this.statement.getKnownEgressType();
        } else {
            int assignStart = ParseTools.find(expr, start2, offset2, '=');
            if (assignStart != -1) {
                this.name = ParseTools.createStringTrimmed(expr, start2, assignStart - start2);
                this.start = ParseTools.skipWhitespace(expr, assignStart + 1);
                if (this.start >= start2 + offset2) {
                    throw new CompileException("unexpected end of statement", expr, assignStart + 1);
                }
                this.offset = offset2 - (this.start - start2);
                this.stmt = ParseTools.subset(expr, this.start, this.offset);
                this.statement = (ExecutableStatement)ParseTools.subCompileExpression(expr, this.start, this.offset, pCtx);
                this.egressType = this.statement.getKnownEgressType();
                this.indexTarget = this.name.toCharArray();
                short s2 = (short)ArrayTools.findFirst('[', 0, this.name.length(), this.indexTarget);
                this.endOfName = s2;
                this.col = s2 > 0;
                if (this.col) {
                    if (((this.fields |= 0x100) & 0x10) != 0) {
                        this.accExpr = (CompiledAccExpression)MVEL.compileSetExpression(this.indexTarget, pCtx);
                    }
                    this.name = this.name.substring(0, this.endOfName);
                    this.index = ParseTools.subset(this.indexTarget, this.endOfName, this.indexTarget.length - this.endOfName);
                }
                ParseTools.checkNameSafety(this.name);
            } else {
                this.name = new String(expr);
                ParseTools.checkNameSafety(this.name);
            }
        }
        if ((fields2 & 0x10) != 0) {
            pCtx.addVariable(name2, this.egressType);
        }
    }

    public IndexedAssignmentNode(char[] expr, int start2, int offset2, int fields2, int register, ParserContext pCtx) {
        this(expr, start2, offset2, fields2, -1, null, register, pCtx);
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.accExpr == null && this.indexTarget != null) {
            this.accExpr = (CompiledAccExpression)MVEL.compileSetExpression(this.indexTarget);
        }
        if (this.col) {
            Object object = ctx;
            ctx = this.statement.getValue(ctx, thisValue, factory);
            this.accExpr.setValue(object, thisValue, factory, ctx);
        } else if (this.statement != null) {
            if (factory.isIndexedFactory()) {
                ctx = this.statement.getValue(ctx, thisValue, factory);
                factory.createIndexedVariable(this.register, this.name, ctx);
            } else {
                ctx = this.statement.getValue(ctx, thisValue, factory);
                factory.createVariable(this.name, ctx);
            }
        } else {
            if (factory.isIndexedFactory()) {
                factory.createIndexedVariable(this.register, this.name, null);
            } else {
                factory.createVariable(this.name, this.statement.getValue(ctx, thisValue, factory));
            }
            return Void.class;
        }
        return ctx;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ParseTools.checkNameSafety(this.name);
        if (this.col) {
            ctx = MVEL.eval(this.stmt, ctx, factory);
            MVEL.setProperty(factory.getIndexedVariableResolver(this.register).getValue(), new String(this.index), ctx);
        } else {
            ctx = MVEL.eval(this.stmt, ctx, factory);
            factory.createIndexedVariable(this.register, this.name, ctx);
        }
        return ctx;
    }

    public String getAssignmentVar() {
        return this.name;
    }

    public char[] getExpression() {
        return this.stmt;
    }

    public int getRegister() {
        return this.register;
    }

    public void setRegister(int register) {
        this.register = register;
    }

    public boolean isAssignment() {
        return true;
    }

    public String getAbsoluteName() {
        return this.name;
    }

    public boolean isNewDeclaration() {
        return false;
    }

    public void setValueStatement(ExecutableStatement stmt) {
        this.statement = stmt;
    }
}

