/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.ast;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.mvel2.CompileException;
import org.elasticsearch.common.mvel2.DataConversion;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.UnresolveablePropertyException;
import org.elasticsearch.common.mvel2.ast.ASTNode;
import org.elasticsearch.common.mvel2.ast.Function;
import org.elasticsearch.common.mvel2.compiler.ExecutableStatement;
import org.elasticsearch.common.mvel2.integration.VariableResolver;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.integration.impl.MapVariableResolverFactory;
import org.elasticsearch.common.mvel2.integration.impl.SimpleValueResolver;
import org.elasticsearch.common.mvel2.util.CallableProxy;
import org.elasticsearch.common.mvel2.util.SimpleIndexHashMapWrapper;

public class Proto
extends ASTNode {
    private String name;
    private Map<String, Receiver> receivers;
    private int cursorStart;
    private int cursorEnd;

    public Proto(String name2, ParserContext pCtx) {
        super(pCtx);
        this.name = name2;
        this.receivers = new SimpleIndexHashMapWrapper<String, Receiver>();
    }

    public Receiver declareReceiver(String name2, Function function) {
        Receiver r = new Receiver(null, ReceiverType.FUNCTION, function);
        this.receivers.put(name2, r);
        return r;
    }

    public Receiver declareReceiver(String name2, Class type2, ExecutableStatement initCode) {
        Receiver r = new Receiver(null, ReceiverType.PROPERTY, initCode);
        this.receivers.put(name2, r);
        return r;
    }

    public Receiver declareReceiver(String name2, ReceiverType type2, ExecutableStatement initCode) {
        Receiver r = new Receiver(null, type2, initCode);
        this.receivers.put(name2, r);
        return r;
    }

    public ProtoInstance newInstance(Object ctx, Object thisCtx, VariableResolverFactory factory) {
        return new ProtoInstance(this, ctx, thisCtx, factory);
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        factory.createVariable(this.name, this);
        return this;
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        factory.createVariable(this.name, this);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "proto " + this.name;
    }

    public void setCursorPosition(int start2, int end2) {
        this.cursorStart = start2;
        this.cursorEnd = end2;
    }

    public int getCursorStart() {
        return this.cursorStart;
    }

    public int getCursorEnd() {
        return this.cursorEnd;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class InvokationContextFactory
    extends MapVariableResolverFactory {
        private VariableResolverFactory protoContext;

        public InvokationContextFactory(VariableResolverFactory next, VariableResolverFactory protoContext) {
            this.nextFactory = next;
            this.protoContext = protoContext;
        }

        @Override
        public VariableResolver createVariable(String name2, Object value2) {
            if (this.isResolveable(name2) && !this.protoContext.isResolveable(name2)) {
                return this.nextFactory.createVariable(name2, value2);
            }
            return this.protoContext.createVariable(name2, value2);
        }

        @Override
        public VariableResolver createVariable(String name2, Object value2, Class<?> type2) {
            if (this.isResolveable(name2) && !this.protoContext.isResolveable(name2)) {
                return this.nextFactory.createVariable(name2, value2, type2);
            }
            return this.protoContext.createVariable(name2, value2, type2);
        }

        @Override
        public VariableResolver getVariableResolver(String name2) {
            if (this.isResolveable(name2) && !this.protoContext.isResolveable(name2)) {
                return this.nextFactory.getVariableResolver(name2);
            }
            return this.protoContext.getVariableResolver(name2);
        }

        @Override
        public boolean isTarget(String name2) {
            return this.protoContext.isTarget(name2);
        }

        @Override
        public boolean isResolveable(String name2) {
            return this.protoContext.isResolveable(name2) || this.nextFactory.isResolveable(name2);
        }

        @Override
        public boolean isIndexedFactory() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ProtoResolver
    implements VariableResolver {
        private String name;
        private Class<?> knownType;
        private Map<String, Object> variableMap;

        public ProtoResolver(Map<String, Object> variableMap, String name2) {
            this.variableMap = variableMap;
            this.name = name2;
        }

        public ProtoResolver(Map<String, Object> variableMap, String name2, Class knownType) {
            this.name = name2;
            this.knownType = knownType;
            this.variableMap = variableMap;
        }

        public void setName(String name2) {
            this.name = name2;
        }

        @Override
        public void setStaticType(Class knownType) {
            this.knownType = knownType;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class getType() {
            return this.knownType;
        }

        @Override
        public void setValue(Object value2) {
            if (this.knownType != null && value2 != null && value2.getClass() != this.knownType) {
                if (!DataConversion.canConvert(this.knownType, value2.getClass())) {
                    throw new CompileException("cannot assign " + value2.getClass().getName() + " to type: " + this.knownType.getName(), Proto.this.expr, Proto.this.start);
                }
                try {
                    value2 = DataConversion.convert(value2, this.knownType);
                }
                catch (Exception e) {
                    throw new CompileException("cannot convert value of " + value2.getClass().getName() + " to: " + this.knownType.getName(), Proto.this.expr, Proto.this.start);
                }
            }
            ((Receiver)this.variableMap.get(this.name)).receiver = value2;
        }

        @Override
        public Object getValue() {
            return ((Receiver)this.variableMap.get(this.name)).receiver;
        }

        @Override
        public int getFlags() {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ProtoContextFactory
    extends MapVariableResolverFactory {
        private final SimpleIndexHashMapWrapper<String, VariableResolver> variableResolvers;

        public ProtoContextFactory(SimpleIndexHashMapWrapper variables) {
            super(variables);
            this.variableResolvers = new SimpleIndexHashMapWrapper(variables, true);
        }

        @Override
        public VariableResolver createVariable(String name2, Object value2) {
            try {
                VariableResolver vr = this.getVariableResolver(name2);
                vr.setValue(value2);
                return vr;
            }
            catch (UnresolveablePropertyException e) {
                ProtoResolver vr = new ProtoResolver(this.variables, name2);
                this.addResolver(name2, vr).setValue(value2);
                return vr;
            }
        }

        @Override
        public VariableResolver createVariable(String name2, Object value2, Class<?> type2) {
            VariableResolver vr;
            try {
                vr = this.getVariableResolver(name2);
            }
            catch (UnresolveablePropertyException e) {
                vr = null;
            }
            if (vr != null && vr.getType() != null) {
                throw new CompileException("variable already defined within scope: " + vr.getType() + " " + name2, Proto.this.expr, Proto.this.start);
            }
            vr = new ProtoResolver(this.variables, name2, type2);
            this.addResolver(name2, vr).setValue(value2);
            return vr;
        }

        @Override
        public void setIndexedVariableNames(String[] indexedVariableNames) {
        }

        @Override
        public String[] getIndexedVariableNames() {
            return null;
        }

        @Override
        public VariableResolver createIndexedVariable(int index2, String name2, Object value2, Class<?> type2) {
            VariableResolver vr;
            VariableResolver variableResolver = vr = this.variableResolvers != null ? this.variableResolvers.getByIndex(index2) : null;
            if (vr != null && vr.getType() != null) {
                throw new CompileException("variable already defined within scope: " + vr.getType() + " " + name2, Proto.this.expr, Proto.this.start);
            }
            return this.createIndexedVariable(this.variableIndexOf(name2), name2, value2);
        }

        @Override
        public VariableResolver createIndexedVariable(int index2, String name2, Object value2) {
            VariableResolver vr = this.variableResolvers.getByIndex(index2);
            if (vr == null) {
                vr = new SimpleValueResolver(value2);
                this.variableResolvers.putAtIndex(index2, vr);
            } else {
                vr.setValue(value2);
            }
            return this.indexedVariableResolvers[index2];
        }

        @Override
        public VariableResolver getIndexedVariableResolver(int index2) {
            return this.variableResolvers.getByIndex(index2);
        }

        @Override
        public VariableResolver setIndexedVariableResolver(int index2, VariableResolver resolver) {
            this.variableResolvers.putAtIndex(index2, resolver);
            return resolver;
        }

        @Override
        public int variableIndexOf(String name2) {
            return this.variableResolvers.indexOf(name2);
        }

        @Override
        public VariableResolver getVariableResolver(String name2) {
            VariableResolver vr = this.variableResolvers.get(name2);
            if (vr != null) {
                return vr;
            }
            if (this.variables.containsKey(name2)) {
                vr = new ProtoResolver(this.variables, name2);
                this.variableResolvers.put(name2, vr);
                return vr;
            }
            if (this.nextFactory != null) {
                return this.nextFactory.getVariableResolver(name2);
            }
            throw new UnresolveablePropertyException("unable to resolve variable '" + name2 + "'");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ProtoInstance
    implements Map<String, Receiver> {
        private Proto protoType;
        private VariableResolverFactory instanceStates;
        private SimpleIndexHashMapWrapper<String, Receiver> receivers;

        public ProtoInstance(Proto protoType, Object ctx, Object thisCtx, VariableResolverFactory factory) {
            this.protoType = protoType;
            this.receivers = new SimpleIndexHashMapWrapper();
            for (Map.Entry entry : protoType.receivers.entrySet()) {
                this.receivers.put((String)entry.getKey(), ((Receiver)entry.getValue()).init(this, ctx, thisCtx, factory));
            }
            this.instanceStates = new ProtoContextFactory(this.receivers);
        }

        public Proto getProtoType() {
            return this.protoType;
        }

        @Override
        public int size() {
            return this.receivers.size();
        }

        @Override
        public boolean isEmpty() {
            return this.receivers.isEmpty();
        }

        @Override
        public boolean containsKey(Object key2) {
            return this.receivers.containsKey(key2);
        }

        @Override
        public boolean containsValue(Object value2) {
            return this.receivers.containsValue(value2);
        }

        @Override
        public Receiver get(Object key2) {
            return this.receivers.get(key2);
        }

        @Override
        public Receiver put(String key2, Receiver value2) {
            return this.receivers.put(key2, value2);
        }

        @Override
        public Receiver remove(Object key2) {
            return this.receivers.remove(key2);
        }

        @Override
        public void putAll(Map m) {
        }

        @Override
        public void clear() {
        }

        @Override
        public Set<String> keySet() {
            return this.receivers.keySet();
        }

        @Override
        public Collection<Receiver> values() {
            return this.receivers.values();
        }

        @Override
        public Set<Map.Entry<String, Receiver>> entrySet() {
            return this.receivers.entrySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReceiverType {
        DEFERRED,
        FUNCTION,
        PROPERTY;

    }

    public class Receiver
    implements CallableProxy {
        private ReceiverType type;
        private Object receiver;
        private ExecutableStatement initValue;
        private ProtoInstance instance;

        public Receiver(ProtoInstance protoInstance, ReceiverType type2, Object receiver2) {
            this.instance = protoInstance;
            this.type = type2;
            this.receiver = receiver2;
        }

        public Receiver(ProtoInstance protoInstance, ReceiverType type2, ExecutableStatement stmt) {
            this.instance = protoInstance;
            this.type = type2;
            this.initValue = stmt;
        }

        public Object call(Object ctx, Object thisCtx, VariableResolverFactory factory, Object[] parms) {
            switch (this.type) {
                case FUNCTION: {
                    return ((Function)this.receiver).call(ctx, thisCtx, new InvokationContextFactory(factory, this.instance.instanceStates), parms);
                }
                case PROPERTY: {
                    return this.receiver;
                }
                case DEFERRED: {
                    throw new CompileException("unresolved prototype receiver", Proto.this.expr, Proto.this.start);
                }
            }
            return null;
        }

        public Receiver init(ProtoInstance instance, Object ctx, Object thisCtx, VariableResolverFactory factory) {
            return new Receiver(instance, this.type, this.type == ReceiverType.PROPERTY && this.initValue != null ? this.initValue.getValue(ctx, thisCtx, factory) : this.receiver);
        }

        public void setType(ReceiverType type2) {
            this.type = type2;
        }

        public void setInitValue(ExecutableStatement initValue) {
            this.initValue = initValue;
        }
    }
}

