/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.ast;

import org.elasticsearch.common.mvel2.MVEL;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.ast.ASTNode;
import org.elasticsearch.common.mvel2.ast.Assignment;
import org.elasticsearch.common.mvel2.ast.Proto;
import org.elasticsearch.common.mvel2.compiler.ExecutableStatement;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.util.ParseTools;

public class ProtoVarNode
extends ASTNode
implements Assignment {
    private String name;
    private ExecutableStatement statement;

    public ProtoVarNode(char[] expr, int start2, int offset2, int fields2, Proto type2, ParserContext pCtx) {
        super(pCtx);
        this.egressType = Proto.ProtoInstance.class;
        this.expr = expr;
        this.start = start2;
        this.offset = offset2;
        this.fields = fields2;
        this.expr = expr;
        int assignStart = ParseTools.find(expr, start2, offset2, '=');
        if (assignStart != -1) {
            this.name = ParseTools.createStringTrimmed(expr, 0, assignStart);
            ParseTools.checkNameSafety(this.name);
            if (((fields2 |= 0x80) & 0x10) != 0) {
                this.statement = (ExecutableStatement)ParseTools.subCompileExpression(expr, assignStart + 1, offset2, pCtx);
            }
        } else {
            this.name = new String(expr, start2, offset2);
            ParseTools.checkNameSafety(this.name);
        }
        if ((fields2 & 0x10) != 0) {
            pCtx.addVariable(this.name, this.egressType, true);
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.statement == null) {
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.expr, this.start, this.offset);
        }
        ctx = this.statement.getValue(ctx, thisValue, factory);
        factory.createVariable(this.name, ctx, this.egressType);
        return ctx;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ctx = MVEL.eval(this.expr, this.start, this.offset, thisValue, factory);
        factory.createVariable(this.name, ctx, this.egressType);
        return ctx;
    }

    public String getName() {
        return this.name;
    }

    public String getAssignmentVar() {
        return this.name;
    }

    public char[] getExpression() {
        return this.expr;
    }

    public boolean isNewDeclaration() {
        return true;
    }

    public void setValueStatement(ExecutableStatement stmt) {
        this.statement = stmt;
    }
}

