/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.ast;

import org.elasticsearch.common.mvel2.CompileException;
import org.elasticsearch.common.mvel2.DataConversion;
import org.elasticsearch.common.mvel2.MVEL;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.ast.ASTNode;
import org.elasticsearch.common.mvel2.compiler.ExecutableStatement;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.util.ParseTools;
import org.elasticsearch.common.mvel2.util.ReflectionUtil;

public class TypeCast
extends ASTNode {
    private ExecutableStatement statement;
    private boolean widen;

    public TypeCast(char[] expr, int start2, int offset2, Class cast, int fields2, ParserContext pCtx) {
        super(pCtx);
        this.egressType = cast;
        this.expr = expr;
        this.start = start2;
        this.offset = offset2;
        if ((fields2 & 0x10) != 0 && (this.statement = (ExecutableStatement)ParseTools.subCompileExpression(expr, start2, offset2, pCtx)).getKnownEgressType() != Object.class && !DataConversion.canConvert(cast, this.statement.getKnownEgressType())) {
            if (this.canCast(this.statement.getKnownEgressType(), cast)) {
                this.widen = true;
            } else {
                throw new CompileException("unable to cast type: " + this.statement.getKnownEgressType() + "; to: " + cast, expr, start2);
            }
        }
    }

    private boolean canCast(Class from, Class to) {
        return ReflectionUtil.isAssignableFrom(from, to) || from.isInterface() && this.interfaceAssignable(from, to);
    }

    private boolean interfaceAssignable(Class from, Class to) {
        for (Class<?> c : from.getInterfaces()) {
            if (!c.isAssignableFrom(to)) continue;
            return true;
        }
        return false;
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.widen ? TypeCast.typeCheck(this.statement.getValue(ctx, thisValue, factory), this.egressType) : DataConversion.convert(this.statement.getValue(ctx, thisValue, factory), this.egressType);
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.widen ? TypeCast.typeCheck(MVEL.eval(this.expr, this.start, this.offset, ctx, factory), this.egressType) : DataConversion.convert(MVEL.eval(this.expr, this.start, this.offset, ctx, factory), this.egressType);
    }

    private static Object typeCheck(Object inst, Class type2) {
        if (inst == null) {
            return null;
        }
        if (type2.isInstance(inst)) {
            return inst;
        }
        throw new ClassCastException(inst.getClass().getName() + " cannot be cast to: " + type2.getClass().getName());
    }

    public ExecutableStatement getStatement() {
        return this.statement;
    }
}

