/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.ast;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import org.elasticsearch.common.mvel2.CompileException;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.ast.ArraySize;
import org.elasticsearch.common.mvel2.compiler.AbstractParser;
import org.elasticsearch.common.mvel2.compiler.ExecutableStatement;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.util.ArrayTools;
import org.elasticsearch.common.mvel2.util.ParseTools;
import org.elasticsearch.common.mvel2.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDescriptor
implements Serializable {
    private String className;
    private char[] expr;
    private int start;
    private int offset;
    private ArraySize[] arraySize;
    private ExecutableStatement[] compiledArraySize;
    int endRange;

    public TypeDescriptor(char[] name2, int start2, int offset2, int fields2) {
        this.expr = name2;
        this.start = start2;
        this.offset = offset2;
        this.updateClassName(name2, this.start, this.offset, fields2);
    }

    public void updateClassName(char[] name2, int start2, int offset2, int fields2) {
        this.expr = name2;
        if (offset2 == 0 || !ParseTools.isIdentifierPart(name2[start2]) || Character.isDigit(name2[start2])) {
            return;
        }
        this.endRange = ArrayTools.findFirst('(', start2, offset2, name2);
        if (this.endRange == -1) {
            this.endRange = ArrayTools.findFirst('[', start2, offset2, name2);
            if (this.endRange != -1) {
                int i2;
                this.className = new String(name2, start2, this.endRange - start2).trim();
                LinkedList<char[]> sizes = new LinkedList<char[]>();
                int end2 = start2 + offset2;
                while (this.endRange < end2) {
                    while (this.endRange < end2 && ParseTools.isWhitespace(name2[this.endRange])) {
                        ++this.endRange;
                    }
                    if (this.endRange == end2 || name2[this.endRange] == '{') break;
                    if (name2[this.endRange] != '[') {
                        throw new CompileException("unexpected token in constructor", name2, this.endRange);
                    }
                    int to = ParseTools.balancedCapture(name2, this.endRange, start2 + offset2, '[');
                    sizes.add(ParseTools.subset(name2, ++this.endRange, to - this.endRange));
                    this.endRange = to + 1;
                }
                Iterator iter = sizes.iterator();
                this.arraySize = new ArraySize[sizes.size()];
                for (i2 = 0; i2 < this.arraySize.length; ++i2) {
                    this.arraySize[i2] = new ArraySize((char[])iter.next());
                }
                if ((fields2 & 0x10) != 0) {
                    this.compiledArraySize = new ExecutableStatement[this.arraySize.length];
                    for (i2 = 0; i2 < this.compiledArraySize.length; ++i2) {
                        this.compiledArraySize[i2] = (ExecutableStatement)ParseTools.subCompileExpression(this.arraySize[i2].value);
                    }
                }
                return;
            }
            this.className = new String(name2, start2, offset2).trim();
        } else {
            this.className = new String(name2, start2, this.endRange - start2).trim();
        }
    }

    public boolean isArray() {
        return this.arraySize != null;
    }

    public int getArrayLength() {
        return this.arraySize.length;
    }

    public ArraySize[] getArraySize() {
        return this.arraySize;
    }

    public ExecutableStatement[] getCompiledArraySize() {
        return this.compiledArraySize;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean isClass() {
        return this.className != null && this.className.length() != 0;
    }

    public int getEndRange() {
        return this.endRange;
    }

    public void setEndRange(int endRange) {
        this.endRange = endRange;
    }

    public Class<?> getClassReference() throws ClassNotFoundException {
        return TypeDescriptor.getClassReference(null, this);
    }

    public Class<?> getClassReference(ParserContext ctx) throws ClassNotFoundException {
        return TypeDescriptor.getClassReference(ctx, this);
    }

    public static Class getClassReference(Class baseType, TypeDescriptor tDescr, VariableResolverFactory factory, ParserContext ctx) throws ClassNotFoundException {
        return ParseTools.findClass(factory, ParseTools.repeatChar('[', tDescr.arraySize.length) + "L" + baseType.getName() + ";", ctx);
    }

    public static Class getClassReference(ParserContext ctx, Class cls, TypeDescriptor tDescr) throws ClassNotFoundException {
        if (tDescr.isArray()) {
            cls = cls.isPrimitive() ? ReflectionUtil.toPrimitiveArrayType(cls) : ParseTools.findClass(null, ParseTools.repeatChar('[', tDescr.arraySize.length) + "L" + cls.getName() + ";", ctx);
        }
        return cls;
    }

    public static Class getClassReference(ParserContext ctx, TypeDescriptor tDescr) throws ClassNotFoundException {
        Class cls;
        if (ctx != null && ctx.hasImport(tDescr.className)) {
            cls = ctx.getImport(tDescr.className);
            if (tDescr.isArray()) {
                cls = cls.isPrimitive() ? ReflectionUtil.toPrimitiveArrayType(cls) : ParseTools.findClass(null, ParseTools.repeatChar('[', tDescr.arraySize.length) + "L" + cls.getName() + ";", ctx);
            }
        } else if (ctx == null && TypeDescriptor.hasContextFreeImport(tDescr.className)) {
            cls = TypeDescriptor.getContextFreeImport(tDescr.className);
            if (tDescr.isArray()) {
                cls = cls.isPrimitive() ? ReflectionUtil.toPrimitiveArrayType(cls) : ParseTools.findClass(null, ParseTools.repeatChar('[', tDescr.arraySize.length) + "L" + cls.getName() + ";", ctx);
            }
        } else {
            cls = ParseTools.createClass(tDescr.getClassName(), ctx);
            if (tDescr.isArray()) {
                cls = cls.isPrimitive() ? ReflectionUtil.toPrimitiveArrayType(cls) : ParseTools.findClass(null, ParseTools.repeatChar('[', tDescr.arraySize.length) + "L" + cls.getName() + ";", ctx);
            }
        }
        return cls;
    }

    public boolean isUndimensionedArray() {
        if (this.arraySize != null) {
            for (ArraySize anArraySize : this.arraySize) {
                if (anArraySize.value.length != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasContextFreeImport(String name2) {
        return AbstractParser.LITERALS.containsKey(name2) && AbstractParser.LITERALS.get(name2) instanceof Class;
    }

    public static Class getContextFreeImport(String name2) {
        return (Class)AbstractParser.LITERALS.get(name2);
    }

    public char[] getExpr() {
        return this.expr;
    }

    public int getStart() {
        return this.start;
    }

    public int getOffset() {
        return this.offset;
    }
}

