/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.conversion;

import java.lang.reflect.Array;
import java.util.Collection;
import org.elasticsearch.common.mvel2.ConversionHandler;
import org.elasticsearch.common.mvel2.DataConversion;

public class ArrayHandler
implements ConversionHandler {
    private final Class type;

    public ArrayHandler(Class type2) {
        this.type = type2;
    }

    public Object convertFrom(Object in) {
        return ArrayHandler.handleLooseTypeConversion(in.getClass(), in, this.type);
    }

    public boolean canConvertFrom(Class cls) {
        return cls.isArray() || Collection.class.isAssignableFrom(cls);
    }

    private static Object handleLooseTypeConversion(Class sourceType, Object input, Class targetType) {
        Class<?> targType = targetType.getComponentType();
        if (Collection.class.isAssignableFrom(sourceType)) {
            Object newArray = Array.newInstance(targType, ((Collection)input).size());
            int i2 = 0;
            for (Object o : (Collection)input) {
                Array.set(newArray, i2++, DataConversion.convert(o, targType));
            }
            return newArray;
        }
        if (!input.getClass().isArray()) {
            Object target = Array.newInstance(targType, 1);
            Array.set(target, 0, input);
            return target;
        }
        int len = Array.getLength(input);
        Object target = Array.newInstance(targType, len);
        for (int i3 = 0; i3 < len; ++i3) {
            Array.set(target, i3, DataConversion.convert(Array.get(input, i3), targType));
        }
        return target;
    }
}

