/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.conversion;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.elasticsearch.common.mvel2.ConversionHandler;

public class SetCH
implements ConversionHandler {
    public Object convertFrom(Object in) {
        Class<?> type2 = in.getClass();
        LinkedHashSet<Object> newSet = new LinkedHashSet<Object>();
        if (type2.isArray()) {
            newSet.addAll(Arrays.asList((Object[])in));
        } else if (Collection.class.isAssignableFrom(type2)) {
            newSet.addAll((Collection)in);
        } else if (Iterable.class.isAssignableFrom(type2)) {
            for (Object o : (Iterable)in) {
                newSet.add(o);
            }
        }
        return newSet;
    }

    public boolean canConvertFrom(Class cls) {
        return cls.isArray() || Collection.class.isAssignableFrom(cls) || Iterable.class.isAssignableFrom(cls);
    }
}

