/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.conversion;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.mvel2.ConversionHandler;
import org.elasticsearch.common.mvel2.conversion.Converter;

public class StringArrayCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>();

    public Object convertFrom(Object in) {
        if (in.getClass().isArray()) {
            Object[] old = (Object[])in;
            String[] n = new String[old.length];
            for (int i2 = 0; i2 < old.length; ++i2) {
                n[i2] = String.valueOf(old[i2]);
            }
            return n;
        }
        return new String[]{String.valueOf(in)};
    }

    public boolean canConvertFrom(Class cls) {
        return CNV.containsKey(cls);
    }

    static {
        CNV.put(Object[].class, new Converter(){

            public Object convert(Object o) {
                Object[] old = (Object[])o;
                String[] n = new String[old.length];
                for (int i2 = 0; i2 < old.length; ++i2) {
                    n[i2] = String.valueOf(old[i2]);
                }
                return n;
            }
        });
    }
}

