/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.integration.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.mvel2.UnresolveablePropertyException;
import org.elasticsearch.common.mvel2.integration.VariableResolver;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.integration.impl.BaseVariableResolverFactory;
import org.elasticsearch.common.mvel2.integration.impl.SimpleSTValueResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingMapVariableResolverFactory
extends BaseVariableResolverFactory {
    protected Map<String, Object> variables;

    public CachingMapVariableResolverFactory(Map variables) {
        this.variables = variables;
    }

    public CachingMapVariableResolverFactory(Map<String, Object> variables, VariableResolverFactory nextFactory) {
        this.variables = variables;
        this.nextFactory = nextFactory;
    }

    public CachingMapVariableResolverFactory(Map<String, Object> variables, boolean cachingSafe) {
        this.variables = variables;
    }

    @Override
    public VariableResolver createVariable(String name2, Object value2) {
        try {
            VariableResolver vr = this.getVariableResolver(name2);
            vr.setValue(value2);
            return vr;
        }
        catch (UnresolveablePropertyException e) {
            SimpleSTValueResolver vr = new SimpleSTValueResolver(value2, null, true);
            this.addResolver(name2, vr);
            return vr;
        }
    }

    @Override
    public VariableResolver createVariable(String name2, Object value2, Class<?> type2) {
        VariableResolver vr;
        try {
            vr = this.getVariableResolver(name2);
        }
        catch (UnresolveablePropertyException e) {
            vr = null;
        }
        if (vr != null && vr.getType() != null) {
            throw new RuntimeException("variable already defined within scope: " + vr.getType() + " " + name2);
        }
        vr = new SimpleSTValueResolver(value2, type2, true);
        this.addResolver(name2, vr);
        return vr;
    }

    @Override
    public VariableResolver getVariableResolver(String name2) {
        VariableResolver vr = (VariableResolver)this.variableResolvers.get(name2);
        if (vr != null) {
            return vr;
        }
        if (this.variables.containsKey(name2)) {
            vr = new SimpleSTValueResolver(this.variables.get(name2), null);
            this.variableResolvers.put(name2, vr);
            return vr;
        }
        if (this.nextFactory != null) {
            return this.nextFactory.getVariableResolver(name2);
        }
        throw new UnresolveablePropertyException("unable to resolve variable '" + name2 + "'");
    }

    @Override
    public boolean isResolveable(String name2) {
        return this.variableResolvers.containsKey(name2) || this.variables != null && this.variables.containsKey(name2) || this.nextFactory != null && this.nextFactory.isResolveable(name2);
    }

    protected VariableResolver addResolver(String name2, VariableResolver vr) {
        this.variableResolvers.put(name2, vr);
        return vr;
    }

    public void externalize() {
        for (Map.Entry entry : this.variableResolvers.entrySet()) {
            if (((VariableResolver)entry.getValue()).getFlags() != -1) continue;
            this.variables.put((String)entry.getKey(), ((VariableResolver)entry.getValue()).getValue());
        }
    }

    @Override
    public boolean isTarget(String name2) {
        return this.variableResolvers.containsKey(name2);
    }

    @Override
    public Set<String> getKnownVariables() {
        if (this.nextFactory == null) {
            if (this.variables != null) {
                return new HashSet<String>(this.variables.keySet());
            }
            return new HashSet<String>(0);
        }
        if (this.variables != null) {
            return new HashSet<String>(this.variables.keySet());
        }
        return new HashSet<String>(0);
    }

    public void clear() {
        this.variableResolvers.clear();
        this.variables.clear();
    }
}

