/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.integration.impl;

import java.util.Map;
import org.elasticsearch.common.mvel2.DataConversion;
import org.elasticsearch.common.mvel2.integration.VariableResolver;

public class PrecachedMapVariableResolver
implements VariableResolver {
    private String name;
    private Class<?> knownType;
    private Map.Entry entry;

    public PrecachedMapVariableResolver(Map.Entry entry, String name2) {
        this.entry = entry;
        this.name = name2;
    }

    public PrecachedMapVariableResolver(Map.Entry entry, String name2, Class knownType) {
        this.name = name2;
        this.knownType = knownType;
        this.entry = entry;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public void setStaticType(Class knownType) {
        this.knownType = knownType;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.knownType;
    }

    public void setValue(Object value2) {
        if (this.knownType != null && value2 != null && value2.getClass() != this.knownType) {
            Class<?> t = value2.getClass();
            if (!DataConversion.canConvert(this.knownType, t)) {
                throw new RuntimeException("cannot assign " + value2.getClass().getName() + " to type: " + this.knownType.getName());
            }
            try {
                value2 = DataConversion.convert(value2, this.knownType);
            }
            catch (Exception e) {
                throw new RuntimeException("cannot convert value of " + value2.getClass().getName() + " to: " + this.knownType.getName());
            }
        }
        this.entry.setValue(value2);
    }

    public Object getValue() {
        return this.entry.getValue();
    }

    public int getFlags() {
        return 0;
    }
}

