/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.optimizers;

import java.lang.reflect.Method;
import org.elasticsearch.common.mvel2.CompileException;
import org.elasticsearch.common.mvel2.MVEL;
import org.elasticsearch.common.mvel2.compiler.AbstractParser;
import org.elasticsearch.common.mvel2.util.ParseTools;

public class AbstractOptimizer
extends AbstractParser {
    protected static final int BEAN = 0;
    protected static final int METH = 1;
    protected static final int COL = 2;
    protected static final int WITH = 3;
    protected boolean collection = false;
    protected boolean nullSafe = false;
    protected Class currType = null;
    protected boolean staticAccess = false;
    protected int tkStart;

    protected Object tryStaticAccess() {
        int begin2 = this.cursor;
        try {
            boolean meth = false;
            int last2 = this.end;
            block23: for (int i2 = this.end - 1; i2 > this.start; --i2) {
                switch (this.expr[i2]) {
                    case '.': {
                        if (!meth) {
                            ClassLoader classLoader = this.pCtx != null ? this.pCtx.getClassLoader() : Thread.currentThread().getContextClassLoader();
                            try {
                                this.cursor = last2;
                                String test2 = new String(this.expr, this.start, this.cursor - this.start);
                                if (MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS && test2.endsWith(".class")) {
                                    test2 = test2.substring(0, test2.length() - 6);
                                }
                                return Class.forName(test2, true, classLoader);
                            }
                            catch (ClassNotFoundException e) {
                                Class cls = this.forNameWithInner(new String(this.expr, this.start, i2 - this.start), classLoader);
                                String name2 = new String(this.expr, i2 + 1, this.end - i2 - 1);
                                try {
                                    return cls.getField(name2);
                                }
                                catch (NoSuchFieldException nfe) {
                                    for (Method m : cls.getMethods()) {
                                        if (!name2.equals(m.getName())) continue;
                                        return m;
                                    }
                                    return null;
                                }
                            }
                        }
                        meth = false;
                        last2 = i2;
                        continue block23;
                    }
                    case '}': {
                        char s2;
                        --i2;
                        int d = 1;
                        while (i2 > this.start && d != 0) {
                            switch (this.expr[i2]) {
                                case '}': {
                                    ++d;
                                    break;
                                }
                                case '{': {
                                    --d;
                                    break;
                                }
                                case '\"': 
                                case '\'': {
                                    s2 = this.expr[i2];
                                    while (i2 > this.start && this.expr[i2] != s2 && this.expr[i2 - 1] != '\\') {
                                        --i2;
                                    }
                                    break;
                                }
                            }
                            --i2;
                        }
                        continue block23;
                    }
                    case ')': {
                        char s2;
                        --i2;
                        int d = 1;
                        while (i2 > this.start && d != 0) {
                            switch (this.expr[i2]) {
                                case ')': {
                                    ++d;
                                    break;
                                }
                                case '(': {
                                    --d;
                                    break;
                                }
                                case '\"': 
                                case '\'': {
                                    s2 = this.expr[i2];
                                    while (i2 > this.start && this.expr[i2] != s2 && this.expr[i2 - 1] != '\\') {
                                        --i2;
                                    }
                                    break;
                                }
                            }
                            --i2;
                        }
                        meth = true;
                        last2 = i2++;
                        continue block23;
                    }
                    case '\'': {
                        while (--i2 > this.start && (this.expr[i2] != '\'' || this.expr[i2 - 1] == '\\')) {
                        }
                        continue block23;
                    }
                    case '\"': {
                        while (--i2 > this.start && (this.expr[i2] != '\"' || this.expr[i2 - 1] == '\\')) {
                        }
                        continue block23;
                    }
                }
            }
        }
        catch (Exception cnfe) {
            this.cursor = begin2;
        }
        return null;
    }

    private Class forNameWithInner(String className, ClassLoader classLoader) throws ClassNotFoundException {
        ClassNotFoundException cnfe = null;
        try {
            return Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            cnfe = e;
            int lastDotPos = className.lastIndexOf(46);
            while (lastDotPos > 0) {
                className = className.substring(0, lastDotPos) + "$" + className.substring(lastDotPos + 1);
                try {
                    return Class.forName(className, true, classLoader);
                }
                catch (ClassNotFoundException e2) {
                    lastDotPos = className.lastIndexOf(46);
                }
            }
            throw cnfe;
        }
    }

    protected int nextSubToken() {
        this.skipWhitespace();
        this.nullSafe = false;
        this.tkStart = this.cursor;
        block0 : switch (this.expr[this.tkStart]) {
            case '[': {
                return 2;
            }
            case '{': {
                if (this.expr[this.cursor - 1] != '.') break;
                return 3;
            }
            case '.': {
                if (this.start + 1 != this.end) {
                    this.cursor = ++this.tkStart;
                    switch (this.expr[this.tkStart]) {
                        case '?': {
                            this.skipWhitespace();
                            this.cursor = ++this.tkStart;
                            if (this.tkStart == this.end) {
                                throw new CompileException("unexpected end of statement", this.expr, this.start);
                            }
                            this.nullSafe = true;
                            this.fields = -1;
                            break block0;
                        }
                        case '{': {
                            return 3;
                        }
                    }
                    if (!ParseTools.isWhitespace(this.expr[this.tkStart])) break;
                    this.skipWhitespace();
                    this.tkStart = this.cursor;
                    break;
                }
                throw new CompileException("unexpected end of statement", this.expr, this.start);
            }
            case '?': {
                if (this.start != this.cursor) break;
                ++this.tkStart;
                ++this.cursor;
                this.nullSafe = true;
            }
        }
        while (++this.cursor < this.end && ParseTools.isIdentifierPart(this.expr[this.cursor])) {
        }
        this.skipWhitespace();
        if (this.cursor < this.end) {
            switch (this.expr[this.cursor]) {
                case '[': {
                    return 2;
                }
                case '(': {
                    return 1;
                }
            }
            return 0;
        }
        return 0;
    }

    protected String capture() {
        this.tkStart = this.trimRight(this.tkStart);
        return new String(this.expr, this.tkStart, this.trimLeft(this.cursor) - this.tkStart);
    }

    protected void whiteSpaceSkip() {
        if (this.cursor < this.length) {
            while (ParseTools.isWhitespace(this.expr[this.cursor]) && ++this.cursor != this.length) {
            }
        }
    }

    protected boolean scanTo(char c) {
        while (this.cursor < this.end) {
            switch (this.expr[this.cursor]) {
                case '\"': 
                case '\'': {
                    this.cursor = ParseTools.captureStringLiteral(this.expr[this.cursor], this.expr, this.cursor, this.end);
                }
            }
            if (this.expr[this.cursor] == c) {
                return false;
            }
            ++this.cursor;
        }
        return true;
    }

    protected int findLastUnion() {
        int split2 = -1;
        int depth = 0;
        int end2 = this.start + this.length;
        for (int i2 = end2 - 1; i2 != this.start; --i2) {
            switch (this.expr[i2]) {
                case ']': 
                case '}': {
                    ++depth;
                    break;
                }
                case '[': 
                case '{': {
                    if (--depth != 0) break;
                    split2 = i2;
                    this.collection = true;
                    break;
                }
                case '.': {
                    if (depth != 0) break;
                    split2 = i2;
                }
            }
            if (split2 != -1) break;
        }
        return split2;
    }
}

