/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.optimizers.impl.refl.nodes;

import java.lang.reflect.Array;
import org.elasticsearch.common.mvel2.compiler.AccessorNode;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;

public class ArrayAccessor
implements AccessorNode {
    private AccessorNode nextNode;
    private int index;

    public ArrayAccessor() {
    }

    public ArrayAccessor(int index2) {
        this.index = index2;
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        if (this.nextNode != null) {
            return this.nextNode.getValue(Array.get(ctx, this.index), elCtx, vars);
        }
        return Array.get(ctx, this.index);
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value2) {
        if (this.nextNode != null) {
            return this.nextNode.setValue(Array.get(ctx, this.index), elCtx, variableFactory, value2);
        }
        Array.set(ctx, this.index, value2);
        return value2;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index2) {
        this.index = index2;
    }

    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }

    public Class getKnownEgressType() {
        return Object[].class;
    }

    public String toString() {
        return "Array Accessor -> [" + this.index + "]";
    }
}

