/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.optimizers.impl.refl.nodes;

import java.util.List;
import org.elasticsearch.common.mvel2.DataConversion;
import org.elasticsearch.common.mvel2.compiler.AccessorNode;
import org.elasticsearch.common.mvel2.compiler.ExecutableStatement;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.util.ParseTools;

public class ListAccessorNest
implements AccessorNode {
    private AccessorNode nextNode;
    private ExecutableStatement index;
    private Class conversionType;

    public ListAccessorNest() {
    }

    public ListAccessorNest(String index2, Class conversionType) {
        this.index = (ExecutableStatement)ParseTools.subCompileExpression(index2.toCharArray());
        this.conversionType = conversionType;
    }

    public ListAccessorNest(ExecutableStatement index2, Class conversionType) {
        this.index = index2;
        this.conversionType = conversionType;
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        if (this.nextNode != null) {
            return this.nextNode.getValue(((List)ctx).get((Integer)this.index.getValue(ctx, elCtx, vars)), elCtx, vars);
        }
        return ((List)ctx).get((Integer)this.index.getValue(ctx, elCtx, vars));
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory vars, Object value2) {
        if (this.nextNode != null) {
            return this.nextNode.setValue(((List)ctx).get((Integer)this.index.getValue(ctx, elCtx, vars)), elCtx, vars, value2);
        }
        if (this.conversionType != null) {
            value2 = DataConversion.convert(value2, this.conversionType);
            ((List)ctx).set((Integer)this.index.getValue(ctx, elCtx, vars), value2);
        } else {
            ((List)ctx).set((Integer)this.index.getValue(ctx, elCtx, vars), value2);
        }
        return value2;
    }

    public ExecutableStatement getIndex() {
        return this.index;
    }

    public void setIndex(ExecutableStatement index2) {
        this.index = index2;
    }

    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }

    public String toString() {
        return "Array Accessor -> [" + this.index + "]";
    }

    public Class getKnownEgressType() {
        return Object.class;
    }
}

