/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.elasticsearch.common.mvel2.ImmutableElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastList<E>
extends AbstractList<E>
implements Externalizable {
    private E[] elements;
    private int size = 0;
    private boolean updated = false;

    public FastList(int size2) {
        this.elements = new Object[size2 == 0 ? 1 : size2];
    }

    public FastList(E[] elements) {
        this.elements = elements;
        this.size = elements.length;
    }

    public FastList() {
        this(10);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        for (int i2 = 0; i2 < this.size; ++i2) {
            out.writeObject(this.elements[i2]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        this.elements = new Object[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.elements[i2] = in.readObject();
        }
    }

    @Override
    public E get(int index2) {
        return this.elements[index2];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(E o) {
        if (this.size == this.elements.length) {
            this.increaseSize(this.elements.length * 2);
        }
        this.elements[this.size++] = o;
        return true;
    }

    @Override
    public E set(int i2, E o) {
        if (!this.updated) {
            this.copyArray();
        }
        E old = this.elements[i2];
        this.elements[i2] = o;
        return old;
    }

    @Override
    public void add(int i2, E o) {
        if (this.size == this.elements.length) {
            this.increaseSize(this.elements.length * 2);
        }
        for (int c = this.size; c != i2; --c) {
            this.elements[c] = this.elements[c - 1];
        }
        this.elements[i2] = o;
        ++this.size;
    }

    @Override
    public E remove(int i2) {
        E old = this.elements[i2];
        for (int c = i2 + 1; c < this.size; ++c) {
            this.elements[c - 1] = this.elements[c];
            this.elements[c] = null;
        }
        --this.size;
        return old;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.elements.length; ++i2) {
            if (!o.equals(this.elements[i2])) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            return -1;
        }
        for (int i2 = this.elements.length - 1; i2 != -1; --i2) {
            if (!o.equals(this.elements[i2])) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public void clear() {
        this.elements = new Object[1];
        this.size = 0;
    }

    @Override
    public boolean addAll(int i2, Collection<? extends E> collection) {
        int c;
        int offset2 = collection.size();
        this.ensureCapacity(offset2 + this.size);
        if (i2 != 0) {
            for (c = i2; c != i2 + offset2; ++c) {
                this.elements[c + offset2 + 1] = this.elements[c];
            }
        }
        c = this.size == 0 ? -1 : 0;
        for (E o : collection) {
            this.elements[offset2 + c++] = o;
        }
        this.size += offset2;
        return true;
    }

    @Override
    public Iterator iterator() {
        final int size2 = this.size;
        return new Iterator(){
            private int cursor = 0;

            public boolean hasNext() {
                return this.cursor < size2;
            }

            public Object next() {
                return FastList.this.elements[this.cursor++];
            }

            public void remove() {
                throw new ImmutableElementException("cannot change elements in immutable list");
            }
        };
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListIterator<E>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < FastList.this.size;
            }

            @Override
            public E next() {
                return FastList.this.elements[this.i++];
            }

            @Override
            public boolean hasPrevious() {
                return this.i > 0;
            }

            @Override
            public E previous() {
                return FastList.this.elements[this.i--];
            }

            @Override
            public int nextIndex() {
                return this.i++;
            }

            @Override
            public int previousIndex() {
                return this.i--;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(E o) {
                ((FastList)FastList.this).elements[this.i] = o;
            }

            @Override
            public void add(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public ListIterator listIterator(int i2) {
        return super.listIterator(i2);
    }

    @Override
    public List subList(int i2, int i1) {
        return super.subList(i2, i1);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        ListIterator<E> e1 = this.listIterator();
        ListIterator e2 = ((List)o).listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            E o1 = e1.next();
            Object o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected void removeRange(int i2, int i1) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size]);
    }

    @Override
    public Object[] toArray(Object[] objects) {
        if (objects.length < this.size) {
            objects = new Object[this.size];
        }
        for (int i2 = 0; i2 < this.size; ++i2) {
            objects[i2] = this.elements[i2];
        }
        return objects;
    }

    @Override
    public boolean remove(Object o) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public boolean containsAll(Collection collection) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public boolean addAll(Collection collection) {
        return this.addAll(this.size, collection);
    }

    @Override
    public boolean removeAll(Collection collection) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public boolean retainAll(Collection collection) {
        throw new RuntimeException("not implemented");
    }

    private void ensureCapacity(int additional) {
        if (this.size + additional > this.elements.length) {
            this.increaseSize((this.size + additional) * 2);
        }
    }

    private void copyArray() {
        this.increaseSize(this.elements.length);
    }

    private void increaseSize(int newSize) {
        Object[] newElements = new Object[newSize];
        for (int i2 = 0; i2 < this.elements.length; ++i2) {
            newElements[i2] = this.elements[i2];
        }
        this.elements = newElements;
        this.updated = true;
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

