/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.elasticsearch.common.mvel2.CompileException;
import org.elasticsearch.common.mvel2.DataConversion;
import org.elasticsearch.common.mvel2.MVEL;
import org.elasticsearch.common.mvel2.OptimizationFailure;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.ast.ASTNode;
import org.elasticsearch.common.mvel2.compiler.AbstractParser;
import org.elasticsearch.common.mvel2.compiler.BlankLiteral;
import org.elasticsearch.common.mvel2.compiler.CompiledExpression;
import org.elasticsearch.common.mvel2.compiler.ExecutableAccessor;
import org.elasticsearch.common.mvel2.compiler.ExecutableAccessorSafe;
import org.elasticsearch.common.mvel2.compiler.ExecutableLiteral;
import org.elasticsearch.common.mvel2.compiler.ExpressionCompiler;
import org.elasticsearch.common.mvel2.integration.ResolverTools;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.integration.impl.ClassImportResolverFactory;
import org.elasticsearch.common.mvel2.math.MathProcessor;
import org.elasticsearch.common.mvel2.util.NullType;
import org.elasticsearch.common.mvel2.util.StringAppender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseTools {
    public static final String[] EMPTY_STR_ARR = new String[0];
    public static final Object[] EMPTY_OBJ_ARR = new Object[0];
    public static final Class[] EMPTY_CLS_ARR = new Class[0];
    private static Map<String, Map<Integer, WeakReference<Method>>> RESOLVED_METH_CACHE;
    private static Map<Class, Map<Integer, WeakReference<Constructor>>> RESOLVED_CONST_CACHE;
    private static Map<Constructor, WeakReference<Class[]>> CONSTRUCTOR_PARMS_CACHE;
    private static Map<ClassLoader, Map<String, WeakReference<Class>>> CLASS_RESOLVER_CACHE;
    private static Map<Class, WeakReference<Constructor[]>> CLASS_CONSTRUCTOR_CACHE;
    private static final HashMap<Class, Integer> typeResolveMap;
    private static final Map<Class, Integer> typeCodes;

    public static List<char[]> parseMethodOrConstructor(char[] parm) {
        int start2 = -1;
        for (int i2 = 0; i2 < parm.length; ++i2) {
            if (parm[i2] != '(') continue;
            start2 = ++i2;
            break;
        }
        if (start2 != -1) {
            return ParseTools.parseParameterList(parm, --start2 + 1, ParseTools.balancedCapture(parm, start2, '(') - start2 - 1);
        }
        return Collections.emptyList();
    }

    public static String[] parseParameterDefList(char[] parm, int offset2, int length2) {
        String s2;
        int i2;
        LinkedList<String> list2 = new LinkedList<String>();
        if (length2 == -1) {
            length2 = parm.length;
        }
        int start2 = offset2;
        int end2 = i2 + length2;
        block6: for (i2 = offset2; i2 < end2; ++i2) {
            switch (parm[i2]) {
                case '(': 
                case '[': 
                case '{': {
                    i2 = ParseTools.balancedCapture(parm, i2, parm[i2]);
                    continue block6;
                }
                case '\'': {
                    i2 = ParseTools.captureStringLiteral('\'', parm, i2, parm.length);
                    continue block6;
                }
                case '\"': {
                    i2 = ParseTools.captureStringLiteral('\"', parm, i2, parm.length);
                    continue block6;
                }
                case ',': {
                    if (i2 > start2) {
                        while (ParseTools.isWhitespace(parm[start2])) {
                            ++start2;
                        }
                        s2 = new String(parm, start2, i2 - start2);
                        ParseTools.checkNameSafety(s2);
                        list2.add(s2);
                    }
                    while (ParseTools.isWhitespace(parm[i2])) {
                        ++i2;
                    }
                    start2 = i2 + 1;
                    continue block6;
                }
                default: {
                    if (ParseTools.isWhitespace(parm[i2]) || ParseTools.isIdentifierPart(parm[i2])) continue block6;
                    throw new CompileException("expected parameter", parm, start2);
                }
            }
        }
        if (start2 < length2 + offset2 && i2 > start2) {
            s2 = ParseTools.createStringTrimmed(parm, start2, i2 - start2);
            if (s2.length() > 0) {
                ParseTools.checkNameSafety(s2);
                list2.add(s2);
            }
        } else if (list2.size() == 0 && (s2 = ParseTools.createStringTrimmed(parm, start2, length2)).length() > 0) {
            ParseTools.checkNameSafety(s2);
            list2.add(s2);
        }
        return list2.toArray(new String[list2.size()]);
    }

    public static List<char[]> parseParameterList(char[] parm, int offset2, int length2) {
        char[] s2;
        int i2;
        ArrayList<char[]> list2 = new ArrayList<char[]>();
        if (length2 == -1) {
            length2 = parm.length;
        }
        int start2 = offset2;
        int end2 = i2 + length2;
        block6: for (i2 = offset2; i2 < end2; ++i2) {
            switch (parm[i2]) {
                case '(': 
                case '[': 
                case '{': {
                    i2 = ParseTools.balancedCapture(parm, i2, parm[i2]);
                    continue block6;
                }
                case '\'': {
                    i2 = ParseTools.captureStringLiteral('\'', parm, i2, parm.length);
                    continue block6;
                }
                case '\"': {
                    i2 = ParseTools.captureStringLiteral('\"', parm, i2, parm.length);
                    continue block6;
                }
                case ',': {
                    if (i2 > start2) {
                        while (ParseTools.isWhitespace(parm[start2])) {
                            ++start2;
                        }
                        list2.add(ParseTools.subsetTrimmed(parm, start2, i2 - start2));
                    }
                    while (ParseTools.isWhitespace(parm[i2])) {
                        ++i2;
                    }
                    start2 = i2 + 1;
                }
            }
        }
        if (start2 < length2 + offset2 && i2 > start2) {
            char[] s3 = ParseTools.subsetTrimmed(parm, start2, i2 - start2);
            if (s3.length > 0) {
                list2.add(s3);
            }
        } else if (list2.size() == 0 && (s2 = ParseTools.subsetTrimmed(parm, start2, length2)).length > 0) {
            list2.add(s2);
        }
        return list2;
    }

    public static Method getBestCandidate(Object[] arguments, String method2, Class decl, Method[] methods2, boolean requireExact) {
        Class[] targetParms = new Class[arguments.length];
        for (int i2 = 0; i2 != arguments.length; ++i2) {
            targetParms[i2] = arguments[i2] != null ? arguments[i2].getClass() : null;
        }
        return ParseTools.getBestCandidate(targetParms, method2, decl, methods2, requireExact);
    }

    public static Method getBestCandidate(Class[] arguments, String method2, Class decl, Method[] methods2, boolean requireExact) {
        return ParseTools.getBestCandidate(arguments, method2, decl, methods2, requireExact, false);
    }

    public static Method getBestCandidate(Class[] arguments, String method2, Class decl, Method[] methods2, boolean requireExact, boolean classTarget) {
        WeakReference<Method> ref;
        if (methods2.length == 0) {
            return null;
        }
        Method bestCandidate = null;
        int bestScore = 0;
        boolean retry = false;
        Integer hash2 = ParseTools.createClassSignatureHash(decl, arguments);
        Map<Integer, WeakReference<Method>> methCache = RESOLVED_METH_CACHE.get(method2);
        if (methCache != null && (ref = methCache.get(hash2)) != null && (bestCandidate = (Method)ref.get()) != null) {
            return bestCandidate;
        }
        while (true) {
            int i2;
            for (Method meth : methods2) {
                if (classTarget && (meth.getModifiers() & 8) == 0 || !method2.equals(meth.getName())) continue;
                boolean isVarArgs = meth.isVarArgs();
                Class[] parmTypes = meth.getParameterTypes();
                if (parmTypes.length != arguments.length && !isVarArgs) continue;
                if (arguments.length == 0 && parmTypes.length == 0) {
                    if (bestCandidate != null && !bestCandidate.getReturnType().isAssignableFrom(meth.getReturnType())) continue;
                    bestCandidate = meth;
                    continue;
                }
                int score = ParseTools.getMethodScore(arguments, requireExact, parmTypes, isVarArgs);
                if (score == 0) continue;
                if (score > bestScore) {
                    bestCandidate = meth;
                    bestScore = score;
                    continue;
                }
                if (score != bestScore || bestCandidate != null && (bestCandidate.getReturnType() == meth.getReturnType() || !bestCandidate.getReturnType().isAssignableFrom(meth.getReturnType()))) continue;
                bestCandidate = meth;
            }
            if (bestCandidate != null) {
                if (methCache == null) {
                    methCache = new WeakHashMap<Integer, WeakReference<Method>>();
                    RESOLVED_METH_CACHE.put(method2, methCache);
                }
                methCache.put(hash2, new WeakReference<Method>(bestCandidate));
                break;
            }
            if (retry || !decl.isInterface()) break;
            Method[] objMethods = Object.class.getMethods();
            Method[] nMethods = new Method[methods2.length + objMethods.length];
            for (i2 = 0; i2 < methods2.length; ++i2) {
                nMethods[i2] = methods2[i2];
            }
            for (i2 = 0; i2 < objMethods.length; ++i2) {
                nMethods[i2 + methods2.length] = objMethods[i2];
            }
            methods2 = nMethods;
            retry = true;
        }
        return bestCandidate;
    }

    private static int getMethodScore(Class[] arguments, boolean requireExact, Class[] parmTypes, boolean varArgs) {
        int score = 0;
        for (int i2 = 0; i2 != arguments.length; ++i2) {
            Class<?> actualParamType = varArgs && i2 >= parmTypes.length - 1 ? parmTypes[parmTypes.length - 1].getComponentType() : parmTypes[i2];
            if (arguments[i2] == null) {
                if (!actualParamType.isPrimitive()) {
                    score += 6;
                    continue;
                }
                score = 0;
                break;
            }
            if (actualParamType == arguments[i2]) {
                score += 7;
                continue;
            }
            if (actualParamType.isPrimitive() && ParseTools.boxPrimitive(actualParamType) == arguments[i2]) {
                score += 6;
                continue;
            }
            if (arguments[i2].isPrimitive() && ParseTools.unboxPrimitive(arguments[i2]) == actualParamType) {
                score += 6;
                continue;
            }
            if (actualParamType.isAssignableFrom(arguments[i2])) {
                score += 5;
                continue;
            }
            if (ParseTools.isNumericallyCoercible(arguments[i2], actualParamType)) {
                score += 4;
                continue;
            }
            if (ParseTools.boxPrimitive(actualParamType).isAssignableFrom(ParseTools.boxPrimitive(arguments[i2])) && Object.class != arguments[i2]) {
                score += 3 + ParseTools.scoreInterface(actualParamType, arguments[i2]);
                continue;
            }
            if (!requireExact && DataConversion.canConvert(actualParamType, arguments[i2])) {
                if (actualParamType.isArray() && arguments[i2].isArray()) {
                    ++score;
                } else if (actualParamType == Character.TYPE && arguments[i2] == String.class) {
                    ++score;
                }
                ++score;
                continue;
            }
            if (actualParamType == Object.class || arguments[i2] == NullType.class) {
                ++score;
                continue;
            }
            score = 0;
            break;
        }
        return score;
    }

    public static int scoreInterface(Class parm, Class arg2) {
        Class<?>[] iface;
        if (parm.isInterface() && (iface = arg2.getInterfaces()) != null) {
            for (Class<?> c : iface) {
                if (c == parm) {
                    return 1;
                }
                if (!parm.isAssignableFrom(c)) continue;
                return ParseTools.scoreInterface(parm, arg2.getSuperclass());
            }
        }
        return 0;
    }

    public static Method getExactMatch(String name2, Class[] args2, Class returnType, Class cls) {
        for (Method meth : cls.getMethods()) {
            Class<?>[] parameterTypes;
            if (!name2.equals(meth.getName()) || returnType != meth.getReturnType() || (parameterTypes = meth.getParameterTypes()).length != args2.length) continue;
            for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
                if (parameterTypes[i2] == args2[i2]) continue;
                return null;
            }
            return meth;
        }
        return null;
    }

    public static Method getWidenedTarget(Method method2) {
        return ParseTools.getWidenedTarget(method2.getDeclaringClass(), method2);
    }

    public static Method getWidenedTarget(Class cls, Method method2) {
        Class currentCls;
        Method m = method2;
        Method best = method2;
        Class[] args2 = method2.getParameterTypes();
        String name2 = method2.getName();
        Class<?> rt = m.getReturnType();
        for (currentCls = cls; currentCls != null; currentCls = currentCls.getSuperclass()) {
            for (Class<?> iface : currentCls.getInterfaces()) {
                m = ParseTools.getExactMatch(name2, args2, rt, iface);
                if (m == null) continue;
                best = m;
            }
        }
        if (best != method2) {
            return best;
        }
        currentCls = cls;
        for (currentCls = cls; currentCls != null; currentCls = currentCls.getSuperclass()) {
            m = ParseTools.getExactMatch(name2, args2, rt, currentCls);
            if (m == null) continue;
            best = m;
        }
        return best;
    }

    private static Class[] getConstructors(Constructor cns) {
        Class[] parms;
        WeakReference<Class[]> ref = CONSTRUCTOR_PARMS_CACHE.get(cns);
        if (ref != null && (parms = (Class[])ref.get()) != null) {
            return parms;
        }
        parms = cns.getParameterTypes();
        CONSTRUCTOR_PARMS_CACHE.put(cns, new WeakReference<Class<?>[]>(parms));
        return parms;
    }

    public static Constructor getBestConstructorCandidate(Object[] args2, Class cls, boolean requireExact) {
        Class[] arguments = new Class[args2.length];
        for (int i2 = 0; i2 != args2.length; ++i2) {
            if (args2[i2] == null) continue;
            arguments[i2] = args2[i2].getClass();
        }
        return ParseTools.getBestConstructorCandidate(arguments, cls, requireExact);
    }

    public static Constructor getBestConstructorCandidate(Class[] arguments, Class cls, boolean requireExact) {
        WeakReference<Constructor> ref;
        Constructor bestCandidate = null;
        int bestScore = 0;
        Integer hash2 = ParseTools.createClassSignatureHash(cls, arguments);
        Map<Integer, WeakReference<Constructor>> cache = RESOLVED_CONST_CACHE.get(cls);
        if (cache != null && (ref = cache.get(hash2)) != null && (bestCandidate = (Constructor)ref.get()) != null) {
            return bestCandidate;
        }
        for (Constructor construct : ParseTools.getConstructors(cls)) {
            boolean isVarArgs = construct.isVarArgs();
            Class[] parmTypes = ParseTools.getConstructors(construct);
            if (parmTypes.length != arguments.length && !construct.isVarArgs()) continue;
            if (arguments.length == 0 && parmTypes.length == 0) {
                return construct;
            }
            int score = ParseTools.getMethodScore(arguments, requireExact, parmTypes, isVarArgs);
            if (score == 0 || score <= bestScore) continue;
            bestCandidate = construct;
            bestScore = score;
        }
        if (bestCandidate != null) {
            if (cache == null) {
                cache = new WeakHashMap<Integer, WeakReference<Constructor>>();
                RESOLVED_CONST_CACHE.put(cls, cache);
            }
            cache.put(hash2, new WeakReference<Constructor>(bestCandidate));
        }
        return bestCandidate;
    }

    public static Class createClass(String className, ParserContext pCtx) throws ClassNotFoundException {
        ClassLoader classLoader = pCtx != null ? pCtx.getClassLoader() : Thread.currentThread().getContextClassLoader();
        Map<String, WeakReference<Class>> cache = CLASS_RESOLVER_CACHE.get(classLoader);
        if (cache == null) {
            cache = new WeakHashMap<String, WeakReference<Class>>(10);
            CLASS_RESOLVER_CACHE.put(classLoader, cache);
        }
        Class<?> cls = null;
        WeakReference<Class> ref = cache.get(className);
        if (ref != null && (cls = (Class<?>)ref.get()) != null) {
            return cls;
        }
        try {
            cls = Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            if (classLoader != Thread.currentThread().getContextClassLoader()) {
                cls = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            throw e;
        }
        cache.put(className, new WeakReference(cls));
        return cls;
    }

    public static Constructor[] getConstructors(Class cls) {
        Constructor[] cns;
        WeakReference<Constructor[]> ref = CLASS_CONSTRUCTOR_CACHE.get(cls);
        if (ref != null && (cns = (Constructor[])ref.get()) != null) {
            return cns;
        }
        cns = cls.getConstructors();
        CLASS_CONSTRUCTOR_CACHE.put(cls, new WeakReference<Constructor<?>[]>(cns));
        return cns;
    }

    public static String[] captureContructorAndResidual(char[] cs, int start2, int offset2) {
        int depth = 0;
        int end2 = start2 + offset2;
        block4: for (int i2 = start2; i2 < end2; ++i2) {
            switch (cs[i2]) {
                case '(': {
                    ++depth;
                    continue block4;
                }
                case ')': {
                    if (1 != depth--) continue block4;
                    return new String[]{ParseTools.createStringTrimmed(cs, start2, ++i2 - start2), ParseTools.createStringTrimmed(cs, i2, end2 - i2)};
                }
            }
        }
        return new String[]{new String(cs, start2, offset2)};
    }

    public static Class boxPrimitive(Class cls) {
        if (cls == Integer.TYPE || cls == Integer.class) {
            return Integer.class;
        }
        if (cls == int[].class || cls == Integer[].class) {
            return Integer[].class;
        }
        if (cls == Character.TYPE || cls == Character.class) {
            return Character.class;
        }
        if (cls == char[].class || cls == Character[].class) {
            return Character[].class;
        }
        if (cls == Long.TYPE || cls == Long.class) {
            return Long.class;
        }
        if (cls == long[].class || cls == Long[].class) {
            return Long[].class;
        }
        if (cls == Short.TYPE || cls == Short.class) {
            return Short.class;
        }
        if (cls == short[].class || cls == Short[].class) {
            return Short[].class;
        }
        if (cls == Double.TYPE || cls == Double.class) {
            return Double.class;
        }
        if (cls == double[].class || cls == Double[].class) {
            return Double[].class;
        }
        if (cls == Float.TYPE || cls == Float.class) {
            return Float.class;
        }
        if (cls == float[].class || cls == Float[].class) {
            return Float[].class;
        }
        if (cls == Boolean.TYPE || cls == Boolean.class) {
            return Boolean.class;
        }
        if (cls == boolean[].class || cls == Boolean[].class) {
            return Boolean[].class;
        }
        if (cls == Byte.TYPE || cls == Byte.class) {
            return Byte.class;
        }
        if (cls == byte[].class || cls == Byte[].class) {
            return Byte[].class;
        }
        return cls;
    }

    public static Class unboxPrimitive(Class cls) {
        if (cls == Integer.class || cls == Integer.TYPE) {
            return Integer.TYPE;
        }
        if (cls == Integer[].class || cls == int[].class) {
            return int[].class;
        }
        if (cls == Long.class || cls == Long.TYPE) {
            return Long.TYPE;
        }
        if (cls == Long[].class || cls == long[].class) {
            return long[].class;
        }
        if (cls == Character.class || cls == Character.TYPE) {
            return Character.TYPE;
        }
        if (cls == Character[].class || cls == char[].class) {
            return char[].class;
        }
        if (cls == Short.class || cls == Short.TYPE) {
            return Short.TYPE;
        }
        if (cls == Short[].class || cls == short[].class) {
            return short[].class;
        }
        if (cls == Double.class || cls == Double.TYPE) {
            return Double.TYPE;
        }
        if (cls == Double[].class || cls == double[].class) {
            return double[].class;
        }
        if (cls == Float.class || cls == Float.TYPE) {
            return Float.TYPE;
        }
        if (cls == Float[].class || cls == float[].class) {
            return float[].class;
        }
        if (cls == Boolean.class || cls == Boolean.TYPE) {
            return Boolean.TYPE;
        }
        if (cls == Boolean[].class || cls == boolean[].class) {
            return boolean[].class;
        }
        if (cls == Byte.class || cls == Byte.TYPE) {
            return Byte.TYPE;
        }
        if (cls == Byte[].class || cls == byte[].class) {
            return byte[].class;
        }
        return cls;
    }

    public static boolean containsCheck(Object compareTo, Object compareTest) {
        if (compareTo == null) {
            return false;
        }
        if (compareTo instanceof String) {
            return ((String)compareTo).contains(String.valueOf(compareTest));
        }
        if (compareTo instanceof Collection) {
            return ((Collection)compareTo).contains(compareTest);
        }
        if (compareTo instanceof Map) {
            return ((Map)compareTo).containsKey(compareTest);
        }
        if (compareTo.getClass().isArray()) {
            if (compareTo.getClass().getComponentType().isPrimitive()) {
                return ParseTools.containsCheckOnPrimitveArray(compareTo, compareTest);
            }
            for (Object o : (Object[])compareTo) {
                if (compareTest == null && o == null) {
                    return true;
                }
                if (!((Boolean)MathProcessor.doOperations(o, 18, compareTest)).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean containsCheckOnPrimitveArray(Object primitiveArray, Object compareTest) {
        Class<?> primitiveType = primitiveArray.getClass().getComponentType();
        if (primitiveType == Boolean.TYPE) {
            return compareTest instanceof Boolean && ParseTools.containsCheckOnBooleanArray((boolean[])primitiveArray, (Boolean)compareTest);
        }
        if (primitiveType == Integer.TYPE) {
            return compareTest instanceof Integer && ParseTools.containsCheckOnIntArray((int[])primitiveArray, (Integer)compareTest);
        }
        if (primitiveType == Long.TYPE) {
            return compareTest instanceof Long && ParseTools.containsCheckOnLongArray((long[])primitiveArray, (Long)compareTest);
        }
        if (primitiveType == Double.TYPE) {
            return compareTest instanceof Double && ParseTools.containsCheckOnDoubleArray((double[])primitiveArray, (Double)compareTest);
        }
        if (primitiveType == Float.TYPE) {
            return compareTest instanceof Float && ParseTools.containsCheckOnFloatArray((float[])primitiveArray, (Float)compareTest);
        }
        if (primitiveType == Character.TYPE) {
            return compareTest instanceof Character && ParseTools.containsCheckOnCharArray((char[])primitiveArray, (Character)compareTest);
        }
        if (primitiveType == Short.TYPE) {
            return compareTest instanceof Short && ParseTools.containsCheckOnShortArray((short[])primitiveArray, (Short)compareTest);
        }
        if (primitiveType == Byte.TYPE) {
            return compareTest instanceof Byte && ParseTools.containsCheckOnByteArray((byte[])primitiveArray, (Byte)compareTest);
        }
        return false;
    }

    private static boolean containsCheckOnBooleanArray(boolean[] array, Boolean compareTest) {
        boolean test2 = compareTest;
        for (boolean b : array) {
            if (b != test2) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCheckOnIntArray(int[] array, Integer compareTest) {
        int test2 = compareTest;
        for (int i2 : array) {
            if (i2 != test2) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCheckOnLongArray(long[] array, Long compareTest) {
        long test2 = compareTest;
        for (long l : array) {
            if (l != test2) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCheckOnDoubleArray(double[] array, Double compareTest) {
        double test2 = compareTest;
        for (double d : array) {
            if (d != test2) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCheckOnFloatArray(float[] array, Float compareTest) {
        float test2 = compareTest.floatValue();
        for (float f : array) {
            if (f != test2) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCheckOnCharArray(char[] array, Character compareTest) {
        char test2 = compareTest.charValue();
        for (char c : array) {
            if (c != test2) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCheckOnShortArray(short[] array, Short compareTest) {
        short test2 = compareTest;
        for (short s2 : array) {
            if (s2 != test2) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCheckOnByteArray(byte[] array, Byte compareTest) {
        byte test2 = compareTest;
        for (byte b : array) {
            if (b != test2) continue;
            return true;
        }
        return false;
    }

    public static int createClassSignatureHash(Class declaring, Class[] sig) {
        int hash2 = 0;
        for (int i2 = 0; i2 < sig.length; ++i2) {
            if (sig[i2] == null) continue;
            hash2 += sig[i2].hashCode() * (i2 * 2 + 3);
        }
        return hash2 + sig.length + declaring.hashCode();
    }

    public static int handleEscapeSequence(char[] escapeStr, int pos2) {
        escapeStr[pos2 - 1] = '\u0000';
        switch (escapeStr[pos2]) {
            case '\\': {
                escapeStr[pos2] = 92;
                return 1;
            }
            case 'b': {
                escapeStr[pos2] = 8;
                return 1;
            }
            case 'f': {
                escapeStr[pos2] = 12;
                return 1;
            }
            case 't': {
                escapeStr[pos2] = 9;
                return 1;
            }
            case 'r': {
                escapeStr[pos2] = 13;
                return 1;
            }
            case 'n': {
                escapeStr[pos2] = 10;
                return 1;
            }
            case '\'': {
                escapeStr[pos2] = 39;
                return 1;
            }
            case '\"': {
                escapeStr[pos2] = 34;
                return 1;
            }
            case 'u': {
                int s2 = pos2;
                if (s2 + 4 > escapeStr.length) {
                    throw new CompileException("illegal unicode escape sequence", escapeStr, pos2);
                }
                while (++pos2 - s2 != 5) {
                    if (escapeStr[pos2] > '/' && escapeStr[pos2] < ':' || escapeStr[pos2] > '@' && escapeStr[pos2] < 'G') continue;
                    throw new CompileException("illegal unicode escape sequence", escapeStr, pos2);
                }
                escapeStr[s2 - 1] = (char)Integer.decode("0x" + new String(escapeStr, s2 + 1, 4)).intValue();
                escapeStr[s2] = '\u0000';
                escapeStr[s2 + 1] = '\u0000';
                escapeStr[s2 + 2] = '\u0000';
                escapeStr[s2 + 3] = '\u0000';
                escapeStr[s2 + 4] = '\u0000';
                return 5;
            }
        }
        int s2 = pos2;
        while (escapeStr[pos2] >= '0' && escapeStr[pos2] < '8') {
            if (pos2 != s2 && escapeStr[s2] > '3') {
                escapeStr[s2 - 1] = (char)Integer.decode("0" + new String(escapeStr, s2, pos2 - s2 + 1)).intValue();
                escapeStr[s2] = '\u0000';
                escapeStr[s2 + 1] = '\u0000';
                return 2;
            }
            if (pos2 - s2 == 2) {
                escapeStr[s2 - 1] = (char)Integer.decode("0" + new String(escapeStr, s2, pos2 - s2 + 1)).intValue();
                escapeStr[s2] = '\u0000';
                escapeStr[s2 + 1] = '\u0000';
                escapeStr[s2 + 2] = '\u0000';
                return 3;
            }
            if (pos2 + 1 == escapeStr.length || escapeStr[pos2] < '0' || escapeStr[pos2] > '7') {
                escapeStr[s2 - 1] = (char)Integer.decode("0" + new String(escapeStr, s2, pos2 - s2 + 1)).intValue();
                escapeStr[s2] = '\u0000';
                return 1;
            }
            ++pos2;
        }
        throw new CompileException("illegal escape sequence: " + escapeStr[pos2], escapeStr, pos2);
    }

    public static char[] createShortFormOperativeAssignment(String name2, char[] statement, int start2, int offset2, int operation) {
        if (operation == -1) {
            return statement;
        }
        int op = 0;
        switch (operation) {
            case 0: {
                op = 43;
                break;
            }
            case 20: {
                op = 35;
                break;
            }
            case 1: {
                op = 45;
                break;
            }
            case 2: {
                op = 42;
                break;
            }
            case 4: {
                op = 37;
                break;
            }
            case 3: {
                op = 47;
                break;
            }
            case 6: {
                op = 38;
                break;
            }
            case 7: {
                op = 124;
                break;
            }
            case 10: {
                op = 171;
                break;
            }
            case 9: {
                op = 187;
                break;
            }
            case 11: {
                op = 172;
            }
        }
        char[] stmt = new char[name2.length() + offset2 + 1];
        System.arraycopy(name2.toCharArray(), 0, stmt, 0, name2.length());
        stmt[name2.length()] = op;
        System.arraycopy(statement, start2, stmt, name2.length() + 1, offset2);
        return stmt;
    }

    public static ClassImportResolverFactory findClassImportResolverFactory(VariableResolverFactory factory, ParserContext pCtx) {
        if (factory == null) {
            throw new OptimizationFailure("unable to import classes.  no variable resolver factory available.");
        }
        for (VariableResolverFactory v = factory; v != null; v = v.getNextFactory()) {
            if (!(v instanceof ClassImportResolverFactory)) continue;
            return (ClassImportResolverFactory)v;
        }
        return ResolverTools.appendFactory(factory, new ClassImportResolverFactory(null, null, false));
    }

    public static Class findClass(VariableResolverFactory factory, String name2, ParserContext pCtx) throws ClassNotFoundException {
        try {
            if (AbstractParser.LITERALS.containsKey(name2)) {
                return (Class)AbstractParser.LITERALS.get(name2);
            }
            if (factory != null && factory.isResolveable(name2)) {
                return (Class)factory.getVariableResolver(name2).getValue();
            }
            if (pCtx != null && pCtx.hasImport(name2)) {
                return pCtx.getImport(name2);
            }
            return ParseTools.createClass(name2, pCtx);
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("class not found: " + name2, e);
        }
    }

    public static char[] subsetTrimmed(char[] array, int start2, int length2) {
        int end2;
        if (length2 <= 0) {
            return new char[0];
        }
        for (end2 = start2 + length2; end2 > 0 && ParseTools.isWhitespace(array[end2 - 1]); --end2) {
        }
        while (ParseTools.isWhitespace(array[start2]) && start2 < end2) {
            ++start2;
        }
        length2 = end2 - start2;
        if (length2 == 0) {
            return new char[0];
        }
        return ParseTools.subset(array, start2, length2);
    }

    public static char[] subset(char[] array, int start2, int length2) {
        char[] newArray = new char[length2];
        for (int i2 = 0; i2 < newArray.length; ++i2) {
            newArray[i2] = array[i2 + start2];
        }
        return newArray;
    }

    public static char[] subset(char[] array, int start2) {
        char[] newArray = new char[array.length - start2];
        for (int i2 = 0; i2 < newArray.length; ++i2) {
            newArray[i2] = array[i2 + start2];
        }
        return newArray;
    }

    public static int resolveType(Object o) {
        if (o == null) {
            return 0;
        }
        return ParseTools.__resolveType(o.getClass());
    }

    public static int __resolveType(Class cls) {
        Integer code = typeCodes.get(cls);
        if (code == null) {
            if (cls != null && Collection.class.isAssignableFrom(cls)) {
                return 50;
            }
            return 0;
        }
        return code;
    }

    public static boolean isNumericallyCoercible(Class target, Class parm) {
        Class boxedTarget;
        Class clazz = boxedTarget = target.isPrimitive() ? ParseTools.boxPrimitive(target) : target;
        if (boxedTarget != null && Number.class.isAssignableFrom(target) && (boxedTarget = parm.isPrimitive() ? ParseTools.boxPrimitive(parm) : parm) != null) {
            return Number.class.isAssignableFrom(boxedTarget);
        }
        return false;
    }

    public static Object narrowType(BigDecimal result2, int returnTarget) {
        if (returnTarget == 109 || result2.scale() > 0) {
            return result2.doubleValue();
        }
        if (returnTarget == 107 || result2.longValue() > Integer.MAX_VALUE) {
            return result2.longValue();
        }
        return result2.intValue();
    }

    public static Method determineActualTargetMethod(Method method2) {
        String name2 = method2.getName();
        for (Class<?> cls : method2.getDeclaringClass().getInterfaces()) {
            for (Method meth : cls.getMethods()) {
                if (meth.getParameterTypes().length != 0 || !name2.equals(meth.getName())) continue;
                return meth;
            }
        }
        return null;
    }

    public static int captureToNextTokenJunction(char[] expr, int cursor, int end2, ParserContext pCtx) {
        block4: while (cursor != expr.length) {
            switch (expr[cursor]) {
                case '(': 
                case '{': {
                    return cursor;
                }
                case '[': {
                    cursor = ParseTools.balancedCaptureWithLineAccounting(expr, cursor, end2, '[', pCtx) + 1;
                    continue block4;
                }
            }
            if (ParseTools.isWhitespace(expr[cursor])) {
                return cursor;
            }
            ++cursor;
        }
        return cursor;
    }

    public static int nextNonBlank(char[] expr, int cursor) {
        int i2;
        if (cursor + 1 >= expr.length) {
            throw new CompileException("unexpected end of statement", expr, cursor);
        }
        for (i2 = cursor; i2 != expr.length && ParseTools.isWhitespace(expr[i2]); ++i2) {
        }
        return i2;
    }

    public static int skipWhitespace(char[] expr, int cursor) {
        block8: while (cursor != expr.length) {
            switch (expr[cursor]) {
                case '\n': 
                case '\r': {
                    ++cursor;
                    continue block8;
                }
                case '/': {
                    if (cursor + 1 != expr.length) {
                        switch (expr[cursor + 1]) {
                            case '/': {
                                expr[cursor++] = 32;
                                while (cursor != expr.length && expr[cursor] != '\n') {
                                    expr[cursor++] = 32;
                                }
                                if (cursor == expr.length) continue block8;
                                expr[cursor++] = 32;
                                continue block8;
                            }
                            case '*': {
                                int len = expr.length - 1;
                                expr[cursor++] = 32;
                                while (cursor != len && (expr[cursor] != '*' || expr[cursor + 1] != '/')) {
                                    expr[cursor++] = 32;
                                }
                                if (cursor == len) continue block8;
                                int n = cursor++;
                                expr[cursor++] = 32;
                                expr[n] = 32;
                                continue block8;
                            }
                        }
                        break block8;
                    }
                }
                default: {
                    if (!ParseTools.isWhitespace(expr[cursor])) break block8;
                    ++cursor;
                    continue block8;
                }
            }
        }
        return cursor;
    }

    public static boolean isStatementNotManuallyTerminated(char[] expr, int cursor) {
        int c;
        if (cursor >= expr.length) {
            return false;
        }
        for (c = cursor; c != expr.length && ParseTools.isWhitespace(expr[c]); ++c) {
        }
        return c == expr.length || expr[c] != ';';
    }

    public static int captureToEOS(char[] expr, int cursor, int end2, ParserContext pCtx) {
        while (cursor != expr.length) {
            switch (expr[cursor]) {
                case '(': 
                case '[': 
                case '{': {
                    cursor = ParseTools.balancedCaptureWithLineAccounting(expr, cursor, end2, expr[cursor], pCtx);
                    if (cursor < expr.length) break;
                    return cursor;
                }
                case '\"': 
                case '\'': {
                    cursor = ParseTools.captureStringLiteral(expr[cursor], expr, cursor, expr.length);
                    break;
                }
                case ',': 
                case ';': 
                case '}': {
                    return cursor;
                }
            }
            ++cursor;
        }
        return cursor;
    }

    public static int trimLeft(char[] expr, int start2, int pos2) {
        if (pos2 > expr.length) {
            pos2 = expr.length;
        }
        while (pos2 != 0 && pos2 >= start2 && ParseTools.isWhitespace(expr[pos2 - 1])) {
            --pos2;
        }
        return pos2;
    }

    public static int trimRight(char[] expr, int pos2) {
        while (pos2 != expr.length && ParseTools.isWhitespace(expr[pos2])) {
            ++pos2;
        }
        return pos2;
    }

    public static char[] subArray(char[] expr, int start2, int end2) {
        if (start2 >= end2) {
            return new char[0];
        }
        char[] newA = new char[end2 - start2];
        for (int i2 = 0; i2 != newA.length; ++i2) {
            newA[i2] = expr[i2 + start2];
        }
        return newA;
    }

    public static int balancedCapture(char[] chars2, int start2, char type2) {
        return ParseTools.balancedCapture(chars2, start2, chars2.length, type2);
    }

    public static int balancedCapture(char[] chars2, int start2, int end2, char type2) {
        int depth = 1;
        char term = type2;
        switch (type2) {
            case '[': {
                term = ']';
                break;
            }
            case '{': {
                term = '}';
                break;
            }
            case '(': {
                term = ')';
            }
        }
        if (type2 == term) {
            ++start2;
            while (start2 < end2) {
                if (chars2[start2] == type2) {
                    return start2;
                }
                ++start2;
            }
        } else {
            ++start2;
            while (start2 < end2) {
                block32: {
                    if (start2 < end2 && chars2[start2] == '/') {
                        if (start2 + 1 == end2) {
                            return start2;
                        }
                        if (chars2[start2 + 1] == '/') {
                            ++start2;
                            while (start2 < end2 && chars2[start2] != '\n') {
                                ++start2;
                            }
                        } else if (chars2[start2 + 1] == '*') {
                            start2 += 2;
                            block16: while (start2 < end2) {
                                switch (chars2[start2]) {
                                    case '*': {
                                        if (start2 + 1 < end2 && chars2[start2 + 1] == '/') break block32;
                                    }
                                    default: {
                                        ++start2;
                                        continue block16;
                                    }
                                }
                            }
                        }
                    }
                }
                if (start2 == end2) {
                    return start2;
                }
                if (chars2[start2] == '\'' || chars2[start2] == '\"') {
                    start2 = ParseTools.captureStringLiteral(chars2[start2], chars2, start2, end2);
                } else if (chars2[start2] == type2) {
                    ++depth;
                } else if (chars2[start2] == term && --depth == 0) {
                    return start2;
                }
                ++start2;
            }
        }
        switch (type2) {
            case '[': {
                throw new CompileException("unbalanced braces [ ... ]", chars2, start2);
            }
            case '{': {
                throw new CompileException("unbalanced braces { ... }", chars2, start2);
            }
            case '(': {
                throw new CompileException("unbalanced braces ( ... )", chars2, start2);
            }
        }
        throw new CompileException("unterminated string literal", chars2, start2);
    }

    public static int balancedCaptureWithLineAccounting(char[] chars2, int start2, int end2, char type2, ParserContext pCtx) {
        int st;
        block40: {
            char term;
            int depth;
            block39: {
                depth = 1;
                st = start2;
                term = type2;
                switch (type2) {
                    case '[': {
                        term = ']';
                        break;
                    }
                    case '{': {
                        term = '}';
                        break;
                    }
                    case '(': {
                        term = ')';
                    }
                }
                if (type2 != term) break block39;
                ++start2;
                while (start2 != end2) {
                    if (chars2[start2] == type2) {
                        return start2;
                    }
                    ++start2;
                }
                break block40;
            }
            int lines2 = 0;
            ++start2;
            while (start2 < end2) {
                block42: {
                    block38: {
                        block41: {
                            if (!ParseTools.isWhitespace(chars2[start2])) break block41;
                            switch (chars2[start2]) {
                                case '\r': {
                                    break block42;
                                }
                                case '\n': {
                                    if (pCtx != null) {
                                        pCtx.setLineOffset((short)start2);
                                    }
                                    ++lines2;
                                }
                            }
                            break block38;
                        }
                        if (start2 < end2 && chars2[start2] == '/') {
                            if (start2 + 1 == end2) {
                                return start2;
                            }
                            if (chars2[start2 + 1] == '/') {
                                ++start2;
                                while (start2 < end2 && chars2[start2] != '\n') {
                                    ++start2;
                                }
                            } else if (chars2[start2 + 1] == '*') {
                                start2 += 2;
                                block21: while (start2 != end2) {
                                    switch (chars2[start2]) {
                                        case '*': {
                                            if (start2 + 1 < end2 && chars2[start2 + 1] == '/') break block38;
                                        }
                                        case '\n': 
                                        case '\r': {
                                            if (pCtx != null) {
                                                pCtx.setLineOffset((short)start2);
                                            }
                                            ++lines2;
                                        }
                                        default: {
                                            ++start2;
                                            continue block21;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (start2 == end2) {
                        return start2;
                    }
                    if (chars2[start2] == '\'' || chars2[start2] == '\"') {
                        start2 = ParseTools.captureStringLiteral(chars2[start2], chars2, start2, end2);
                    } else if (chars2[start2] == type2) {
                        ++depth;
                    } else if (chars2[start2] == term && --depth == 0) {
                        if (pCtx != null) {
                            pCtx.incrementLineCount(lines2);
                        }
                        return start2;
                    }
                }
                ++start2;
            }
        }
        switch (type2) {
            case '[': {
                throw new CompileException("unbalanced braces [ ... ]", chars2, st);
            }
            case '{': {
                throw new CompileException("unbalanced braces { ... }", chars2, st);
            }
            case '(': {
                throw new CompileException("unbalanced braces ( ... )", chars2, st);
            }
        }
        throw new CompileException("unterminated string literal", chars2, st);
    }

    public static String handleStringEscapes(char[] input) {
        int escapes = 0;
        for (int i2 = 0; i2 < input.length; ++i2) {
            if (input[i2] != '\\') continue;
            escapes += ParseTools.handleEscapeSequence(input, ++i2);
        }
        if (escapes == 0) {
            return new String(input);
        }
        char[] processedEscapeString = new char[input.length - escapes];
        int cursor = 0;
        for (char aName : input) {
            if (aName == '\u0000') continue;
            processedEscapeString[cursor++] = aName;
        }
        return new String(processedEscapeString);
    }

    public static int captureStringLiteral(char type2, char[] expr, int cursor, int end2) {
        while (++cursor < end2 && expr[cursor] != type2) {
            if (expr[cursor] != '\\') continue;
            ++cursor;
        }
        if (cursor >= end2 || expr[cursor] != type2) {
            throw new CompileException("unterminated string literal", expr, cursor);
        }
        return cursor;
    }

    public static void parseWithExpressions(String nestParm, char[] block, int start2, int offset2, Object ctx, VariableResolverFactory factory) {
        int _st = start2;
        int _end = -1;
        int end2 = start2 + offset2;
        int oper = -1;
        String parm = "";
        block13: for (int i2 = start2; i2 < end2; ++i2) {
            switch (block[i2]) {
                case '\"': 
                case '\'': 
                case '(': 
                case '[': 
                case '{': {
                    i2 = ParseTools.balancedCapture(block, i2, end2, block[i2]);
                    continue block13;
                }
                case '/': {
                    if (i2 < end2 && block[i2 + 1] == '/') {
                        while (i2 < end2 && block[i2] != '\n') {
                            block[i2++] = 32;
                        }
                        if (parm != null) continue block13;
                        _st = i2;
                        continue block13;
                    }
                    if (i2 < end2 && block[i2 + 1] == '*') {
                        int len = end2 - 1;
                        while (i2 < len && (block[i2] != '*' || block[i2 + 1] != '/')) {
                            block[i2++] = 32;
                        }
                        block[i2++] = 32;
                        block[i2++] = 32;
                        if (parm != null) continue block13;
                        _st = i2;
                        continue block13;
                    }
                    if (i2 >= end2 || block[i2 + 1] != '=') continue block13;
                    oper = 3;
                    continue block13;
                }
                case '%': 
                case '*': 
                case '+': 
                case '-': {
                    if (i2 + 1 >= end2 || block[i2 + 1] != '=') continue block13;
                    oper = ParseTools.opLookup(block[i2]);
                    continue block13;
                }
                case '=': {
                    parm = new String(block, _st, i2 - _st - (oper != -1 ? 1 : 0)).trim();
                    _st = i2 + 1;
                    continue block13;
                }
                case ',': {
                    if (_end == -1) {
                        _end = i2;
                    }
                    if (parm == null) {
                        try {
                            if (nestParm == null) {
                                MVEL.eval(new String(block, _st, _end - _st), ctx, factory);
                            } else {
                                MVEL.eval(new StringBuilder(nestParm).append('.').append(block, _st, _end - _st).toString(), ctx, factory);
                            }
                        }
                        catch (CompileException e) {
                            e.setCursor(_st + (e.getCursor() - (e.getExpr().length - offset2)));
                            e.setExpr(block);
                            throw e;
                        }
                        oper = -1;
                        _st = ++i2;
                    } else {
                        try {
                            if (oper != -1) {
                                if (nestParm == null) {
                                    throw new CompileException("operative assignment not possible here", block, start2);
                                }
                                String rewrittenExpr = new String(ParseTools.createShortFormOperativeAssignment(nestParm + "." + parm, block, _st, _end - _st, oper));
                                MVEL.setProperty(ctx, parm, MVEL.eval(rewrittenExpr, ctx, factory));
                            } else {
                                MVEL.setProperty(ctx, parm, MVEL.eval(block, _st, _end - _st, ctx, factory));
                            }
                        }
                        catch (CompileException e) {
                            e.setCursor(_st + (e.getCursor() - (e.getExpr().length - offset2)));
                            e.setExpr(block);
                            throw e;
                        }
                        parm = null;
                        oper = -1;
                        _st = ++i2;
                    }
                    _end = -1;
                }
            }
        }
        _end = end2;
        if (_st != _end) {
            try {
                if (parm == null || "".equals(parm)) {
                    if (nestParm == null) {
                        MVEL.eval(new String(block, _st, _end - _st), ctx, factory);
                    } else {
                        MVEL.eval(new StringAppender(nestParm).append('.').append(block, _st, _end - _st).toString(), ctx, factory);
                    }
                } else if (oper != -1) {
                    if (nestParm == null) {
                        throw new CompileException("operative assignment not possible here", block, start2);
                    }
                    String rewrittenExpr = new String(ParseTools.createShortFormOperativeAssignment(nestParm + "." + parm, block, _st, _end - _st, oper));
                    MVEL.setProperty(ctx, parm, MVEL.eval(rewrittenExpr, ctx, factory));
                } else {
                    MVEL.setProperty(ctx, parm, MVEL.eval(block, _st, end2 - _st, ctx, factory));
                }
            }
            catch (CompileException e) {
                e.setCursor(_st + (e.getCursor() - (e.getExpr().length - offset2)));
                e.setExpr(block);
                throw e;
            }
        }
    }

    public static Object handleNumericConversion(char[] val, int start2, int offset2) {
        if (offset2 != 1 && val[start2] == '0' && val[start2 + 1] != '.') {
            if (!ParseTools.isDigit(val[start2 + offset2 - 1])) {
                switch (val[start2 + offset2 - 1]) {
                    case 'L': 
                    case 'l': {
                        return Long.decode(new String(val, start2, offset2 - 1));
                    }
                    case 'I': {
                        return BigInteger.valueOf(Long.decode(new String(val, start2, offset2 - 1)));
                    }
                    case 'B': {
                        return BigDecimal.valueOf(Long.decode(new String(val, start2, offset2 - 1)));
                    }
                }
            }
            return Integer.decode(new String(val));
        }
        if (!ParseTools.isDigit(val[start2 + offset2 - 1])) {
            switch (val[start2 + offset2 - 1]) {
                case 'L': 
                case 'l': {
                    return Long.parseLong(new String(val, start2, offset2 - 1));
                }
                case '.': 
                case 'D': 
                case 'd': {
                    return Double.parseDouble(new String(val, start2, offset2 - 1));
                }
                case 'F': 
                case 'f': {
                    return Float.valueOf(Float.parseFloat(new String(val, start2, offset2 - 1)));
                }
                case 'I': {
                    return new BigInteger(new String(val, start2, offset2 - 1));
                }
                case 'B': {
                    return new BigDecimal(new String(val, start2, offset2 - 1));
                }
            }
            throw new CompileException("unrecognized numeric literal", val, start2);
        }
        switch (ParseTools.numericTest(val, start2, offset2)) {
            case 104: {
                return Float.valueOf(Float.parseFloat(new String(val, start2, offset2)));
            }
            case 101: {
                return Integer.parseInt(new String(val, start2, offset2));
            }
            case 102: {
                return Long.parseLong(new String(val, start2, offset2));
            }
            case 103: {
                return Double.parseDouble(new String(val, start2, offset2));
            }
            case 110: {
                return new BigDecimal(val, MathContext.DECIMAL128);
            }
        }
        return new String(val, start2, offset2);
    }

    public static boolean isNumeric(Object val) {
        if (val == null) {
            return false;
        }
        Class<?> clz = val instanceof Class ? (Class<?>)val : val.getClass();
        return clz == Integer.TYPE || clz == Long.TYPE || clz == Short.TYPE || clz == Double.TYPE || clz == Float.TYPE || Number.class.isAssignableFrom(clz);
    }

    public static int numericTest(char[] val, int start2, int offset2) {
        boolean fp = false;
        int i2 = start2;
        if (offset2 > 1) {
            if (val[start2] == '-') {
                ++i2;
            } else if (val[start2] == '~') {
                ++i2;
                if (val[start2 + 1] == '-') {
                    ++i2;
                }
            }
        }
        int end2 = start2 + offset2;
        while (i2 < end2) {
            char c = val[i2];
            if (!ParseTools.isDigit(c)) {
                switch (c) {
                    case '.': {
                        fp = true;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        fp = true;
                        if (i2++ >= end2 || val[i2] != '-') break;
                        ++i2;
                        break;
                    }
                    default: {
                        return -1;
                    }
                }
            }
            ++i2;
        }
        if (offset2 != 0) {
            if (fp) {
                return 103;
            }
            if (offset2 > 9) {
                return 102;
            }
            return 101;
        }
        return -1;
    }

    public static boolean isNumber(Object val) {
        if (val == null) {
            return false;
        }
        if (val instanceof String) {
            return ParseTools.isNumber((String)val);
        }
        if (val instanceof char[]) {
            return ParseTools.isNumber(new String((char[])val));
        }
        return val instanceof Integer || val instanceof BigDecimal || val instanceof BigInteger || val instanceof Float || val instanceof Double || val instanceof Long || val instanceof Short || val instanceof Character;
    }

    public static boolean isNumber(String val) {
        int len = val.length();
        boolean f = true;
        int i2 = 0;
        if (len > 1) {
            if (val.charAt(0) == '-') {
                ++i2;
            } else if (val.charAt(0) == '~') {
                ++i2;
                if (val.charAt(1) == '-') {
                    ++i2;
                }
            }
        }
        while (i2 < len) {
            char c = val.charAt(i2);
            if (!ParseTools.isDigit(c)) {
                if (c == '.' && f) {
                    f = false;
                } else {
                    return false;
                }
            }
            ++i2;
        }
        return len > 0;
    }

    public static boolean isNumber(char[] val, int start2, int offset2) {
        boolean f = true;
        int i2 = start2;
        int end2 = start2 + offset2;
        if (offset2 > 1) {
            switch (val[start2]) {
                case '-': {
                    if (val[start2 + 1] == '-') {
                        ++i2;
                    }
                }
                case '~': {
                    ++i2;
                }
            }
        }
        while (i2 < end2) {
            char c = val[i2];
            if (!ParseTools.isDigit(c)) {
                if (f && c == '.') {
                    f = false;
                } else {
                    if (offset2 != 1 && i2 == start2 + offset2 - 1) {
                        switch (c) {
                            case 'B': 
                            case 'D': 
                            case 'F': 
                            case 'I': 
                            case 'L': 
                            case 'd': 
                            case 'f': 
                            case 'l': {
                                return true;
                            }
                            case '.': {
                                throw new CompileException("invalid number literal: " + new String(val), val, start2);
                            }
                        }
                        return false;
                    }
                    if (i2 == start2 + 1 && c == 'x' && val[start2] == '0') {
                        ++i2;
                        while (i2 < end2) {
                            c = val[i2];
                            if (!(ParseTools.isDigit(c) || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
                                if (i2 == offset2 - 1) {
                                    switch (c) {
                                        case 'B': 
                                        case 'I': 
                                        case 'L': 
                                        case 'l': {
                                            return true;
                                        }
                                    }
                                }
                                return false;
                            }
                            ++i2;
                        }
                        return offset2 - 2 > 0;
                    }
                    if (i2 != start2 && i2 + 1 < end2 && (c == 'E' || c == 'e')) {
                        if (val[++i2] == '-' || val[i2] == '+') {
                            ++i2;
                        }
                    } else {
                        if (i2 != start2) {
                            throw new CompileException("invalid number literal: " + new String(val, start2, offset2), val, start2);
                        }
                        return false;
                    }
                }
            }
            ++i2;
        }
        return end2 > start2;
    }

    public static int find(char[] c, int start2, int offset2, char find2) {
        int length2 = start2 + offset2;
        for (int i2 = start2; i2 < length2; ++i2) {
            if (c[i2] != find2) continue;
            return i2;
        }
        return -1;
    }

    public static int findLast(char[] c, int start2, int offset2, char find2) {
        for (int i2 = start2 + offset2; i2 >= start2; --i2) {
            if (c[i2] != find2) continue;
            return i2;
        }
        return -1;
    }

    public static String createStringTrimmed(char[] s2) {
        int start2;
        int end2 = s2.length;
        for (start2 = 0; start2 != end2 && s2[start2] < '!'; ++start2) {
        }
        while (end2 != start2 && s2[end2 - 1] < '!') {
            --end2;
        }
        return new String(s2, start2, end2 - start2);
    }

    public static String createStringTrimmed(char[] s2, int start2, int length2) {
        if ((length2 = start2 + length2) > s2.length) {
            return new String(s2);
        }
        while (start2 != length2 && s2[start2] < '!') {
            ++start2;
        }
        while (length2 != start2 && s2[length2 - 1] < '!') {
            --length2;
        }
        return new String(s2, start2, length2 - start2);
    }

    public static boolean endsWith(char[] c, int start2, int offset2, char[] test2) {
        if (test2.length > c.length) {
            return false;
        }
        int tD = test2.length - 1;
        int cD = start2 + offset2 - 1;
        while (tD >= 0) {
            if (c[cD--] == test2[tD--]) continue;
            return false;
        }
        return true;
    }

    public static boolean isIdentifierPart(int c) {
        return c > 96 && c < 123 || c > 64 && c < 91 || c > 47 && c < 58 || c == 95 || c == 36 || Character.isJavaIdentifierPart(c);
    }

    public static boolean isDigit(int c) {
        return c > 47 && c < 58;
    }

    public static float similarity(String s1, String s2) {
        char[] against;
        char[] comp;
        float baselength;
        if (s1 == null || s2 == null) {
            return s1 == null && s2 == null ? 1.0f : 0.0f;
        }
        char[] c1 = s1.toCharArray();
        char[] c2 = s2.toCharArray();
        float same2 = 0.0f;
        int cur1 = 0;
        if (c1.length > c2.length) {
            baselength = c1.length;
            comp = c1;
            against = c2;
        } else {
            baselength = c2.length;
            comp = c2;
            against = c1;
        }
        while (cur1 < comp.length && cur1 < against.length) {
            if (comp[cur1] == against[cur1]) {
                same2 += 1.0f;
            }
            ++cur1;
        }
        return same2 / baselength;
    }

    public static int findAbsoluteLast(char[] array) {
        int depth = 0;
        for (int i2 = array.length - 1; i2 >= 0; --i2) {
            if (array[i2] == ']') {
                ++depth;
            }
            if (array[i2] == '[') {
                --depth;
            }
            if ((depth != 0 || array[i2] != '.') && array[i2] != '[') continue;
            return i2;
        }
        return -1;
    }

    public static Class getBaseComponentType(Class cls) {
        while (cls.isArray()) {
            cls = cls.getComponentType();
        }
        return cls;
    }

    public static Class getSubComponentType(Class cls) {
        if (cls.isArray()) {
            cls = cls.getComponentType();
        }
        return cls;
    }

    public static boolean isJunct(char c) {
        switch (c) {
            case '(': 
            case '[': {
                return true;
            }
        }
        return ParseTools.isWhitespace(c);
    }

    public static int opLookup(char c) {
        switch (c) {
            case '|': {
                return 7;
            }
            case '&': {
                return 6;
            }
            case '^': {
                return 8;
            }
            case '*': {
                return 2;
            }
            case '/': {
                return 3;
            }
            case '+': {
                return 0;
            }
            case '%': {
                return 4;
            }
            case '\u00ab': {
                return 10;
            }
            case '\u00bb': {
                return 9;
            }
            case '\u00ac': {
                return 11;
            }
        }
        return -1;
    }

    public static boolean isReservedWord(String name2) {
        return AbstractParser.LITERALS.containsKey(name2) || AbstractParser.OPERATORS.containsKey(name2);
    }

    public static boolean isNotValidNameorLabel(String name2) {
        for (char c : name2.toCharArray()) {
            if (c == '.') {
                return true;
            }
            if (ParseTools.isIdentifierPart(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPropertyOnly(char[] array, int start2, int end2) {
        for (int i2 = start2; i2 < end2; ++i2) {
            if (ParseTools.isIdentifierPart(array[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean isArrayType(char[] array, int start2, int end2) {
        return end2 > start2 + 2 && ParseTools.isPropertyOnly(array, start2, end2 - 2) && array[end2 - 2] == '[' && array[end2 - 1] == ']';
    }

    public static void checkNameSafety(String name2) {
        if (ParseTools.isReservedWord(name2)) {
            throw new RuntimeException("illegal use of reserved word: " + name2);
        }
        if (ParseTools.isDigit(name2.charAt(0))) {
            throw new RuntimeException("not an identifier: " + name2);
        }
    }

    public static FileWriter getDebugFileWriter() throws IOException {
        return new FileWriter(new File(MVEL.getDebuggingOutputFileName()), true);
    }

    public static boolean isPrimitiveWrapper(Class clazz) {
        return clazz == Integer.class || clazz == Boolean.class || clazz == Long.class || clazz == Double.class || clazz == Float.class || clazz == Character.class || clazz == Short.class || clazz == Byte.class;
    }

    public static Serializable subCompileExpression(char[] expression) {
        return ParseTools._optimizeTree(new ExpressionCompiler(expression)._compile());
    }

    public static Serializable subCompileExpression(char[] expression, ParserContext ctx) {
        ExpressionCompiler c = new ExpressionCompiler(expression);
        if (ctx != null) {
            c.setPCtx(ctx);
        }
        return ParseTools._optimizeTree(c._compile());
    }

    public static Serializable subCompileExpression(char[] expression, int start2, int offset2) {
        return ParseTools._optimizeTree(new ExpressionCompiler(expression, start2, offset2)._compile());
    }

    public static Serializable subCompileExpression(char[] expression, int start2, int offset2, ParserContext ctx) {
        ExpressionCompiler c = new ExpressionCompiler(expression, start2, offset2);
        if (ctx != null) {
            c.setPCtx(ctx);
        }
        return ParseTools._optimizeTree(c._compile());
    }

    public static Serializable subCompileExpression(String expression, ParserContext ctx) {
        ExpressionCompiler c = new ExpressionCompiler(expression);
        c.setPCtx(ctx);
        return ParseTools._optimizeTree(c._compile());
    }

    public static Serializable optimizeTree(CompiledExpression compiled) {
        if (!compiled.isImportInjectionRequired() && compiled.getParserConfiguration().isAllowBootstrapBypass() && compiled.isSingleNode()) {
            return ParseTools._optimizeTree(compiled);
        }
        return compiled;
    }

    private static Serializable _optimizeTree(CompiledExpression compiled) {
        if (compiled.isSingleNode()) {
            ASTNode tk = compiled.getFirstNode();
            if (tk.isLiteral() && !tk.isThisVal()) {
                return new ExecutableLiteral(tk.getLiteralValue());
            }
            return tk.canSerializeAccessor() ? new ExecutableAccessorSafe(tk, compiled.getKnownEgressType()) : new ExecutableAccessor(tk, compiled.getKnownEgressType());
        }
        return compiled;
    }

    public static boolean isWhitespace(char c) {
        return c < '!';
    }

    public static String repeatChar(char c, int times2) {
        char[] n = new char[times2];
        for (int i2 = 0; i2 < times2; ++i2) {
            n[i2] = c;
        }
        return new String(n);
    }

    public static char[] loadFromFile(File file2) throws IOException {
        return ParseTools.loadFromFile(file2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] loadFromFile(File file2, String encoding2) throws IOException {
        if (!file2.exists()) {
            throw new RuntimeException("cannot find file: " + file2.getName());
        }
        FileInputStream inStream = null;
        FileChannel fc = null;
        try {
            inStream = new FileInputStream(file2);
            fc = inStream.getChannel();
            ByteBuffer buf = ByteBuffer.allocateDirect(10);
            StringAppender sb = new StringAppender((int)file2.length(), encoding2);
            int read2 = 0;
            while (read2 >= 0) {
                buf.rewind();
                buf.rewind();
                for (read2 = fc.read(buf); read2 > 0; --read2) {
                    sb.append(buf.get());
                }
            }
            char[] cArray = sb.toChars();
            return cArray;
        }
        catch (FileNotFoundException e) {
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            if (fc != null) {
                fc.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readIn(InputStream inStream, String encoding2) throws IOException {
        try {
            int bytesRead;
            byte[] buf = new byte[10];
            StringAppender sb = new StringAppender(10, encoding2);
            while ((bytesRead = inStream.read(buf)) > 0) {
                for (int i2 = 0; i2 < bytesRead; ++i2) {
                    sb.append(buf[i2]);
                }
            }
            char[] cArray = sb.toChars();
            return cArray;
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    static {
        try {
            double version = Double.parseDouble(System.getProperty("java.version").substring(0, 3));
            if (version < 1.5) {
                throw new RuntimeException("unsupported java version: " + version);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("unable to initialize math processor", e);
        }
        RESOLVED_METH_CACHE = new WeakHashMap<String, Map<Integer, WeakReference<Method>>>(10);
        RESOLVED_CONST_CACHE = new WeakHashMap<Class, Map<Integer, WeakReference<Constructor>>>(10);
        CONSTRUCTOR_PARMS_CACHE = new WeakHashMap<Constructor, WeakReference<Class[]>>(10);
        CLASS_RESOLVER_CACHE = new WeakHashMap<ClassLoader, Map<String, WeakReference<Class>>>(1, 1.0f);
        CLASS_CONSTRUCTOR_CACHE = new WeakHashMap<Class, WeakReference<Constructor[]>>(10);
        HashMap<Class, Integer> t = typeResolveMap = new HashMap();
        t.put(BigDecimal.class, 110);
        t.put(BigInteger.class, 111);
        t.put(String.class, 1);
        t.put(Integer.TYPE, 101);
        t.put(Integer.class, 106);
        t.put(Short.TYPE, 100);
        t.put(Short.class, 105);
        t.put(Float.TYPE, 104);
        t.put(Float.class, 108);
        t.put(Double.TYPE, 103);
        t.put(Double.class, 109);
        t.put(Long.TYPE, 102);
        t.put(Long.class, 107);
        t.put(Boolean.TYPE, 7);
        t.put(Boolean.class, 15);
        t.put(Byte.TYPE, 9);
        t.put(Byte.class, 113);
        t.put(Character.TYPE, 8);
        t.put(Character.class, 112);
        t.put(BlankLiteral.class, 200);
        typeCodes = new HashMap<Class, Integer>(30, 0.5f);
        typeCodes.put(Integer.class, 106);
        typeCodes.put(Double.class, 109);
        typeCodes.put(Boolean.class, 15);
        typeCodes.put(String.class, 1);
        typeCodes.put(Long.class, 107);
        typeCodes.put(Short.class, 105);
        typeCodes.put(Float.class, 108);
        typeCodes.put(Byte.class, 113);
        typeCodes.put(Character.class, 112);
        typeCodes.put(BigDecimal.class, 110);
        typeCodes.put(BigInteger.class, 111);
        typeCodes.put(Integer.TYPE, 101);
        typeCodes.put(Double.TYPE, 103);
        typeCodes.put(Boolean.TYPE, 7);
        typeCodes.put(Long.TYPE, 102);
        typeCodes.put(Short.TYPE, 100);
        typeCodes.put(Float.TYPE, 104);
        typeCodes.put(Byte.TYPE, 9);
        typeCodes.put(Character.TYPE, 8);
        typeCodes.put(BlankLiteral.class, 200);
    }
}

