/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.util;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import org.elasticsearch.common.mvel2.DataConversion;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.compiler.PropertyVerifier;
import org.elasticsearch.common.mvel2.util.ParseTools;
import org.elasticsearch.common.mvel2.util.ReflectionUtil;

public class PropertyTools {
    public static boolean isEmpty(Object o) {
        if (o != null) {
            if (o instanceof Object[]) {
                return ((Object[])o).length == 0 || ((Object[])o).length == 1 && PropertyTools.isEmpty(((Object[])o)[0]);
            }
            return "".equals(String.valueOf(o)) || "null".equals(String.valueOf(o)) || o instanceof Collection && ((Collection)o).size() == 0 || o instanceof Map && ((Map)o).size() == 0;
        }
        return true;
    }

    public static Method getSetter(Class clazz, String property) {
        property = ReflectionUtil.getSetter(property);
        for (Method meth : clazz.getMethods()) {
            if ((meth.getModifiers() & 1) == 0 || meth.getParameterTypes().length != 1 || !property.equals(meth.getName())) continue;
            return meth;
        }
        return null;
    }

    public static Method getSetter(Class clazz, String property, Class type2) {
        String simple = "set" + property;
        property = ReflectionUtil.getSetter(property);
        for (Method meth : clazz.getMethods()) {
            if ((meth.getModifiers() & 1) == 0 || meth.getParameterTypes().length != 1 || !property.equals(meth.getName()) && !simple.equals(meth.getName()) || type2 != null && !DataConversion.canConvert(meth.getParameterTypes()[0], type2)) continue;
            return meth;
        }
        return null;
    }

    public static boolean hasGetter(Field field2) {
        Method meth = PropertyTools.getGetter(field2.getDeclaringClass(), field2.getName());
        return meth != null && field2.getType().isAssignableFrom(meth.getReturnType());
    }

    public static boolean hasSetter(Field field2) {
        Method meth = PropertyTools.getSetter(field2.getDeclaringClass(), field2.getName());
        return meth != null && meth.getParameterTypes().length == 1 && field2.getType().isAssignableFrom(meth.getParameterTypes()[0]);
    }

    public static Method getGetter(Class clazz, String property) {
        String simple = "get" + property;
        String isGet = ReflectionUtil.getIsGetter(property);
        property = ReflectionUtil.getGetter(property);
        Method candidate = null;
        for (Method meth : clazz.getMethods()) {
            if ((meth.getModifiers() & 1) == 0 || meth.getParameterTypes().length != 0 || !property.equals(meth.getName()) && (!isGet.equals(meth.getName()) || meth.getReturnType() != Boolean.TYPE) && !simple.equals(meth.getName()) || candidate != null && !candidate.getReturnType().isAssignableFrom(meth.getReturnType())) continue;
            candidate = meth;
        }
        return candidate;
    }

    public static Class getReturnType(Class clazz, String property, ParserContext ctx) {
        return new PropertyVerifier(property, ctx, clazz).analyze();
    }

    public static Member getFieldOrAccessor(Class clazz, String property) {
        for (Field f : clazz.getFields()) {
            if (!property.equals(f.getName())) continue;
            if ((f.getModifiers() & 1) == 0) break;
            return f;
        }
        return PropertyTools.getGetter(clazz, property);
    }

    public static Member getFieldOrWriteAccessor(Class clazz, String property) {
        try {
            Field field2 = clazz.getField(property);
            if (field2 != null && Modifier.isPublic(field2.getModifiers())) {
                return field2;
            }
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return PropertyTools.getSetter(clazz, property);
    }

    public static Member getFieldOrWriteAccessor(Class clazz, String property, Class type2) {
        for (Field f : clazz.getFields()) {
            if (!property.equals(f.getName()) || type2 != null && !DataConversion.canConvert(f.getType(), type2)) continue;
            return f;
        }
        return PropertyTools.getSetter(clazz, property, type2);
    }

    public static boolean contains(Object toCompare, Object testValue) {
        if (toCompare == null) {
            return false;
        }
        if (toCompare instanceof String) {
            return ((String)toCompare).contains(String.valueOf(testValue));
        }
        if (toCompare instanceof Collection) {
            return ((Collection)toCompare).contains(testValue);
        }
        if (toCompare instanceof Map) {
            return ((Map)toCompare).containsKey(testValue);
        }
        if (toCompare.getClass().isArray()) {
            for (Object o : (Object[])toCompare) {
                if (testValue == null && o == null) {
                    return true;
                }
                if (o == null || !o.equals(testValue)) continue;
                return true;
            }
        }
        return false;
    }

    public static Object getPrimitiveInitialValue(Class type2) {
        if (type2 == Integer.TYPE) {
            return 0;
        }
        if (type2 == Boolean.TYPE) {
            return false;
        }
        if (type2 == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (type2 == Double.TYPE) {
            return 0.0;
        }
        if (type2 == Long.TYPE) {
            return 0L;
        }
        if (type2 == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type2 == Short.TYPE) {
            return (short)0;
        }
        if (type2 == Byte.TYPE) {
            return (byte)0;
        }
        return 0;
    }

    public static boolean isAssignable(Class to, Class from) {
        return (to.isPrimitive() ? ParseTools.boxPrimitive(to) : to).isAssignableFrom(from.isPrimitive() ? ParseTools.boxPrimitive(from) : from);
    }
}

