/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.netty.buffer.AbstractChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBufferFactory;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;
import org.elasticsearch.common.netty.buffer.HeapChannelBufferFactory;
import org.elasticsearch.common.netty.util.internal.DetectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeChannelBuffer
extends AbstractChannelBuffer {
    private final ByteOrder order;
    private ChannelBuffer[] components;
    private int[] indices;
    private int lastAccessedComponentId;
    private final boolean gathering;

    public CompositeChannelBuffer(ByteOrder endianness, List<ChannelBuffer> buffers, boolean gathering) {
        this.order = endianness;
        this.gathering = gathering;
        this.setComponents(buffers);
    }

    public boolean useGathering() {
        return this.gathering && DetectionUtil.javaVersion() >= 7;
    }

    public List<ChannelBuffer> decompose(int index2, int length2) {
        int readableBytes;
        if (length2 == 0) {
            return Collections.emptyList();
        }
        if (index2 + length2 > this.capacity()) {
            throw new IndexOutOfBoundsException("Too many bytes to decompose - Need " + (index2 + length2) + ", capacity is " + this.capacity());
        }
        int componentId = this.componentId(index2);
        ArrayList<ChannelBuffer> slice = new ArrayList<ChannelBuffer>(this.components.length);
        ChannelBuffer first2 = this.components[componentId].duplicate();
        first2.readerIndex(index2 - this.indices[componentId]);
        ChannelBuffer buf = first2;
        int bytesToSlice = length2;
        do {
            if (bytesToSlice <= (readableBytes = buf.readableBytes())) {
                buf.writerIndex(buf.readerIndex() + bytesToSlice);
                slice.add(buf);
                break;
            }
            slice.add(buf);
            buf = this.components[++componentId].duplicate();
        } while ((bytesToSlice -= readableBytes) > 0);
        for (int i2 = 0; i2 < slice.size(); ++i2) {
            slice.set(i2, ((ChannelBuffer)slice.get(i2)).slice());
        }
        return slice;
    }

    private void setComponents(List<ChannelBuffer> newComponents) {
        int i2;
        assert (!newComponents.isEmpty());
        this.lastAccessedComponentId = 0;
        this.components = new ChannelBuffer[newComponents.size()];
        for (i2 = 0; i2 < this.components.length; ++i2) {
            ChannelBuffer c = newComponents.get(i2);
            if (c.order() != this.order()) {
                throw new IllegalArgumentException("All buffers must have the same endianness.");
            }
            assert (c.readerIndex() == 0);
            assert (c.writerIndex() == c.capacity());
            this.components[i2] = c;
        }
        this.indices = new int[this.components.length + 1];
        this.indices[0] = 0;
        for (i2 = 1; i2 <= this.components.length; ++i2) {
            this.indices[i2] = this.indices[i2 - 1] + this.components[i2 - 1].capacity();
        }
        this.setIndex(0, this.capacity());
    }

    private CompositeChannelBuffer(CompositeChannelBuffer buffer) {
        this.order = buffer.order;
        this.gathering = buffer.gathering;
        this.components = (ChannelBuffer[])buffer.components.clone();
        this.indices = (int[])buffer.indices.clone();
        this.setIndex(buffer.readerIndex(), buffer.writerIndex());
    }

    @Override
    public ChannelBufferFactory factory() {
        return HeapChannelBufferFactory.getInstance(this.order());
    }

    @Override
    public ByteOrder order() {
        return this.order;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int capacity() {
        return this.indices[this.components.length];
    }

    public int numComponents() {
        return this.components.length;
    }

    @Override
    public byte getByte(int index2) {
        int componentId = this.componentId(index2);
        return this.components[componentId].getByte(index2 - this.indices[componentId]);
    }

    @Override
    public short getShort(int index2) {
        int componentId = this.componentId(index2);
        if (index2 + 2 <= this.indices[componentId + 1]) {
            return this.components[componentId].getShort(index2 - this.indices[componentId]);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (short)((this.getByte(index2) & 0xFF) << 8 | this.getByte(index2 + 1) & 0xFF);
        }
        return (short)(this.getByte(index2) & 0xFF | (this.getByte(index2 + 1) & 0xFF) << 8);
    }

    @Override
    public int getUnsignedMedium(int index2) {
        int componentId = this.componentId(index2);
        if (index2 + 3 <= this.indices[componentId + 1]) {
            return this.components[componentId].getUnsignedMedium(index2 - this.indices[componentId]);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this.getShort(index2) & 0xFFFF) << 8 | this.getByte(index2 + 2) & 0xFF;
        }
        return this.getShort(index2) & 0xFFFF | (this.getByte(index2 + 2) & 0xFF) << 16;
    }

    @Override
    public int getInt(int index2) {
        int componentId = this.componentId(index2);
        if (index2 + 4 <= this.indices[componentId + 1]) {
            return this.components[componentId].getInt(index2 - this.indices[componentId]);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this.getShort(index2) & 0xFFFF) << 16 | this.getShort(index2 + 2) & 0xFFFF;
        }
        return this.getShort(index2) & 0xFFFF | (this.getShort(index2 + 2) & 0xFFFF) << 16;
    }

    @Override
    public long getLong(int index2) {
        int componentId = this.componentId(index2);
        if (index2 + 8 <= this.indices[componentId + 1]) {
            return this.components[componentId].getLong(index2 - this.indices[componentId]);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return ((long)this.getInt(index2) & 0xFFFFFFFFL) << 32 | (long)this.getInt(index2 + 4) & 0xFFFFFFFFL;
        }
        return (long)this.getInt(index2) & 0xFFFFFFFFL | ((long)this.getInt(index2 + 4) & 0xFFFFFFFFL) << 32;
    }

    @Override
    public void getBytes(int index2, byte[] dst, int dstIndex, int length2) {
        int componentId;
        if (index2 > this.capacity() - length2 || dstIndex > dst.length - length2) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Needs " + (index2 + length2) + ", maximum is " + this.capacity() + " or " + dst.length);
        }
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index must be >= 0");
        }
        if (length2 == 0) {
            return;
        }
        int i2 = componentId = this.componentId(index2);
        while (length2 > 0) {
            ChannelBuffer s2 = this.components[i2];
            int adjustment = this.indices[i2];
            int localLength = Math.min(length2, s2.capacity() - (index2 - adjustment));
            s2.getBytes(index2 - adjustment, dst, dstIndex, localLength);
            index2 += localLength;
            dstIndex += localLength;
            length2 -= localLength;
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getBytes(int index2, ByteBuffer dst) {
        int componentId = this.componentId(index2);
        int limit2 = dst.limit();
        int length2 = dst.remaining();
        if (index2 > this.capacity() - length2) {
            throw new IndexOutOfBoundsException("Too many bytes to be read - Needs " + (index2 + length2) + ", maximum is " + this.capacity());
        }
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index must be >= 0");
        }
        int i2 = componentId;
        try {
            while (length2 > 0) {
                ChannelBuffer s2 = this.components[i2];
                int adjustment = this.indices[i2];
                int localLength = Math.min(length2, s2.capacity() - (index2 - adjustment));
                dst.limit(dst.position() + localLength);
                s2.getBytes(index2 - adjustment, dst);
                index2 += localLength;
                length2 -= localLength;
                ++i2;
            }
            Object var11_10 = null;
            dst.limit(limit2);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            dst.limit(limit2);
            throw throwable;
        }
    }

    @Override
    public void getBytes(int index2, ChannelBuffer dst, int dstIndex, int length2) {
        if (index2 > this.capacity() - length2 || dstIndex > dst.capacity() - length2) {
            throw new IndexOutOfBoundsException("Too many bytes to be read - Needs " + (index2 + length2) + " or " + (dstIndex + length2) + ", maximum is " + this.capacity() + " or " + dst.capacity());
        }
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index must be >= 0");
        }
        if (length2 == 0) {
            return;
        }
        int i2 = this.componentId(index2);
        while (length2 > 0) {
            ChannelBuffer s2 = this.components[i2];
            int adjustment = this.indices[i2];
            int localLength = Math.min(length2, s2.capacity() - (index2 - adjustment));
            s2.getBytes(index2 - adjustment, dst, dstIndex, localLength);
            index2 += localLength;
            dstIndex += localLength;
            length2 -= localLength;
            ++i2;
        }
    }

    @Override
    public int getBytes(int index2, GatheringByteChannel out, int length2) throws IOException {
        if (this.useGathering()) {
            return (int)out.write(this.toByteBuffers(index2, length2));
        }
        return out.write(this.toByteBuffer(index2, length2));
    }

    @Override
    public void getBytes(int index2, OutputStream out, int length2) throws IOException {
        if (index2 > this.capacity() - length2) {
            throw new IndexOutOfBoundsException("Too many bytes to be read - needs " + (index2 + length2) + ", maximum of " + this.capacity());
        }
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index must be >= 0");
        }
        if (length2 == 0) {
            return;
        }
        int i2 = this.componentId(index2);
        while (length2 > 0) {
            ChannelBuffer s2 = this.components[i2];
            int adjustment = this.indices[i2];
            int localLength = Math.min(length2, s2.capacity() - (index2 - adjustment));
            s2.getBytes(index2 - adjustment, out, localLength);
            index2 += localLength;
            length2 -= localLength;
            ++i2;
        }
    }

    @Override
    public void setByte(int index2, int value2) {
        int componentId = this.componentId(index2);
        this.components[componentId].setByte(index2 - this.indices[componentId], value2);
    }

    @Override
    public void setShort(int index2, int value2) {
        int componentId = this.componentId(index2);
        if (index2 + 2 <= this.indices[componentId + 1]) {
            this.components[componentId].setShort(index2 - this.indices[componentId], value2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this.setByte(index2, (byte)(value2 >>> 8));
            this.setByte(index2 + 1, (byte)value2);
        } else {
            this.setByte(index2, (byte)value2);
            this.setByte(index2 + 1, (byte)(value2 >>> 8));
        }
    }

    @Override
    public void setMedium(int index2, int value2) {
        int componentId = this.componentId(index2);
        if (index2 + 3 <= this.indices[componentId + 1]) {
            this.components[componentId].setMedium(index2 - this.indices[componentId], value2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this.setShort(index2, (short)(value2 >> 8));
            this.setByte(index2 + 2, (byte)value2);
        } else {
            this.setShort(index2, (short)value2);
            this.setByte(index2 + 2, (byte)(value2 >>> 16));
        }
    }

    @Override
    public void setInt(int index2, int value2) {
        int componentId = this.componentId(index2);
        if (index2 + 4 <= this.indices[componentId + 1]) {
            this.components[componentId].setInt(index2 - this.indices[componentId], value2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this.setShort(index2, (short)(value2 >>> 16));
            this.setShort(index2 + 2, (short)value2);
        } else {
            this.setShort(index2, (short)value2);
            this.setShort(index2 + 2, (short)(value2 >>> 16));
        }
    }

    @Override
    public void setLong(int index2, long value2) {
        int componentId = this.componentId(index2);
        if (index2 + 8 <= this.indices[componentId + 1]) {
            this.components[componentId].setLong(index2 - this.indices[componentId], value2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this.setInt(index2, (int)(value2 >>> 32));
            this.setInt(index2 + 4, (int)value2);
        } else {
            this.setInt(index2, (int)value2);
            this.setInt(index2 + 4, (int)(value2 >>> 32));
        }
    }

    @Override
    public void setBytes(int index2, byte[] src, int srcIndex, int length2) {
        int componentId = this.componentId(index2);
        if (index2 > this.capacity() - length2 || srcIndex > src.length - length2) {
            throw new IndexOutOfBoundsException("Too many bytes to read - needs " + (index2 + length2) + " or " + (srcIndex + length2) + ", maximum is " + this.capacity() + " or " + src.length);
        }
        int i2 = componentId;
        while (length2 > 0) {
            ChannelBuffer s2 = this.components[i2];
            int adjustment = this.indices[i2];
            int localLength = Math.min(length2, s2.capacity() - (index2 - adjustment));
            s2.setBytes(index2 - adjustment, src, srcIndex, localLength);
            index2 += localLength;
            srcIndex += localLength;
            length2 -= localLength;
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytes(int index2, ByteBuffer src) {
        int componentId = this.componentId(index2);
        int limit2 = src.limit();
        int length2 = src.remaining();
        if (index2 > this.capacity() - length2) {
            throw new IndexOutOfBoundsException("Too many bytes to be written - Needs " + (index2 + length2) + ", maximum is " + this.capacity());
        }
        int i2 = componentId;
        try {
            while (length2 > 0) {
                ChannelBuffer s2 = this.components[i2];
                int adjustment = this.indices[i2];
                int localLength = Math.min(length2, s2.capacity() - (index2 - adjustment));
                src.limit(src.position() + localLength);
                s2.setBytes(index2 - adjustment, src);
                index2 += localLength;
                length2 -= localLength;
                ++i2;
            }
            Object var11_10 = null;
            src.limit(limit2);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            src.limit(limit2);
            throw throwable;
        }
    }

    @Override
    public void setBytes(int index2, ChannelBuffer src, int srcIndex, int length2) {
        int componentId = this.componentId(index2);
        if (index2 > this.capacity() - length2 || srcIndex > src.capacity() - length2) {
            throw new IndexOutOfBoundsException("Too many bytes to be written - Needs " + (index2 + length2) + " or " + (srcIndex + length2) + ", maximum is " + this.capacity() + " or " + src.capacity());
        }
        int i2 = componentId;
        while (length2 > 0) {
            ChannelBuffer s2 = this.components[i2];
            int adjustment = this.indices[i2];
            int localLength = Math.min(length2, s2.capacity() - (index2 - adjustment));
            s2.setBytes(index2 - adjustment, src, srcIndex, localLength);
            index2 += localLength;
            srcIndex += localLength;
            length2 -= localLength;
            ++i2;
        }
    }

    @Override
    public int setBytes(int index2, InputStream in, int length2) throws IOException {
        int componentId = this.componentId(index2);
        if (index2 > this.capacity() - length2) {
            throw new IndexOutOfBoundsException("Too many bytes to write - Needs " + (index2 + length2) + ", maximum is " + this.capacity());
        }
        int i2 = componentId;
        int readBytes = 0;
        do {
            int localLength;
            int adjustment;
            ChannelBuffer s2;
            int localReadBytes;
            if ((localReadBytes = (s2 = this.components[i2]).setBytes(index2 - (adjustment = this.indices[i2]), in, localLength = Math.min(length2, s2.capacity() - (index2 - adjustment)))) < 0) {
                if (readBytes != 0) break;
                return -1;
            }
            if (localReadBytes == localLength) {
                index2 += localLength;
                length2 -= localLength;
                readBytes += localLength;
                ++i2;
                continue;
            }
            index2 += localReadBytes;
            length2 -= localReadBytes;
            readBytes += localReadBytes;
        } while (length2 > 0);
        return readBytes;
    }

    @Override
    public int setBytes(int index2, ScatteringByteChannel in, int length2) throws IOException {
        int localLength;
        int adjustment;
        ChannelBuffer s2;
        int localReadBytes;
        int componentId = this.componentId(index2);
        if (index2 > this.capacity() - length2) {
            throw new IndexOutOfBoundsException("Too many bytes to write - Needs " + (index2 + length2) + ", maximum is " + this.capacity());
        }
        int i2 = componentId;
        int readBytes = 0;
        while ((localReadBytes = (s2 = this.components[i2]).setBytes(index2 - (adjustment = this.indices[i2]), in, localLength = Math.min(length2, s2.capacity() - (index2 - adjustment)))) != 0) {
            if (localReadBytes < 0) {
                if (readBytes != 0) break;
                return -1;
            }
            if (localReadBytes == localLength) {
                index2 += localLength;
                length2 -= localLength;
                readBytes += localLength;
                ++i2;
            } else {
                index2 += localReadBytes;
                length2 -= localReadBytes;
                readBytes += localReadBytes;
            }
            if (length2 > 0) continue;
        }
        return readBytes;
    }

    @Override
    public ChannelBuffer duplicate() {
        CompositeChannelBuffer duplicate = new CompositeChannelBuffer(this);
        duplicate.setIndex(this.readerIndex(), this.writerIndex());
        return duplicate;
    }

    @Override
    public ChannelBuffer copy(int index2, int length2) {
        int componentId = this.componentId(index2);
        if (index2 > this.capacity() - length2) {
            throw new IndexOutOfBoundsException("Too many bytes to copy - Needs " + (index2 + length2) + ", maximum is " + this.capacity());
        }
        ChannelBuffer dst = this.factory().getBuffer(this.order(), length2);
        this.copyTo(index2, length2, componentId, dst);
        return dst;
    }

    private void copyTo(int index2, int length2, int componentId, ChannelBuffer dst) {
        int dstIndex = 0;
        int i2 = componentId;
        while (length2 > 0) {
            ChannelBuffer s2 = this.components[i2];
            int adjustment = this.indices[i2];
            int localLength = Math.min(length2, s2.capacity() - (index2 - adjustment));
            s2.getBytes(index2 - adjustment, dst, dstIndex, localLength);
            index2 += localLength;
            dstIndex += localLength;
            length2 -= localLength;
            ++i2;
        }
        dst.writerIndex(dst.capacity());
    }

    public ChannelBuffer getBuffer(int index2) {
        if (index2 < 0 || index2 >= this.capacity()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index2 + " - Bytes needed: " + index2 + ", maximum is " + this.capacity());
        }
        return this.components[this.componentId(index2)];
    }

    @Override
    public ChannelBuffer slice(int index2, int length2) {
        if (index2 == 0) {
            if (length2 == 0) {
                return ChannelBuffers.EMPTY_BUFFER;
            }
        } else {
            if (index2 < 0 || index2 > this.capacity() - length2) {
                throw new IndexOutOfBoundsException("Invalid index: " + index2 + " - Bytes needed: " + (index2 + length2) + ", maximum is " + this.capacity());
            }
            if (length2 == 0) {
                return ChannelBuffers.EMPTY_BUFFER;
            }
        }
        List<ChannelBuffer> components = this.decompose(index2, length2);
        switch (components.size()) {
            case 0: {
                return ChannelBuffers.EMPTY_BUFFER;
            }
            case 1: {
                return components.get(0);
            }
        }
        return new CompositeChannelBuffer(this.order(), components, this.gathering);
    }

    @Override
    public ByteBuffer toByteBuffer(int index2, int length2) {
        if (this.components.length == 1) {
            return this.components[0].toByteBuffer(index2, length2);
        }
        ByteBuffer[] buffers = this.toByteBuffers(index2, length2);
        ByteBuffer merged = ByteBuffer.allocate(length2).order(this.order());
        for (ByteBuffer b : buffers) {
            merged.put(b);
        }
        merged.flip();
        return merged;
    }

    @Override
    public ByteBuffer[] toByteBuffers(int index2, int length2) {
        if (index2 + length2 > this.capacity()) {
            throw new IndexOutOfBoundsException("Too many bytes to convert - Needs" + (index2 + length2) + ", maximum is " + this.capacity());
        }
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index must be >= 0");
        }
        if (length2 == 0) {
            return new ByteBuffer[0];
        }
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.components.length);
        int i2 = this.componentId(index2);
        while (length2 > 0) {
            ChannelBuffer s2 = this.components[i2];
            int adjustment = this.indices[i2];
            int localLength = Math.min(length2, s2.capacity() - (index2 - adjustment));
            buffers.add(s2.toByteBuffer(index2 - adjustment, localLength));
            index2 += localLength;
            length2 -= localLength;
            ++i2;
        }
        return buffers.toArray(new ByteBuffer[buffers.size()]);
    }

    private int componentId(int index2) {
        int lastComponentId = this.lastAccessedComponentId;
        if (index2 >= this.indices[lastComponentId]) {
            if (index2 < this.indices[lastComponentId + 1]) {
                return lastComponentId;
            }
            for (int i2 = lastComponentId + 1; i2 < this.components.length; ++i2) {
                if (index2 >= this.indices[i2 + 1]) continue;
                this.lastAccessedComponentId = i2;
                return i2;
            }
        } else {
            for (int i3 = lastComponentId - 1; i3 >= 0; --i3) {
                if (index2 < this.indices[i3]) continue;
                this.lastAccessedComponentId = i3;
                return i3;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + index2 + ", maximum: " + this.indices.length);
    }

    @Override
    public void discardReadBytes() {
        int localReaderIndex = this.readerIndex();
        if (localReaderIndex == 0) {
            return;
        }
        int localWriterIndex = this.writerIndex();
        int bytesToMove = this.capacity() - localReaderIndex;
        List<ChannelBuffer> list2 = this.decompose(localReaderIndex, bytesToMove);
        if (list2.isEmpty()) {
            list2 = new ArrayList<ChannelBuffer>(1);
        }
        ChannelBuffer padding = ChannelBuffers.buffer(this.order(), localReaderIndex);
        padding.writerIndex(localReaderIndex);
        list2.add(padding);
        int localMarkedReaderIndex = localReaderIndex;
        try {
            this.resetReaderIndex();
            localMarkedReaderIndex = this.readerIndex();
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        int localMarkedWriterIndex = localWriterIndex;
        try {
            this.resetWriterIndex();
            localMarkedWriterIndex = this.writerIndex();
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        this.setComponents(list2);
        localMarkedReaderIndex = Math.max(localMarkedReaderIndex - localReaderIndex, 0);
        localMarkedWriterIndex = Math.max(localMarkedWriterIndex - localReaderIndex, 0);
        this.setIndex(localMarkedReaderIndex, localMarkedWriterIndex);
        this.markReaderIndex();
        this.markWriterIndex();
        localWriterIndex = Math.max(localWriterIndex - localReaderIndex, 0);
        this.setIndex(0, localWriterIndex);
    }

    @Override
    public String toString() {
        String result2 = super.toString();
        result2 = result2.substring(0, result2.length() - 1);
        return result2 + ", components=" + this.components.length + ')';
    }
}

