/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.elasticsearch.common.netty.buffer.AbstractChannelBufferFactory;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBufferFactory;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;

public class HeapChannelBufferFactory
extends AbstractChannelBufferFactory {
    private static final HeapChannelBufferFactory INSTANCE_BE = new HeapChannelBufferFactory(ByteOrder.BIG_ENDIAN);
    private static final HeapChannelBufferFactory INSTANCE_LE = new HeapChannelBufferFactory(ByteOrder.LITTLE_ENDIAN);

    public static ChannelBufferFactory getInstance() {
        return INSTANCE_BE;
    }

    public static ChannelBufferFactory getInstance(ByteOrder endianness) {
        if (endianness == ByteOrder.BIG_ENDIAN) {
            return INSTANCE_BE;
        }
        if (endianness == ByteOrder.LITTLE_ENDIAN) {
            return INSTANCE_LE;
        }
        if (endianness == null) {
            throw new NullPointerException("endianness");
        }
        throw new IllegalStateException("Should not reach here");
    }

    public HeapChannelBufferFactory() {
    }

    public HeapChannelBufferFactory(ByteOrder defaultOrder) {
        super(defaultOrder);
    }

    public ChannelBuffer getBuffer(ByteOrder order2, int capacity) {
        return ChannelBuffers.buffer(order2, capacity);
    }

    public ChannelBuffer getBuffer(ByteOrder order2, byte[] array, int offset2, int length2) {
        return ChannelBuffers.wrappedBuffer(order2, array, offset2, length2);
    }

    public ChannelBuffer getBuffer(ByteBuffer nioBuffer) {
        if (nioBuffer.hasArray()) {
            return ChannelBuffers.wrappedBuffer(nioBuffer);
        }
        ChannelBuffer buf = this.getBuffer(nioBuffer.order(), nioBuffer.remaining());
        int pos2 = nioBuffer.position();
        buf.writeBytes(nioBuffer);
        nioBuffer.position(pos2);
        return buf;
    }
}

