/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.buffer;

import java.nio.ByteOrder;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBufferFactory;
import org.elasticsearch.common.netty.buffer.HeapChannelBuffer;
import org.elasticsearch.common.netty.buffer.HeapChannelBufferFactory;

public class LittleEndianHeapChannelBuffer
extends HeapChannelBuffer {
    public LittleEndianHeapChannelBuffer(int length2) {
        super(length2);
    }

    public LittleEndianHeapChannelBuffer(byte[] array) {
        super(array);
    }

    private LittleEndianHeapChannelBuffer(byte[] array, int readerIndex, int writerIndex) {
        super(array, readerIndex, writerIndex);
    }

    public ChannelBufferFactory factory() {
        return HeapChannelBufferFactory.getInstance(ByteOrder.LITTLE_ENDIAN);
    }

    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    public short getShort(int index2) {
        return (short)(this.array[index2] & 0xFF | this.array[index2 + 1] << 8);
    }

    public int getUnsignedMedium(int index2) {
        return this.array[index2] & 0xFF | (this.array[index2 + 1] & 0xFF) << 8 | (this.array[index2 + 2] & 0xFF) << 16;
    }

    public int getInt(int index2) {
        return this.array[index2] & 0xFF | (this.array[index2 + 1] & 0xFF) << 8 | (this.array[index2 + 2] & 0xFF) << 16 | (this.array[index2 + 3] & 0xFF) << 24;
    }

    public long getLong(int index2) {
        return (long)this.array[index2] & 0xFFL | ((long)this.array[index2 + 1] & 0xFFL) << 8 | ((long)this.array[index2 + 2] & 0xFFL) << 16 | ((long)this.array[index2 + 3] & 0xFFL) << 24 | ((long)this.array[index2 + 4] & 0xFFL) << 32 | ((long)this.array[index2 + 5] & 0xFFL) << 40 | ((long)this.array[index2 + 6] & 0xFFL) << 48 | ((long)this.array[index2 + 7] & 0xFFL) << 56;
    }

    public void setShort(int index2, int value2) {
        this.array[index2] = (byte)value2;
        this.array[index2 + 1] = (byte)(value2 >>> 8);
    }

    public void setMedium(int index2, int value2) {
        this.array[index2] = (byte)value2;
        this.array[index2 + 1] = (byte)(value2 >>> 8);
        this.array[index2 + 2] = (byte)(value2 >>> 16);
    }

    public void setInt(int index2, int value2) {
        this.array[index2] = (byte)value2;
        this.array[index2 + 1] = (byte)(value2 >>> 8);
        this.array[index2 + 2] = (byte)(value2 >>> 16);
        this.array[index2 + 3] = (byte)(value2 >>> 24);
    }

    public void setLong(int index2, long value2) {
        this.array[index2] = (byte)value2;
        this.array[index2 + 1] = (byte)(value2 >>> 8);
        this.array[index2 + 2] = (byte)(value2 >>> 16);
        this.array[index2 + 3] = (byte)(value2 >>> 24);
        this.array[index2 + 4] = (byte)(value2 >>> 32);
        this.array[index2 + 5] = (byte)(value2 >>> 40);
        this.array[index2 + 6] = (byte)(value2 >>> 48);
        this.array[index2 + 7] = (byte)(value2 >>> 56);
    }

    public ChannelBuffer duplicate() {
        return new LittleEndianHeapChannelBuffer(this.array, this.readerIndex(), this.writerIndex());
    }

    public ChannelBuffer copy(int index2, int length2) {
        if (index2 < 0 || length2 < 0 || index2 + length2 > this.array.length) {
            throw new IndexOutOfBoundsException("Too many bytes to copy - Need " + (index2 + length2) + ", maximum is " + this.array.length);
        }
        byte[] copiedArray = new byte[length2];
        System.arraycopy(this.array, index2, copiedArray, 0, length2);
        return new LittleEndianHeapChannelBuffer(copiedArray);
    }
}

