/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import org.elasticsearch.common.netty.buffer.AbstractChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBufferFactory;
import org.elasticsearch.common.netty.buffer.WrappedChannelBuffer;

public class ReadOnlyChannelBuffer
extends AbstractChannelBuffer
implements WrappedChannelBuffer {
    private final ChannelBuffer buffer;

    public ReadOnlyChannelBuffer(ChannelBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        this.buffer = buffer;
        this.setIndex(buffer.readerIndex(), buffer.writerIndex());
    }

    private ReadOnlyChannelBuffer(ReadOnlyChannelBuffer buffer) {
        this.buffer = buffer.buffer;
        this.setIndex(buffer.readerIndex(), buffer.writerIndex());
    }

    public ChannelBuffer unwrap() {
        return this.buffer;
    }

    public ChannelBufferFactory factory() {
        return this.buffer.factory();
    }

    public ByteOrder order() {
        return this.buffer.order();
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public boolean hasArray() {
        return false;
    }

    public byte[] array() {
        throw new ReadOnlyBufferException();
    }

    public int arrayOffset() {
        throw new ReadOnlyBufferException();
    }

    public void discardReadBytes() {
        throw new ReadOnlyBufferException();
    }

    public void setByte(int index2, int value2) {
        throw new ReadOnlyBufferException();
    }

    public void setBytes(int index2, ChannelBuffer src, int srcIndex, int length2) {
        throw new ReadOnlyBufferException();
    }

    public void setBytes(int index2, byte[] src, int srcIndex, int length2) {
        throw new ReadOnlyBufferException();
    }

    public void setBytes(int index2, ByteBuffer src) {
        throw new ReadOnlyBufferException();
    }

    public void setShort(int index2, int value2) {
        throw new ReadOnlyBufferException();
    }

    public void setMedium(int index2, int value2) {
        throw new ReadOnlyBufferException();
    }

    public void setInt(int index2, int value2) {
        throw new ReadOnlyBufferException();
    }

    public void setLong(int index2, long value2) {
        throw new ReadOnlyBufferException();
    }

    public int setBytes(int index2, InputStream in, int length2) throws IOException {
        throw new ReadOnlyBufferException();
    }

    public int setBytes(int index2, ScatteringByteChannel in, int length2) throws IOException {
        throw new ReadOnlyBufferException();
    }

    public int getBytes(int index2, GatheringByteChannel out, int length2) throws IOException {
        return this.buffer.getBytes(index2, out, length2);
    }

    public void getBytes(int index2, OutputStream out, int length2) throws IOException {
        this.buffer.getBytes(index2, out, length2);
    }

    public void getBytes(int index2, byte[] dst, int dstIndex, int length2) {
        this.buffer.getBytes(index2, dst, dstIndex, length2);
    }

    public void getBytes(int index2, ChannelBuffer dst, int dstIndex, int length2) {
        this.buffer.getBytes(index2, dst, dstIndex, length2);
    }

    public void getBytes(int index2, ByteBuffer dst) {
        this.buffer.getBytes(index2, dst);
    }

    public ChannelBuffer duplicate() {
        return new ReadOnlyChannelBuffer(this);
    }

    public ChannelBuffer copy(int index2, int length2) {
        return this.buffer.copy(index2, length2);
    }

    public ChannelBuffer slice(int index2, int length2) {
        return new ReadOnlyChannelBuffer(this.buffer.slice(index2, length2));
    }

    public byte getByte(int index2) {
        return this.buffer.getByte(index2);
    }

    public short getShort(int index2) {
        return this.buffer.getShort(index2);
    }

    public int getUnsignedMedium(int index2) {
        return this.buffer.getUnsignedMedium(index2);
    }

    public int getInt(int index2) {
        return this.buffer.getInt(index2);
    }

    public long getLong(int index2) {
        return this.buffer.getLong(index2);
    }

    public ByteBuffer toByteBuffer(int index2, int length2) {
        return this.buffer.toByteBuffer(index2, length2).asReadOnlyBuffer();
    }

    public ByteBuffer[] toByteBuffers(int index2, int length2) {
        ByteBuffer[] bufs = this.buffer.toByteBuffers(index2, length2);
        for (int i2 = 0; i2 < bufs.length; ++i2) {
            bufs[i2] = bufs[i2].asReadOnlyBuffer();
        }
        return bufs;
    }

    public int capacity() {
        return this.buffer.capacity();
    }
}

