/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import org.elasticsearch.common.netty.buffer.AbstractChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBufferFactory;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;
import org.elasticsearch.common.netty.buffer.WrappedChannelBuffer;

public class SlicedChannelBuffer
extends AbstractChannelBuffer
implements WrappedChannelBuffer {
    private final ChannelBuffer buffer;
    private final int adjustment;
    private final int length;

    public SlicedChannelBuffer(ChannelBuffer buffer, int index2, int length2) {
        if (index2 < 0 || index2 > buffer.capacity()) {
            throw new IndexOutOfBoundsException("Invalid index of " + index2 + ", maximum is " + buffer.capacity());
        }
        if (index2 + length2 > buffer.capacity()) {
            throw new IndexOutOfBoundsException("Invalid combined index of " + (index2 + length2) + ", maximum is " + buffer.capacity());
        }
        this.buffer = buffer;
        this.adjustment = index2;
        this.length = length2;
        this.writerIndex(length2);
    }

    public ChannelBuffer unwrap() {
        return this.buffer;
    }

    public ChannelBufferFactory factory() {
        return this.buffer.factory();
    }

    public ByteOrder order() {
        return this.buffer.order();
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public int capacity() {
        return this.length;
    }

    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    public byte[] array() {
        return this.buffer.array();
    }

    public int arrayOffset() {
        return this.buffer.arrayOffset() + this.adjustment;
    }

    public byte getByte(int index2) {
        this.checkIndex(index2);
        return this.buffer.getByte(index2 + this.adjustment);
    }

    public short getShort(int index2) {
        this.checkIndex(index2, 2);
        return this.buffer.getShort(index2 + this.adjustment);
    }

    public int getUnsignedMedium(int index2) {
        this.checkIndex(index2, 3);
        return this.buffer.getUnsignedMedium(index2 + this.adjustment);
    }

    public int getInt(int index2) {
        this.checkIndex(index2, 4);
        return this.buffer.getInt(index2 + this.adjustment);
    }

    public long getLong(int index2) {
        this.checkIndex(index2, 8);
        return this.buffer.getLong(index2 + this.adjustment);
    }

    public ChannelBuffer duplicate() {
        SlicedChannelBuffer duplicate = new SlicedChannelBuffer(this.buffer, this.adjustment, this.length);
        duplicate.setIndex(this.readerIndex(), this.writerIndex());
        return duplicate;
    }

    public ChannelBuffer copy(int index2, int length2) {
        this.checkIndex(index2, length2);
        return this.buffer.copy(index2 + this.adjustment, length2);
    }

    public ChannelBuffer slice(int index2, int length2) {
        this.checkIndex(index2, length2);
        if (length2 == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        return new SlicedChannelBuffer(this.buffer, index2 + this.adjustment, length2);
    }

    public void getBytes(int index2, ChannelBuffer dst, int dstIndex, int length2) {
        this.checkIndex(index2, length2);
        this.buffer.getBytes(index2 + this.adjustment, dst, dstIndex, length2);
    }

    public void getBytes(int index2, byte[] dst, int dstIndex, int length2) {
        this.checkIndex(index2, length2);
        this.buffer.getBytes(index2 + this.adjustment, dst, dstIndex, length2);
    }

    public void getBytes(int index2, ByteBuffer dst) {
        this.checkIndex(index2, dst.remaining());
        this.buffer.getBytes(index2 + this.adjustment, dst);
    }

    public void setByte(int index2, int value2) {
        this.checkIndex(index2);
        this.buffer.setByte(index2 + this.adjustment, value2);
    }

    public void setShort(int index2, int value2) {
        this.checkIndex(index2, 2);
        this.buffer.setShort(index2 + this.adjustment, value2);
    }

    public void setMedium(int index2, int value2) {
        this.checkIndex(index2, 3);
        this.buffer.setMedium(index2 + this.adjustment, value2);
    }

    public void setInt(int index2, int value2) {
        this.checkIndex(index2, 4);
        this.buffer.setInt(index2 + this.adjustment, value2);
    }

    public void setLong(int index2, long value2) {
        this.checkIndex(index2, 8);
        this.buffer.setLong(index2 + this.adjustment, value2);
    }

    public void setBytes(int index2, byte[] src, int srcIndex, int length2) {
        this.checkIndex(index2, length2);
        this.buffer.setBytes(index2 + this.adjustment, src, srcIndex, length2);
    }

    public void setBytes(int index2, ChannelBuffer src, int srcIndex, int length2) {
        this.checkIndex(index2, length2);
        this.buffer.setBytes(index2 + this.adjustment, src, srcIndex, length2);
    }

    public void setBytes(int index2, ByteBuffer src) {
        this.checkIndex(index2, src.remaining());
        this.buffer.setBytes(index2 + this.adjustment, src);
    }

    public void getBytes(int index2, OutputStream out, int length2) throws IOException {
        this.checkIndex(index2, length2);
        this.buffer.getBytes(index2 + this.adjustment, out, length2);
    }

    public int getBytes(int index2, GatheringByteChannel out, int length2) throws IOException {
        this.checkIndex(index2, length2);
        return this.buffer.getBytes(index2 + this.adjustment, out, length2);
    }

    public int setBytes(int index2, InputStream in, int length2) throws IOException {
        this.checkIndex(index2, length2);
        return this.buffer.setBytes(index2 + this.adjustment, in, length2);
    }

    public int setBytes(int index2, ScatteringByteChannel in, int length2) throws IOException {
        this.checkIndex(index2, length2);
        return this.buffer.setBytes(index2 + this.adjustment, in, length2);
    }

    public ByteBuffer toByteBuffer(int index2, int length2) {
        this.checkIndex(index2, length2);
        return this.buffer.toByteBuffer(index2 + this.adjustment, length2);
    }

    private void checkIndex(int index2) {
        if (index2 < 0 || index2 >= this.capacity()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index2 + ", maximum is " + this.capacity());
        }
    }

    private void checkIndex(int startIndex, int length2) {
        if (length2 < 0) {
            throw new IllegalArgumentException("length is negative: " + length2);
        }
        if (startIndex < 0) {
            throw new IndexOutOfBoundsException("startIndex cannot be negative");
        }
        if (startIndex + length2 > this.capacity()) {
            throw new IndexOutOfBoundsException("Index too big - Bytes needed: " + (startIndex + length2) + ", maximum is " + this.capacity());
        }
    }
}

