/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.channel;

import org.elasticsearch.common.netty.channel.ChannelEvent;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.ChannelPipelineException;
import org.elasticsearch.common.netty.channel.ChannelSink;
import org.elasticsearch.common.netty.channel.Channels;

public abstract class AbstractChannelSink
implements ChannelSink {
    protected AbstractChannelSink() {
    }

    public void exceptionCaught(ChannelPipeline pipeline, ChannelEvent event, ChannelPipelineException cause2) throws Exception {
        Throwable actualCause = cause2.getCause();
        if (actualCause == null) {
            actualCause = cause2;
        }
        if (this.isFireExceptionCaughtLater(event, actualCause)) {
            Channels.fireExceptionCaughtLater(event.getChannel(), actualCause);
        } else {
            Channels.fireExceptionCaught(event.getChannel(), actualCause);
        }
    }

    protected boolean isFireExceptionCaughtLater(ChannelEvent event, Throwable actualCause) {
        return false;
    }

    public ChannelFuture execute(ChannelPipeline pipeline, Runnable task) {
        try {
            task.run();
            return Channels.succeededFuture(pipeline.getChannel());
        }
        catch (Throwable t) {
            return Channels.failedFuture(pipeline.getChannel(), t);
        }
    }
}

