/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.channel;

import java.util.Map;
import org.elasticsearch.common.netty.buffer.ChannelBufferFactory;
import org.elasticsearch.common.netty.buffer.HeapChannelBufferFactory;
import org.elasticsearch.common.netty.channel.ChannelConfig;
import org.elasticsearch.common.netty.channel.ChannelPipelineFactory;
import org.elasticsearch.common.netty.util.internal.ConversionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultChannelConfig
implements ChannelConfig {
    private volatile ChannelBufferFactory bufferFactory = HeapChannelBufferFactory.getInstance();
    private volatile int connectTimeoutMillis = 10000;

    @Override
    public void setOptions(Map<String, Object> options2) {
        for (Map.Entry<String, Object> e : options2.entrySet()) {
            this.setOption(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean setOption(String key2, Object value2) {
        if (key2 == null) {
            throw new NullPointerException("key");
        }
        if ("pipelineFactory".equals(key2)) {
            this.setPipelineFactory((ChannelPipelineFactory)value2);
        } else if ("connectTimeoutMillis".equals(key2)) {
            this.setConnectTimeoutMillis(ConversionUtil.toInt(value2));
        } else if ("bufferFactory".equals(key2)) {
            this.setBufferFactory((ChannelBufferFactory)value2);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    @Override
    public ChannelBufferFactory getBufferFactory() {
        return this.bufferFactory;
    }

    @Override
    public void setBufferFactory(ChannelBufferFactory bufferFactory) {
        if (bufferFactory == null) {
            throw new NullPointerException("bufferFactory");
        }
        this.bufferFactory = bufferFactory;
    }

    @Override
    public ChannelPipelineFactory getPipelineFactory() {
        return null;
    }

    @Override
    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        if (connectTimeoutMillis < 0) {
            throw new IllegalArgumentException("connectTimeoutMillis: " + connectTimeoutMillis);
        }
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    @Override
    public void setPipelineFactory(ChannelPipelineFactory pipelineFactory) {
    }
}

