/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.channel.socket.nio;

import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import org.elasticsearch.common.netty.channel.ChannelEvent;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.ChannelFutureListener;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.ChannelState;
import org.elasticsearch.common.netty.channel.ChannelStateEvent;
import org.elasticsearch.common.netty.channel.Channels;
import org.elasticsearch.common.netty.channel.MessageEvent;
import org.elasticsearch.common.netty.channel.socket.nio.AbstractNioChannelSink;
import org.elasticsearch.common.netty.channel.socket.nio.BossPool;
import org.elasticsearch.common.netty.channel.socket.nio.NioClientBoss;
import org.elasticsearch.common.netty.channel.socket.nio.NioClientSocketChannel;
import org.elasticsearch.common.netty.channel.socket.nio.NioSocketChannel;
import org.elasticsearch.common.netty.logging.InternalLogger;
import org.elasticsearch.common.netty.logging.InternalLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NioClientSocketPipelineSink
extends AbstractNioChannelSink {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(NioClientSocketPipelineSink.class);
    private final BossPool<NioClientBoss> bossPool;

    NioClientSocketPipelineSink(BossPool<NioClientBoss> bossPool) {
        this.bossPool = bossPool;
    }

    @Override
    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e;
            NioClientSocketChannel channel = (NioClientSocketChannel)event.getChannel();
            ChannelFuture future = event.getFuture();
            ChannelState state2 = event.getState();
            Object value2 = event.getValue();
            switch (state2) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value2)) break;
                    channel.worker.close(channel, future);
                    break;
                }
                case BOUND: {
                    if (value2 != null) {
                        NioClientSocketPipelineSink.bind(channel, future, (SocketAddress)value2);
                        break;
                    }
                    channel.worker.close(channel, future);
                    break;
                }
                case CONNECTED: {
                    if (value2 != null) {
                        this.connect(channel, future, (SocketAddress)value2);
                        break;
                    }
                    channel.worker.close(channel, future);
                    break;
                }
                case INTEREST_OPS: {
                    channel.worker.setInterestOps(channel, future, (Integer)value2);
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e;
            NioSocketChannel channel = (NioSocketChannel)event.getChannel();
            boolean offered = channel.writeBufferQueue.offer(event);
            assert (offered);
            channel.worker.writeFromUserCode(channel);
        }
    }

    private static void bind(NioClientSocketChannel channel, ChannelFuture future, SocketAddress localAddress) {
        try {
            ((SocketChannel)channel.channel).socket().bind(localAddress);
            channel.boundManually = true;
            channel.setBound();
            future.setSuccess();
            Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    private void connect(NioClientSocketChannel channel, final ChannelFuture cf, SocketAddress remoteAddress) {
        try {
            if (((SocketChannel)channel.channel).connect(remoteAddress)) {
                channel.worker.register(channel, cf);
            } else {
                channel.getCloseFuture().addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture f) throws Exception {
                        if (!cf.isDone()) {
                            cf.setFailure(new ClosedChannelException());
                        }
                    }
                });
                cf.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
                channel.connectFuture = cf;
                this.nextBoss().register(channel, cf);
            }
        }
        catch (Throwable t) {
            cf.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
            channel.worker.close(channel, Channels.succeededFuture(channel));
        }
    }

    private NioClientBoss nextBoss() {
        return this.bossPool.nextBoss();
    }
}

