/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.channel.socket.nio;

import java.net.SocketAddress;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelEvent;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.ChannelState;
import org.elasticsearch.common.netty.channel.ChannelStateEvent;
import org.elasticsearch.common.netty.channel.MessageEvent;
import org.elasticsearch.common.netty.channel.socket.nio.AbstractNioChannelSink;
import org.elasticsearch.common.netty.channel.socket.nio.NioServerBoss;
import org.elasticsearch.common.netty.channel.socket.nio.NioServerSocketChannel;
import org.elasticsearch.common.netty.channel.socket.nio.NioSocketChannel;

class NioServerSocketPipelineSink
extends AbstractNioChannelSink {
    NioServerSocketPipelineSink() {
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        Channel channel = e.getChannel();
        if (channel instanceof NioServerSocketChannel) {
            NioServerSocketPipelineSink.handleServerSocket(e);
        } else if (channel instanceof NioSocketChannel) {
            NioServerSocketPipelineSink.handleAcceptedSocket(e);
        }
    }

    private static void handleServerSocket(ChannelEvent e) {
        if (!(e instanceof ChannelStateEvent)) {
            return;
        }
        ChannelStateEvent event = (ChannelStateEvent)e;
        NioServerSocketChannel channel = (NioServerSocketChannel)event.getChannel();
        ChannelFuture future = event.getFuture();
        ChannelState state2 = event.getState();
        Object value2 = event.getValue();
        switch (state2) {
            case OPEN: {
                if (!Boolean.FALSE.equals(value2)) break;
                ((NioServerBoss)channel.boss).close(channel, future);
                break;
            }
            case BOUND: {
                if (value2 != null) {
                    ((NioServerBoss)channel.boss).bind(channel, future, (SocketAddress)value2);
                    break;
                }
                ((NioServerBoss)channel.boss).close(channel, future);
                break;
            }
        }
    }

    private static void handleAcceptedSocket(ChannelEvent e) {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e;
            NioSocketChannel channel = (NioSocketChannel)event.getChannel();
            ChannelFuture future = event.getFuture();
            ChannelState state2 = event.getState();
            Object value2 = event.getValue();
            switch (state2) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value2)) break;
                    channel.worker.close(channel, future);
                    break;
                }
                case BOUND: 
                case CONNECTED: {
                    if (value2 != null) break;
                    channel.worker.close(channel, future);
                    break;
                }
                case INTEREST_OPS: {
                    channel.worker.setInterestOps(channel, future, (Integer)value2);
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e;
            NioSocketChannel channel = (NioSocketChannel)event.getChannel();
            boolean offered = channel.writeBufferQueue.offer(event);
            assert (offered);
            channel.worker.writeFromUserCode(channel);
        }
    }
}

