/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.handler.codec.http;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.elasticsearch.common.netty.handler.codec.http.Cookie;
import org.elasticsearch.common.netty.handler.codec.http.CookieDateFormat;
import org.elasticsearch.common.netty.handler.codec.http.DefaultCookie;
import org.elasticsearch.common.netty.util.internal.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieDecoder {
    private static final char COMMA = ',';

    public CookieDecoder() {
    }

    @Deprecated
    public CookieDecoder(boolean lenient) {
    }

    public Set<Cookie> decode(String header) {
        int i2;
        ArrayList<String> names2 = new ArrayList<String>(8);
        ArrayList<String> values2 = new ArrayList<String>(8);
        CookieDecoder.extractKeyValuePairs(header, names2, values2);
        if (names2.isEmpty()) {
            return Collections.emptySet();
        }
        int version = 0;
        if (((String)names2.get(0)).equalsIgnoreCase("Version")) {
            try {
                version = Integer.parseInt((String)values2.get(0));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            i2 = 1;
        } else {
            i2 = 0;
        }
        if (names2.size() <= i2) {
            return Collections.emptySet();
        }
        TreeSet<Cookie> cookies = new TreeSet<Cookie>();
        while (i2 < names2.size()) {
            String name2 = (String)names2.get(i2);
            String value2 = (String)values2.get(i2);
            if (value2 == null) {
                value2 = "";
            }
            DefaultCookie c = new DefaultCookie(name2, value2);
            boolean discard = false;
            boolean secure = false;
            boolean httpOnly = false;
            String comment2 = null;
            String commentURL = null;
            String domain = null;
            String path2 = null;
            int maxAge = Integer.MIN_VALUE;
            ArrayList<Integer> ports = new ArrayList<Integer>(2);
            int j = i2 + 1;
            while (j < names2.size()) {
                name2 = (String)names2.get(j);
                value2 = (String)values2.get(j);
                if ("Discard".equalsIgnoreCase(name2)) {
                    discard = true;
                } else if ("Secure".equalsIgnoreCase(name2)) {
                    secure = true;
                } else if ("HTTPOnly".equalsIgnoreCase(name2)) {
                    httpOnly = true;
                } else if ("Comment".equalsIgnoreCase(name2)) {
                    comment2 = value2;
                } else if ("CommentURL".equalsIgnoreCase(name2)) {
                    commentURL = value2;
                } else if ("Domain".equalsIgnoreCase(name2)) {
                    domain = value2;
                } else if ("Path".equalsIgnoreCase(name2)) {
                    path2 = value2;
                } else if ("Expires".equalsIgnoreCase(name2)) {
                    try {
                        long maxAgeMillis = new CookieDateFormat().parse(value2).getTime() - System.currentTimeMillis();
                        maxAge = (int)(maxAgeMillis / 1000L) + (maxAgeMillis % 1000L != 0L ? 1 : 0);
                    }
                    catch (ParseException e) {}
                } else if ("Max-Age".equalsIgnoreCase(name2)) {
                    maxAge = Integer.parseInt(value2);
                } else if ("Version".equalsIgnoreCase(name2)) {
                    version = Integer.parseInt(value2);
                } else {
                    String[] portList;
                    if (!"Port".equalsIgnoreCase(name2)) break;
                    for (String s1 : portList = StringUtil.split(value2, ',')) {
                        try {
                            ports.add(Integer.valueOf(s1));
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                }
                ++j;
                ++i2;
            }
            c.setVersion(version);
            c.setMaxAge(maxAge);
            c.setPath(path2);
            c.setDomain(domain);
            c.setSecure(secure);
            c.setHttpOnly(httpOnly);
            if (version > 0) {
                c.setComment(comment2);
            }
            if (version > 1) {
                c.setCommentUrl(commentURL);
                c.setPorts(ports);
                c.setDiscard(discard);
            }
            cookies.add(c);
            ++i2;
        }
        return cookies;
    }

    private static void extractKeyValuePairs(String header, List<String> names2, List<String> values2) {
        int headerLen = header.length();
        int i2 = 0;
        block10: while (i2 != headerLen) {
            switch (header.charAt(i2)) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ';': {
                    ++i2;
                    continue block10;
                }
            }
            while (i2 != headerLen) {
                String value2;
                String name2;
                if (header.charAt(i2) == '$') {
                    ++i2;
                    continue;
                }
                if (i2 == headerLen) {
                    name2 = null;
                    value2 = null;
                } else {
                    int newNameStart = i2;
                    block12: while (true) {
                        switch (header.charAt(i2)) {
                            case ';': {
                                name2 = header.substring(newNameStart, i2);
                                value2 = null;
                                break block12;
                            }
                            case '=': {
                                name2 = header.substring(newNameStart, i2);
                                if (++i2 == headerLen) {
                                    value2 = "";
                                    break block12;
                                }
                                int newValueStart = i2;
                                char c = header.charAt(i2);
                                if (c == '\"' || c == '\'') {
                                    StringBuilder newValueBuf = new StringBuilder(header.length() - i2);
                                    char q = c;
                                    boolean hadBackslash = false;
                                    ++i2;
                                    block13: while (true) {
                                        if (i2 == headerLen) {
                                            value2 = newValueBuf.toString();
                                            break block12;
                                        }
                                        if (hadBackslash) {
                                            hadBackslash = false;
                                            c = header.charAt(i2++);
                                            switch (c) {
                                                case '\"': 
                                                case '\'': 
                                                case '\\': {
                                                    newValueBuf.setCharAt(newValueBuf.length() - 1, c);
                                                    continue block13;
                                                }
                                            }
                                            newValueBuf.append(c);
                                            continue;
                                        }
                                        if ((c = header.charAt(i2++)) == q) {
                                            value2 = newValueBuf.toString();
                                            break block12;
                                        }
                                        newValueBuf.append(c);
                                        if (c != '\\') continue;
                                        hadBackslash = true;
                                    }
                                }
                                int semiPos = header.indexOf(59, i2);
                                if (semiPos > 0) {
                                    value2 = header.substring(newValueStart, semiPos);
                                    i2 = semiPos;
                                    break block12;
                                }
                                value2 = header.substring(newValueStart);
                                i2 = headerLen;
                                break block12;
                            }
                            default: {
                                if (++i2 != headerLen) continue block12;
                                name2 = header.substring(newNameStart);
                                value2 = null;
                                break block12;
                            }
                        }
                        break;
                    }
                }
                names2.add(name2);
                values2.add(value2);
                continue block10;
            }
            break block10;
        }
    }
}

