/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.handler.codec.http;

import java.util.List;
import org.elasticsearch.common.netty.handler.codec.http.HttpMessage;

final class HttpCodecUtil {
    static void validateHeaderName(String name2) {
        if (name2 == null) {
            throw new NullPointerException("name");
        }
        for (int i2 = 0; i2 < name2.length(); ++i2) {
            char c = name2.charAt(i2);
            if (c > '\u007f') {
                throw new IllegalArgumentException("name contains non-ascii character: " + name2);
            }
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ':': 
                case ';': 
                case '=': {
                    throw new IllegalArgumentException("name contains one of the following prohibited characters: =,;: \\t\\r\\n\\v\\f: " + name2);
                }
            }
        }
    }

    static void validateHeaderValue(String value2) {
        if (value2 == null) {
            throw new NullPointerException("value");
        }
        int state2 = 0;
        block19: for (int i2 = 0; i2 < value2.length(); ++i2) {
            char c = value2.charAt(i2);
            switch (c) {
                case '\u000b': {
                    throw new IllegalArgumentException("value contains a prohibited character '\\v': " + value2);
                }
                case '\f': {
                    throw new IllegalArgumentException("value contains a prohibited character '\\f': " + value2);
                }
            }
            switch (state2) {
                case 0: {
                    switch (c) {
                        case '\r': {
                            state2 = 1;
                            break;
                        }
                        case '\n': {
                            state2 = 2;
                        }
                    }
                    continue block19;
                }
                case 1: {
                    switch (c) {
                        case '\n': {
                            state2 = 2;
                            continue block19;
                        }
                    }
                    throw new IllegalArgumentException("Only '\\n' is allowed after '\\r': " + value2);
                }
                case 2: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            state2 = 0;
                            continue block19;
                        }
                    }
                    throw new IllegalArgumentException("Only ' ' and '\\t' are allowed after '\\n': " + value2);
                }
            }
        }
        if (state2 != 0) {
            throw new IllegalArgumentException("value must not end with '\\r' or '\\n':" + value2);
        }
    }

    static boolean isTransferEncodingChunked(HttpMessage m) {
        List<String> chunked = m.getHeaders("Transfer-Encoding");
        if (chunked.isEmpty()) {
            return false;
        }
        for (String v : chunked) {
            if (!v.equalsIgnoreCase("chunked")) continue;
            return true;
        }
        return false;
    }

    static void removeTransferEncodingChunked(HttpMessage m) {
        List<String> values2 = m.getHeaders("Transfer-Encoding");
        values2.remove("chunked");
        m.setHeader("Transfer-Encoding", values2);
    }

    static boolean isContentLengthSet(HttpMessage m) {
        List<String> contentLength = m.getHeaders("Content-Length");
        return !contentLength.isEmpty();
    }

    private HttpCodecUtil() {
    }
}

