/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.logging;

import org.elasticsearch.common.netty.logging.InternalLogLevel;
import org.elasticsearch.common.netty.logging.InternalLogger;
import org.elasticsearch.common.netty.logging.JdkLoggerFactory;
import org.elasticsearch.common.netty.util.internal.StackTraceSimplifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InternalLoggerFactory {
    private static volatile InternalLoggerFactory defaultFactory = new JdkLoggerFactory();

    public static InternalLoggerFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static void setDefaultFactory(InternalLoggerFactory defaultFactory) {
        if (defaultFactory == null) {
            throw new NullPointerException("defaultFactory");
        }
        InternalLoggerFactory.defaultFactory = defaultFactory;
    }

    public static InternalLogger getInstance(Class<?> clazz) {
        return InternalLoggerFactory.getInstance(clazz.getName());
    }

    public static InternalLogger getInstance(String name2) {
        final InternalLogger logger = InternalLoggerFactory.getDefaultFactory().newInstance(name2);
        return new InternalLogger(){

            public void debug(String msg) {
                logger.debug(msg);
            }

            public void debug(String msg, Throwable cause2) {
                StackTraceSimplifier.simplify(cause2);
                logger.debug(msg, cause2);
            }

            public void error(String msg) {
                logger.error(msg);
            }

            public void error(String msg, Throwable cause2) {
                StackTraceSimplifier.simplify(cause2);
                logger.error(msg, cause2);
            }

            public void info(String msg) {
                logger.info(msg);
            }

            public void info(String msg, Throwable cause2) {
                StackTraceSimplifier.simplify(cause2);
                logger.info(msg, cause2);
            }

            public boolean isDebugEnabled() {
                return logger.isDebugEnabled();
            }

            public boolean isErrorEnabled() {
                return logger.isErrorEnabled();
            }

            public boolean isInfoEnabled() {
                return logger.isInfoEnabled();
            }

            public boolean isWarnEnabled() {
                return logger.isWarnEnabled();
            }

            public void warn(String msg) {
                logger.warn(msg);
            }

            public void warn(String msg, Throwable cause2) {
                StackTraceSimplifier.simplify(cause2);
                logger.warn(msg, cause2);
            }

            public boolean isEnabled(InternalLogLevel level2) {
                return logger.isEnabled(level2);
            }

            public void log(InternalLogLevel level2, String msg) {
                logger.log(level2, msg);
            }

            public void log(InternalLogLevel level2, String msg, Throwable cause2) {
                StackTraceSimplifier.simplify(cause2);
                logger.log(level2, msg, cause2);
            }
        };
    }

    public abstract InternalLogger newInstance(String var1);

    static {
        StackTraceSimplifier.simplify(new Exception());
    }
}

