/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.path;

import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;

public class PathTrie<T> {
    public static final Decoder NO_DECODER = new Decoder(){

        @Override
        public String decode(String value2) {
            return value2;
        }
    };
    private final Decoder decoder;
    private final TrieNode<T> root;
    private final char separator;
    private T rootValue;

    public PathTrie() {
        this('/', "*", NO_DECODER);
    }

    public PathTrie(Decoder decoder) {
        this('/', "*", decoder);
    }

    public PathTrie(char separator, String wildcard, Decoder decoder) {
        this.decoder = decoder;
        this.separator = separator;
        this.root = new TrieNode<Object>(new String(new char[]{separator}), null, null, wildcard);
    }

    public void insert(String path2, T value2) {
        String[] strings = Strings.splitStringToArray(path2, this.separator);
        if (strings.length == 0) {
            this.rootValue = value2;
            return;
        }
        int index2 = 0;
        if (strings.length > 0 && strings[0].isEmpty()) {
            index2 = 1;
        }
        this.root.insert(strings, index2, value2);
    }

    public T retrieve(String path2) {
        return this.retrieve(path2, null);
    }

    public T retrieve(String path2, Map<String, String> params2) {
        if (path2.length() == 0) {
            return this.rootValue;
        }
        String[] strings = Strings.splitStringToArray(path2, this.separator);
        if (strings.length == 0) {
            return this.rootValue;
        }
        int index2 = 0;
        if (strings.length > 0 && strings[0].isEmpty()) {
            index2 = 1;
        }
        return this.root.retrieve(strings, index2, params2);
    }

    public class TrieNode<T> {
        private transient String key;
        private transient T value;
        private boolean isWildcard;
        private final String wildcard;
        private transient String namedWildcard;
        private ImmutableMap<String, TrieNode<T>> children;
        private final TrieNode parent;

        public TrieNode(String key2, T value2, TrieNode parent, String wildcard) {
            this.key = key2;
            this.wildcard = wildcard;
            this.isWildcard = key2.equals(wildcard);
            this.parent = parent;
            this.value = value2;
            this.children = ImmutableMap.of();
            this.namedWildcard = this.isNamedWildcard(key2) ? key2.substring(key2.indexOf(123) + 1, key2.indexOf(125)) : null;
        }

        public void updateKeyWithNamedWildcard(String key2) {
            this.key = key2;
            this.namedWildcard = key2.substring(key2.indexOf(123) + 1, key2.indexOf(125));
        }

        public boolean isWildcard() {
            return this.isWildcard;
        }

        public synchronized void addChild(TrieNode<T> child) {
            this.children = MapBuilder.newMapBuilder(this.children).put(child.key, child).immutableMap();
        }

        public TrieNode getChild(String key2) {
            return this.children.get(key2);
        }

        public synchronized void insert(String[] path2, int index2, T value2) {
            TrieNode<Object> node;
            String token;
            if (index2 >= path2.length) {
                return;
            }
            String key2 = token = path2[index2];
            if (this.isNamedWildcard(token)) {
                key2 = this.wildcard;
            }
            if ((node = this.children.get(key2)) == null) {
                node = index2 == path2.length - 1 ? new TrieNode<T>(token, value2, this, this.wildcard) : new TrieNode<Object>(token, null, this, this.wildcard);
                this.children = MapBuilder.newMapBuilder(this.children).put(key2, node).immutableMap();
            } else {
                if (this.isNamedWildcard(token)) {
                    node.updateKeyWithNamedWildcard(token);
                }
                if (index2 == path2.length - 1) {
                    assert (node.value == null || node.value == value2);
                    if (node.value == null) {
                        node.value = value2;
                    }
                }
            }
            node.insert(path2, index2 + 1, value2);
        }

        private boolean isNamedWildcard(String key2) {
            return key2.indexOf(123) != -1 && key2.indexOf(125) != -1;
        }

        private String namedWildcard() {
            return this.namedWildcard;
        }

        private boolean isNamedWildcard() {
            return this.namedWildcard != null;
        }

        public T retrieve(String[] path2, int index2, Map<String, String> params2) {
            if (index2 >= path2.length) {
                return null;
            }
            String token = path2[index2];
            TrieNode<T> node = this.children.get(token);
            boolean usedWildcard = false;
            if (node == null) {
                node = this.children.get(this.wildcard);
                if (node == null) {
                    return null;
                }
                usedWildcard = true;
                if (params2 != null && super.isNamedWildcard()) {
                    this.put(params2, super.namedWildcard(), token);
                }
            }
            if (index2 == path2.length - 1) {
                return node.value;
            }
            T res = node.retrieve(path2, index2 + 1, params2);
            if (res == null && !usedWildcard && (node = this.children.get(this.wildcard)) != null) {
                if (params2 != null && super.isNamedWildcard()) {
                    this.put(params2, super.namedWildcard(), token);
                }
                res = node.retrieve(path2, index2 + 1, params2);
            }
            return res;
        }

        private void put(Map<String, String> params2, String key2, String value2) {
            params2.put(key2, PathTrie.this.decoder.decode(value2));
        }
    }

    public static interface Decoder {
        public String decode(String var1);
    }
}

