/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.transport;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.transport.TransportAddressSerializers;

public class BoundTransportAddress
implements Streamable {
    private TransportAddress boundAddress;
    private TransportAddress publishAddress;

    BoundTransportAddress() {
    }

    public BoundTransportAddress(TransportAddress boundAddress, TransportAddress publishAddress) {
        this.boundAddress = boundAddress;
        this.publishAddress = publishAddress;
    }

    public TransportAddress boundAddress() {
        return this.boundAddress;
    }

    public TransportAddress publishAddress() {
        return this.publishAddress;
    }

    public static BoundTransportAddress readBoundTransportAddress(StreamInput in) throws IOException {
        BoundTransportAddress addr2 = new BoundTransportAddress();
        addr2.readFrom(in);
        return addr2;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.boundAddress = TransportAddressSerializers.addressFromStream(in);
        this.publishAddress = TransportAddressSerializers.addressFromStream(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        TransportAddressSerializers.addressToStream(out, this.boundAddress);
        TransportAddressSerializers.addressToStream(out, this.publishAddress);
    }

    public String toString() {
        return "bound_address {" + this.boundAddress + "}, publish_address {" + this.publishAddress + "}";
    }
}

