/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.trove.impl.hash;

import java.util.Arrays;
import org.elasticsearch.common.trove.impl.Constants;
import org.elasticsearch.common.trove.impl.HashFunctions;
import org.elasticsearch.common.trove.impl.hash.TPrimitiveHash;
import org.elasticsearch.common.trove.procedure.TCharProcedure;

public abstract class TCharHash
extends TPrimitiveHash {
    static final long serialVersionUID = 1L;
    public transient char[] _set;
    protected char no_entry_value;
    protected boolean consumeFreeSlot;

    public TCharHash() {
        this.no_entry_value = Constants.DEFAULT_CHAR_NO_ENTRY_VALUE;
        if (this.no_entry_value != '\u0000') {
            Arrays.fill(this._set, this.no_entry_value);
        }
    }

    public TCharHash(int initialCapacity) {
        super(initialCapacity);
        this.no_entry_value = Constants.DEFAULT_CHAR_NO_ENTRY_VALUE;
        if (this.no_entry_value != '\u0000') {
            Arrays.fill(this._set, this.no_entry_value);
        }
    }

    public TCharHash(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.no_entry_value = Constants.DEFAULT_CHAR_NO_ENTRY_VALUE;
        if (this.no_entry_value != '\u0000') {
            Arrays.fill(this._set, this.no_entry_value);
        }
    }

    public TCharHash(int initialCapacity, float loadFactor, char no_entry_value) {
        super(initialCapacity, loadFactor);
        this.no_entry_value = no_entry_value;
        if (no_entry_value != '\u0000') {
            Arrays.fill(this._set, no_entry_value);
        }
    }

    public char getNoEntryValue() {
        return this.no_entry_value;
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new char[capacity];
        return capacity;
    }

    public boolean contains(char val) {
        return this.index(val) >= 0;
    }

    public boolean forEach(TCharProcedure procedure) {
        byte[] states = this._states;
        char[] set = this._set;
        int i2 = set.length;
        while (i2-- > 0) {
            if (states[i2] != 1 || procedure.execute(set[i2])) continue;
            return false;
        }
        return true;
    }

    protected void removeAt(int index2) {
        this._set[index2] = this.no_entry_value;
        super.removeAt(index2);
    }

    protected int index(char val) {
        byte[] states = this._states;
        char[] set = this._set;
        int length2 = states.length;
        int hash2 = HashFunctions.hash(val) & Integer.MAX_VALUE;
        int index2 = hash2 % length2;
        byte state2 = states[index2];
        if (state2 == 0) {
            return -1;
        }
        if (state2 == 1 && set[index2] == val) {
            return index2;
        }
        return this.indexRehashed(val, index2, hash2, state2);
    }

    int indexRehashed(char key2, int index2, int hash2, byte state2) {
        int length2 = this._set.length;
        int probe = 1 + hash2 % (length2 - 2);
        int loopIndex = index2;
        do {
            if ((index2 -= probe) < 0) {
                index2 += length2;
            }
            if ((state2 = this._states[index2]) == 0) {
                return -1;
            }
            if (key2 != this._set[index2] || state2 == 2) continue;
            return index2;
        } while (index2 != loopIndex);
        return -1;
    }

    protected int insertKey(char val) {
        int hash2 = HashFunctions.hash(val) & Integer.MAX_VALUE;
        int index2 = hash2 % this._states.length;
        byte state2 = this._states[index2];
        this.consumeFreeSlot = false;
        if (state2 == 0) {
            this.consumeFreeSlot = true;
            this.insertKeyAt(index2, val);
            return index2;
        }
        if (state2 == 1 && this._set[index2] == val) {
            return -index2 - 1;
        }
        return this.insertKeyRehash(val, index2, hash2, state2);
    }

    int insertKeyRehash(char val, int index2, int hash2, byte state2) {
        int length2 = this._set.length;
        int probe = 1 + hash2 % (length2 - 2);
        int loopIndex = index2;
        int firstRemoved = -1;
        do {
            if (state2 == 2 && firstRemoved == -1) {
                firstRemoved = index2;
            }
            if ((index2 -= probe) < 0) {
                index2 += length2;
            }
            if ((state2 = this._states[index2]) == 0) {
                if (firstRemoved != -1) {
                    this.insertKeyAt(firstRemoved, val);
                    return firstRemoved;
                }
                this.consumeFreeSlot = true;
                this.insertKeyAt(index2, val);
                return index2;
            }
            if (state2 != 1 || this._set[index2] != val) continue;
            return -index2 - 1;
        } while (index2 != loopIndex);
        if (firstRemoved != -1) {
            this.insertKeyAt(firstRemoved, val);
            return firstRemoved;
        }
        throw new IllegalStateException("No free or removed slots available. Key set full?!!");
    }

    void insertKeyAt(int index2, char val) {
        this._set[index2] = val;
        this._states[index2] = 1;
    }
}

