/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.trove.impl.hash;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.elasticsearch.common.trove.impl.hash.THash;
import org.elasticsearch.common.trove.impl.hash.TObjectHash;
import org.elasticsearch.common.trove.iterator.TIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class THashIterator<V>
implements TIterator,
Iterator<V> {
    private final TObjectHash<V> _object_hash;
    protected final THash _hash;
    protected int _expectedSize;
    protected int _index;

    protected THashIterator(TObjectHash<V> hash2) {
        this._hash = hash2;
        this._expectedSize = this._hash.size();
        this._index = this._hash.capacity();
        this._object_hash = hash2;
    }

    @Override
    public V next() {
        this.moveToNextIndex();
        return this.objectAtIndex(this._index);
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex() >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        try {
            this._hash.tempDisableAutoCompaction();
            this._hash.removeAt(this._index);
        }
        finally {
            this._hash.reenableAutoCompaction(false);
        }
        --this._expectedSize;
    }

    protected final void moveToNextIndex() {
        this._index = this.nextIndex();
        if (this._index < 0) {
            throw new NoSuchElementException();
        }
    }

    protected final int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] set = this._object_hash._set;
        int i2 = this._index;
        while (i2-- > 0 && (set[i2] == TObjectHash.FREE || set[i2] == TObjectHash.REMOVED)) {
        }
        return i2;
    }

    protected abstract V objectAtIndex(int var1);
}

