/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.unit;

import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeUnit;

public class ByteSizeValue
implements Serializable,
Streamable {
    private long size;
    private ByteSizeUnit sizeUnit;

    private ByteSizeValue() {
    }

    public ByteSizeValue(long bytes2) {
        this(bytes2, ByteSizeUnit.BYTES);
    }

    public ByteSizeValue(long size2, ByteSizeUnit sizeUnit) {
        this.size = size2;
        this.sizeUnit = sizeUnit;
    }

    public int bytesAsInt() throws ElasticSearchIllegalArgumentException {
        long bytes2 = this.bytes();
        if (bytes2 > Integer.MAX_VALUE) {
            throw new ElasticSearchIllegalArgumentException("size [" + this.toString() + "] is bigger than max int");
        }
        return (int)bytes2;
    }

    public long bytes() {
        return this.sizeUnit.toBytes(this.size);
    }

    public long getBytes() {
        return this.bytes();
    }

    public long kb() {
        return this.sizeUnit.toKB(this.size);
    }

    public long getKb() {
        return this.kb();
    }

    public long mb() {
        return this.sizeUnit.toMB(this.size);
    }

    public long getMb() {
        return this.mb();
    }

    public long gb() {
        return this.sizeUnit.toGB(this.size);
    }

    public long getGb() {
        return this.gb();
    }

    public double kbFrac() {
        return (double)this.bytes() / 1024.0;
    }

    public double getKbFrac() {
        return this.kbFrac();
    }

    public double mbFrac() {
        return (double)this.bytes() / 1048576.0;
    }

    public double getMbFrac() {
        return this.mbFrac();
    }

    public double gbFrac() {
        return (double)this.bytes() / 1.073741824E9;
    }

    public double getGbFrac() {
        return this.gbFrac();
    }

    public String toString() {
        long bytes2 = this.bytes();
        double value2 = bytes2;
        String suffix = "b";
        if (bytes2 >= 0x40000000L) {
            value2 = this.gbFrac();
            suffix = "gb";
        } else if (bytes2 >= 0x100000L) {
            value2 = this.mbFrac();
            suffix = "mb";
        } else if (bytes2 >= 1024L) {
            value2 = this.kbFrac();
            suffix = "kb";
        }
        return Strings.format1Decimals(value2, suffix);
    }

    public static ByteSizeValue parseBytesSizeValue(String sValue) throws ElasticSearchParseException {
        return ByteSizeValue.parseBytesSizeValue(sValue, null);
    }

    public static ByteSizeValue parseBytesSizeValue(String sValue, ByteSizeValue defaultValue) throws ElasticSearchParseException {
        long bytes2;
        if (sValue == null) {
            return defaultValue;
        }
        try {
            bytes2 = sValue.endsWith("k") || sValue.endsWith("K") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 1024.0) : (sValue.endsWith("kb") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 2)) * 1024.0) : (sValue.endsWith("m") || sValue.endsWith("M") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 1048576.0) : (sValue.endsWith("mb") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 2)) * 1048576.0) : (sValue.endsWith("g") || sValue.endsWith("G") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 1.073741824E9) : (sValue.endsWith("gb") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 2)) * 1.073741824E9) : (sValue.endsWith("b") ? Long.parseLong(sValue.substring(0, sValue.length() - 1)) : Long.parseLong(sValue)))))));
        }
        catch (NumberFormatException e) {
            throw new ElasticSearchParseException("Failed to parse [" + sValue + "]", e);
        }
        return new ByteSizeValue(bytes2, ByteSizeUnit.BYTES);
    }

    public static ByteSizeValue readBytesSizeValue(StreamInput in) throws IOException {
        ByteSizeValue sizeValue = new ByteSizeValue();
        sizeValue.readFrom(in);
        return sizeValue;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.size = in.readVLong();
        this.sizeUnit = ByteSizeUnit.BYTES;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.bytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteSizeValue sizeValue = (ByteSizeValue)o;
        if (this.size != sizeValue.size) {
            return false;
        }
        return this.sizeUnit == sizeValue.sizeUnit;
    }

    public int hashCode() {
        int result2 = (int)(this.size ^ this.size >>> 32);
        result2 = 31 * result2 + (this.sizeUnit != null ? this.sizeUnit.hashCode() : 0);
        return result2;
    }
}

